import defaultTheme from 'tailwindcss/defaultTheme';
import forms from '@tailwindcss/forms';

/** @type {import('tailwindcss').Config} */
export default {
    content: [
        './vendor/laravel/framework/src/Illuminate/Pagination/resources/views/*.blade.php',
        './storage/framework/views/*.php',
        './resources/views/**/*.blade.php',
    ],

    theme: {
        extend: {
            fontFamily: {
                sans: ['Figtree', ...defaultTheme.fontFamily.sans],
                serif: ['Playfair Display', ...defaultTheme.fontFamily.serif],
            },
            colors: {
                // Primary Colors
                'theme-gold': '#7A9D54',        // Sage/Olive Green (Matches Eco Village Image)
                'theme-gold-hover': '#658245',  // Darker Sage for hover
                'theme-navy': '#4A4A4A',        // Dark Gray (Text/Headings)

                // Background Colors
                'theme-cream': '#F5F9F0',       // Light Greenish Off-White
                'theme-light-green': '#E8F1DE', // Light Green for sections

                // Accent Colors
                'theme-gray': '#7a7a7a',        // Gray for secondary text
                'theme-bg-light': '#f9f9f9',    // Light gray background
            },
        },
    },

    plugins: [forms],
};
