<?php $__env->startSection('content'); ?>
    

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg mb-6">
                <div class="p-6 text-gray-900">
                    <h3 class="text-lg font-bold mb-4">Upload New Image</h3>
                    
                    <?php if(session('success')): ?>
                        <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded relative mb-4">
                            <?php echo e(session('success')); ?>

                        </div>
                    <?php endif; ?>

                    <form action="<?php echo e(route('admin.gallery.store')); ?>" method="POST" enctype="multipart/form-data" class="flex gap-4 items-end">
                        <?php echo csrf_field(); ?>
                        <div class="flex-1">
                            <label for="title" class="block text-sm font-medium text-gray-700 mb-1">Title (Optional)</label>
                            <input type="text" name="title" id="title" class="shadow-sm border rounded w-full py-2 px-3 text-gray-700">
                        </div>
                        <div class="flex-1">
                            <label for="category" class="block text-sm font-medium text-gray-700 mb-1">Category</label>
                            <select name="category" id="category" class="shadow-sm border rounded w-full py-2 px-3 text-gray-700" required>
                                <option value="general">General</option>
                                <option value="room">Room</option>
                                <option value="hall">Hall</option>
                                <option value="pool">Pool</option>
                                <option value="exterior">Exterior</option>
                            </select>
                        </div>
                        <div class="flex-1">
                            <label for="image" class="block text-sm font-medium text-gray-700 mb-1">Image</label>
                            <input type="file" name="image" id="image" class="shadow-sm border rounded w-full py-2 px-3 text-gray-700" required>
                        </div>
                        <button type="submit" class="bg-blue-500 hover:bg-blue-700 text-white font-bold py-2 px-6 rounded">
                            Upload
                        </button>
                    </form>
                </div>
            </div>

            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900">
                    <h3 class="text-lg font-bold mb-4">Gallery Images</h3>
                    <div class="grid grid-cols-2 md:grid-cols-4 gap-4">
                        <?php $__empty_1 = true; $__currentLoopData = $images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <div class="relative group">
                                <img src="<?php echo e(asset('storage/' . $image->image_path)); ?>" alt="<?php echo e($image->title); ?>" class="w-full h-48 object-cover rounded">
                                <div class="absolute inset-0 bg-black bg-opacity-50 opacity-0 group-hover:opacity-100 transition-opacity flex items-center justify-center">
                                    <div class="text-white text-center">
                                        <p class="text-sm font-bold"><?php echo e($image->title ?? 'Untitled'); ?></p>
                                        <p class="text-xs"><?php echo e(ucfirst($image->category)); ?></p>
                                        <form action="<?php echo e(route('admin.gallery.destroy', $image)); ?>" method="POST" class="mt-2" onsubmit="return confirm('Delete this image?');">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="submit" class="bg-red-500 hover:bg-red-700 text-white text-xs font-bold py-1 px-3 rounded">
                                                Delete
                                            </button>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <p class="col-span-4 text-center text-gray-500">No images uploaded yet.</p>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\Shanaka\OneDrive\Documents\hotelbooking\resources\views/admin/gallery/index.blade.php ENDPATH**/ ?>