<?php $__env->startSection('content'); ?>
    

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900">
                    <h3 class="text-lg font-bold mb-4">Customer Testimonials</h3>
                    
                    <?php if(session('success')): ?>
                        <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded relative mb-4">
                            <?php echo e(session('success')); ?>

                        </div>
                    <?php endif; ?>

                    <div class="space-y-4">
                        <?php $__empty_1 = true; $__currentLoopData = $testimonials; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $testimonial): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <div class="border rounded-lg p-4 <?php echo e($testimonial->is_approved ? 'bg-green-50' : 'bg-gray-50'); ?>">
                                <div class="flex justify-between items-start">
                                    <div class="flex-1">
                                        <div class="flex items-center gap-2 mb-2">
                                            <h4 class="font-bold text-lg"><?php echo e($testimonial->name); ?></h4>
                                            <div class="flex">
                                                <?php for($i = 1; $i <= 5; $i++): ?>
                                                    <svg class="w-4 h-4 <?php echo e($i <= $testimonial->rating ? 'text-yellow-400' : 'text-gray-300'); ?>" fill="currentColor" viewBox="0 0 20 20">
                                                        <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"/>
                                                    </svg>
                                                <?php endfor; ?>
                                            </div>
                                        </div>
                                        <p class="text-gray-700 mb-2"><?php echo e($testimonial->content); ?></p>
                                        <p class="text-xs text-gray-500">Submitted: <?php echo e($testimonial->created_at->format('M d, Y')); ?></p>
                                    </div>
                                    <div class="flex gap-2 ml-4">
                                        <form action="<?php echo e(route('admin.testimonials.update', $testimonial)); ?>" method="POST">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('PUT'); ?>
                                            <button type="submit" class="px-4 py-2 rounded text-white font-bold <?php echo e($testimonial->is_approved ? 'bg-yellow-500 hover:bg-yellow-600' : 'bg-green-500 hover:bg-green-600'); ?>">
                                                <?php echo e($testimonial->is_approved ? 'Unapprove' : 'Approve'); ?>

                                            </button>
                                        </form>
                                        <form action="<?php echo e(route('admin.testimonials.destroy', $testimonial)); ?>" method="POST" onsubmit="return confirm('Delete this testimonial?');">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="submit" class="px-4 py-2 rounded bg-red-500 hover:bg-red-600 text-white font-bold">
                                                Delete
                                            </button>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <p class="text-center text-gray-500">No testimonials yet.</p>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\Shanaka\OneDrive\Documents\hotelbooking\resources\views/admin/testimonials/index.blade.php ENDPATH**/ ?>