

<?php $__env->startSection('content'); ?>
<div class="py-12">
    <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
        <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
            <div class="p-6 text-gray-900">
                <div class="mb-6 border-b pb-4">
                    <h2 class="text-2xl font-semibold text-gray-800">Edit Event Hall</h2>
                </div>

                <form action="<?php echo e(route('admin.halls.update', $hall->id)); ?>" method="POST" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div class="mb-4">
                            <label for="name" class="block text-gray-700 text-sm font-bold mb-2">Hall Name</label>
                            <input type="text" name="name" id="name" value="<?php echo e(old('name', $hall->name)); ?>" class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline" required>
                        </div>

                        <div class="mb-4">
                            <label for="capacity" class="block text-gray-700 text-sm font-bold mb-2">Capacity (Number of guests)</label>
                            <input type="number" name="capacity" id="capacity" value="<?php echo e(old('capacity', $hall->capacity)); ?>" class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline" required>
                        </div>

                        <div class="mb-4">
                            <label for="price_per_day" class="block text-gray-700 text-sm font-bold mb-2">Price Per Day (LKR)</label>
                            <input type="number" step="0.01" name="price_per_day" id="price_per_day" value="<?php echo e(old('price_per_day', $hall->price_per_day)); ?>" class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline" required>
                        </div>

                        <div class="mb-4">
                            <label for="image" class="block text-gray-700 text-sm font-bold mb-2">Hall Image</label>
                            <input type="file" name="image" id="image" class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline">
                            <?php if($hall->image): ?>
                                <div class="mt-2">
                                    <img src="<?php echo e(asset('storage/' . $hall->image)); ?>" class="h-20 w-32 object-cover rounded">
                                    <p class="text-xs text-gray-500 mt-1">Current image</p>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>

                    <div class="mb-4">
                        <label for="description" class="block text-gray-700 text-sm font-bold mb-2">Description</label>
                        <textarea name="description" id="description" class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline" rows="4"><?php echo e(old('description', $hall->description)); ?></textarea>
                    </div>

                    <?php $hallFeatures = $hall->features ?? []; ?>
                    <div class="mb-6">
                        <label class="block text-gray-700 text-sm font-bold mb-2">Features</label>
                        <div class="grid grid-cols-2 md:grid-cols-4 gap-4">
                            <?php
                                $availableFeatures = ['Air Conditioning', 'Sound System', 'Projector', 'Stage', 'Wifi', 'Parking'];
                            ?>
                            <?php $__currentLoopData = $availableFeatures; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $feature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <label class="inline-flex items-center">
                                    <input type="checkbox" name="features[]" value="<?php echo e($feature); ?>" 
                                        <?php echo e(in_array($feature, $hallFeatures) ? 'checked' : ''); ?>

                                        class="rounded text-indigo-600 focus:ring-indigo-500">
                                    <span class="ml-2"><?php echo e($feature); ?></span>
                                </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>

                    <div class="flex items-center space-x-4">
                        <button type="submit" class="bg-indigo-600 hover:bg-indigo-700 text-white font-bold py-2 px-6 rounded transition">
                            Update Hall
                        </button>
                        <a href="<?php echo e(route('admin.halls.index')); ?>" class="text-gray-600 hover:text-gray-900">Cancel</a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\Shanaka\OneDrive\Documents\hotelbooking\resources\views/admin/halls/edit.blade.php ENDPATH**/ ?>