

<?php $__env->startSection('content'); ?>
<!-- Premium Hero Section -->
<section class="relative min-h-[50vh] flex items-end pb-12 overflow-hidden">
    <!-- Animated Background -->
    <div class="absolute inset-0 bg-gradient-to-br from-[#3d6320] via-[#558B2F] to-[#4a7a28]">
        <div class="absolute inset-0 opacity-30">
            <div class="absolute top-0 -left-10 w-96 h-96 bg-[#8bc34a] rounded-full mix-blend-multiply filter blur-3xl animate-blob"></div>
            <div class="absolute top-0 -right-10 w-96 h-96 bg-amber-500 rounded-full mix-blend-multiply filter blur-3xl animate-blob animation-delay-2000"></div>
            <div class="absolute -bottom-20 left-1/2 -translate-x-1/2 w-[30rem] h-[30rem] bg-[#558B2F]/20 rounded-full mix-blend-overlay filter blur-3xl animate-blob animation-delay-4000"></div>
        </div>
        <!-- Image Overlay with Parallax Effect -->
        <?php if($hall->image): ?>
            <img src="<?php echo e(asset('storage/' . $hall->image)); ?>" class="absolute inset-0 w-full h-full object-cover opacity-40 mix-blend-luminosity scale-105 animate-slow-zoom" alt="<?php echo e($hall->name); ?>">
        <?php endif; ?>
        <div class="absolute inset-0 bg-gradient-to-t from-[#3d6320] via-[#3d6320]/40 to-transparent"></div>
    </div>

    <!-- Floating Particles -->
    <div class="absolute inset-0 overflow-hidden pointer-events-none z-0">
        <div class="particle-float absolute w-2 h-2 bg-[#558B2F]/30 rounded-full" style="top: 20%; left: 10%; animation-delay: 0s;"></div>
        <div class="particle-float absolute w-3 h-3 bg-amber-400/20 rounded-full" style="top: 70%; left: 80%; animation-delay: 2s;"></div>
    </div>

    <div class="relative z-10 container mx-auto px-6">
        <a href="<?php echo e(route('halls.index')); ?>" class="group inline-flex items-center gap-2 text-white/70 hover:text-white mb-8 transition-all hover:-translate-x-2">
            <svg class="w-5 h-5 group-hover:stroke-amber-400" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"/></svg>
            <span class="font-bold uppercase tracking-widest text-[10px]">Back to Collection</span>
        </a>
        
        <div class="flex flex-col md:flex-row md:items-end justify-between gap-8 animate-fade-in-up">
            <div>
                <div class="inline-flex items-center gap-2 px-4 py-2 bg-white/10 backdrop-blur-md rounded-full border border-white/20 mb-6">
                    <span class="flex h-2 w-2 rounded-full bg-amber-400 animate-pulse"></span>
                    <span class="text-white/90 text-[10px] font-bold uppercase tracking-widest">Grand Event Venue</span>
                </div>
                <h1 class="text-5xl md:text-7xl font-bold text-white mb-4 leading-tight">
                    <?php echo e($hall->name); ?>

                </h1>
                <div class="flex flex-wrap items-center gap-6 text-white/80">
                    <div class="flex items-center gap-2">
                        <svg class="w-5 h-5 text-amber-400" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"/></svg>
                        <span class="font-semibold italic-none text-sm">Hosts Up to <?php echo e($hall->capacity); ?> Guests</span>
                    </div>
                </div>
            </div>
            
            <div class="bg-white/10 backdrop-blur-xl p-6 rounded-[2.5rem] border border-white/20 text-center min-w-[200px]">
                <p class="text-white/60 text-[10px] font-black uppercase tracking-[0.2em] mb-1">Investment</p>
                <div class="flex items-baseline justify-center gap-1">
                    <span class="text-white/70 text-sm font-bold">LKR</span>
                    <span class="text-3xl font-bold text-white"><?php echo e(number_format($hall->price_per_day, 0)); ?></span>
                </div>
                <p class="text-amber-400 text-[10px] font-bold uppercase tracking-widest mt-1">Per Grand Event</p>
            </div>
        </div>
    </div>
</section>

<!-- Main Interaction Section -->
<section class="py-20 bg-slate-50 relative">
    <div class="container mx-auto px-6">
        <div class="grid grid-cols-1 lg:grid-cols-12 gap-16">
            
            <!-- Details Column -->
            <div class="lg:col-span-8 space-y-12">
                <!-- Large Display Image -->
                <div class="group relative rounded-[3rem] overflow-hidden shadow-2xl animate-fade-in-up italic-none">
                    <?php if($hall->image): ?>
                        <img src="<?php echo e(asset('storage/' . $hall->image)); ?>" class="w-full h-[600px] object-cover group-hover:scale-105 transition-transform duration-700" alt="<?php echo e($hall->name); ?>">
                    <?php else: ?>
                        <div class="w-full h-[600px] bg-emerald-950 flex items-center justify-center">
                            <span class="text-8xl opacity-20 transform -rotate-12">🌿</span>
                        </div>
                    <?php endif; ?>
                    <div class="absolute inset-0 bg-gradient-to-t from-black/40 to-transparent opacity-0 group-hover:opacity-100 transition-opacity duration-500"></div>
                </div>

                <!-- Description Card -->
                <div class="bg-white rounded-[3rem] p-10 shadow-xl border border-slate-100 animate-fade-in-up animation-delay-200 italic-none">
                    <div class="flex items-center gap-4 mb-8">
                        <div class="w-12 h-1.5 bg-gradient-to-r from-[#558B2F] to-amber-500 rounded-full"></div>
                        <h2 class="text-3xl font-bold text-slate-900 leading-none">Venue Narrative</h2>
                    </div>
                    <p class="text-slate-600 text-lg leading-relaxed mb-8 italic-none">
                        <?php echo e($hall->description ?? 'Our event sanctuary offers more than just a space; it provides a transformative environment where nature and design converge. Every corner of this magnificent venue is crafted to facilitate moments that resonate deeply and last a lifetime.'); ?>

                    </p>

                    <?php if($hall->features): ?>
                        <h3 class="text-xs font-black uppercase tracking-[0.3em] text-[#558B2F] mb-6">Exquisite Amenities</h3>
                        <div class="grid grid-cols-1 sm:grid-cols-2 gap-4">
                            <?php $__currentLoopData = $hall->features; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $feature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="group flex items-center gap-4 p-5 bg-slate-50 hover:bg-[#F1F8E9] rounded-2xl transition-all border border-transparent hover:border-[#558B2F]/30 italic-none">
                                    <div class="w-10 h-10 bg-white shadow-md rounded-xl flex items-center justify-center text-[#558B2F] group-hover:scale-110 transition-transform">
                                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z"/></svg>
                                    </div>
                                    <span class="text-slate-700 font-bold text-sm italic-none"><?php echo e($feature); ?></span>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Booking Sidebar -->
            <div class="lg:col-span-4 lg:sticky lg:top-24 h-fit italic-none">
                <div class="relative bg-[#558B2F] rounded-[3rem] p-10 shadow-2xl overflow-hidden animate-fade-in-up animation-delay-400 italic-none">
                    <!-- Background blobs for form -->
                    <div class="absolute -top-10 -right-10 w-40 h-40 bg-white/20 rounded-full blur-2xl"></div>
                    <div class="absolute -bottom-10 -left-10 w-40 h-40 bg-amber-500/10 rounded-full blur-2xl"></div>
                    
                    <div class="relative z-10 italic-none">
                        <h3 class="text-2xl font-bold text-white mb-2">Request Haven</h3>
                        <p class="text-white/40 text-xs font-bold uppercase tracking-widest mb-10">Secure your grand event date</p>

                        <?php if(auth()->guard()->check()): ?>
                            <form action="<?php echo e(route('hall-bookings.store')); ?>" method="POST" class="space-y-6 italic-none">
                                <?php echo csrf_field(); ?>
                                <input type="hidden" name="hall_id" value="<?php echo e($hall->id); ?>">
                                
                                <div>
                                    <label for="event_date" class="block text-white/60 text-[10px] font-black uppercase tracking-[0.2em] mb-2 px-1">Sacred Event Date</label>
                                    <input type="date" name="event_date" id="event_date" required min="<?php echo e(date('Y-m-d')); ?>"
                                        class="w-full bg-white/5 border border-white/10 rounded-2xl px-5 py-4 text-white focus:outline-none focus:ring-2 focus:ring-[#8bc34a] focus:border-transparent transition-all shadow-inner italic-none">
                                </div>

                                <div>
                                    <label for="event_type" class="block text-white/60 text-[10px] font-black uppercase tracking-[0.2em] mb-2 px-1">Event Essence</label>
                                    <div class="relative italic-none">
                                        <select name="event_type" id="event_type" required
                                            class="w-full bg-white/5 border border-white/10 rounded-2xl px-5 py-4 text-white focus:outline-none focus:ring-2 focus:ring-[#8bc34a] focus:border-transparent transition-all shadow-inner appearance-none cursor-pointer italic-none">
                                            <option value="" class="bg-[#457025] border-none">Select the Occasion</option>
                                            <option value="Wedding" class="bg-[#457025] border-none">Wedding Sanctuary</option>
                                            <option value="Conference" class="bg-[#457025] border-none">Thought Conference</option>
                                            <option value="Birthday Party" class="bg-[#457025] border-none">Life Celebration</option>
                                            <option value="Corporate Event" class="bg-[#457025] border-none">Village Connection</option>
                                            <option value="Other" class="bg-[#457025] border-none">Other Event</option>
                                        </select>
                                        <div class="absolute right-5 top-1/2 -translate-y-1/2 pointer-events-none text-[#8bc34a] italic-none">
                                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/></svg>
                                        </div>
                                    </div>
                                </div>

                                <button type="submit" class="group relative w-full py-5 bg-gradient-to-r from-amber-400 to-amber-500 text-slate-900 rounded-2xl font-black uppercase tracking-widest text-xs hover:from-amber-500 hover:to-amber-600 transition-all shadow-xl shadow-amber-500/20 active:scale-95 italic-none">
                                    Initiate Request
                                    <span class="absolute right-6 top-1/2 -translate-y-1/2 opacity-0 group-hover:opacity-100 group-hover:translate-x-1 transition-all">✨</span>
                                </button>
                                
                                <p class="text-[9px] text-white/30 text-center uppercase tracking-widest leading-relaxed mt-6 italic-none">
                                    Final village confirmation subject to availability and nature's alignment.
                                </p>
                            </form>
                        <?php else: ?>
                            <div class="text-center py-12 bg-white/5 rounded-[2rem] border border-white/10 italic-none">
                                <div class="w-16 h-16 bg-white/10 rounded-full flex items-center justify-center mx-auto mb-6 italic-none">
                                    <span class="text-3xl">🔑</span>
                                </div>
                                <p class="text-white/80 font-bold mb-8 text-sm italic-none">Join the village community to <br>request this venue.</p>
                                <a href="<?php echo e(route('login')); ?>" class="inline-flex px-10 py-4 bg-white text-slate-900 font-bold rounded-2xl hover:bg-[#8bc34a] transition-colors italic-none">
                                    Login to Village
                                </a>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>

                <!-- Concierge Support -->
                <div class="mt-8 p-8 bg-white rounded-[2.5rem] shadow-lg border border-slate-100 flex items-center gap-6 group hover:border-[#558B2F]/30 transition-all italic-none">
                    <div class="w-14 h-14 bg-[#F1F8E9] text-[#558B2F] rounded-2xl flex items-center justify-center group-hover:bg-[#558B2F] group-hover:text-white transition-all duration-300 italic-none">
                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 12h.01M12 12h.01M16 12h.01M21 12c0 4.418-4.03 8-9 8a9.863 9.863 0 01-4.255-.949L3 20l1.395-3.72C3.512 15.042 3 13.574 3 12c0-4.418 4.03-8 9-8s9 3.582 9 8z"/></svg>
                    </div>
                    <div>
                        <p class="font-bold text-slate-900 italic-none">Need Guidance?</p>
                        <a href="<?php echo e(route('contact')); ?>" class="text-xs text-[#558B2F] font-black uppercase tracking-widest mt-1 inline-block hover:underline italic-none">Talk to Concierge</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<style>
@keyframes blob {
    0% { transform: translate(0px, 0px) scale(1); }
    33% { transform: translate(30px, -50px) scale(1.1); }
    66% { transform: translate(-20px, 20px) scale(0.9); }
    100% { transform: translate(0px, 0px) scale(1); }
}

.animate-blob {
    animation: blob 7s infinite;
}

.animation-delay-2000 {
    animation-delay: 2s;
}

.animation-delay-4000 {
    animation-delay: 4s;
}

@keyframes slow-zoom {
    0%, 100% { transform: scale(1.05); }
    50% { transform: scale(1.15); }
}

.animate-slow-zoom {
    animation: slow-zoom 20s ease-in-out infinite;
}

@keyframes fade-in-up {
    from { opacity: 0; transform: translateY(30px); }
    to { opacity: 1; transform: translateY(0); }
}

@keyframes particle-float {
    0%, 100% { transform: translateY(0) translateX(0); opacity: 0.3; }
    50% { transform: translateY(-100px) translateX(50px); opacity: 0.6; }
}

.animate-fade-in-up {
    animation: fade-in-up 0.8s ease-out forwards;
}

.particle-float {
    animation: particle-float 10s ease-in-out infinite;
}

.animation-delay-200 {
    animation-delay: 0.2s;
    animation-fill-mode: both;
}

.animation-delay-400 {
    animation-delay: 0.4s;
    animation-fill-mode: both;
}
</style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\Shanaka\OneDrive\Documents\hotelbooking\resources\views/halls/show.blade.php ENDPATH**/ ?>