

<?php $__env->startSection('page-title', 'Inquiries'); ?>

<?php $__env->startSection('content'); ?>
<!-- Page Header -->
<div class="flex flex-col sm:flex-row sm:items-center sm:justify-between mb-8">
    <div>
        <h2 class="text-2xl font-bold text-slate-900">Contact Inquiries</h2>
        <p class="text-slate-600 mt-1">Manage customer inquiries and track response status</p>
    </div>
    <div class="mt-4 sm:mt-0 flex items-center space-x-3">
        <span class="inline-flex items-center px-3 py-1.5 rounded-full text-sm font-medium bg-blue-100 text-blue-800">
            <svg class="w-4 h-4 mr-1.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/>
            </svg>
            <?php echo e($inquiries->total()); ?> Total Inquiries
        </span>
    </div>
</div>

<!-- Inquiries Table -->
<div class="bg-white rounded-2xl shadow-sm border border-slate-100 overflow-hidden">
    <div class="overflow-x-auto">
        <table class="min-w-full divide-y divide-slate-200">
            <thead class="bg-slate-50">
                <tr>
                    <th class="px-6 py-4 text-left text-xs font-semibold text-slate-600 uppercase tracking-wider">Name</th>
                    <th class="px-6 py-4 text-left text-xs font-semibold text-slate-600 uppercase tracking-wider">Email</th>
                    <th class="px-6 py-4 text-left text-xs font-semibold text-slate-600 uppercase tracking-wider">Subject</th>
                    <th class="px-6 py-4 text-left text-xs font-semibold text-slate-600 uppercase tracking-wider">Date</th>
                    <th class="px-6 py-4 text-left text-xs font-semibold text-slate-600 uppercase tracking-wider">Status</th>
                    <th class="px-6 py-4 text-right text-xs font-semibold text-slate-600 uppercase tracking-wider">Actions</th>
                </tr>
            </thead>
            <tbody class="divide-y divide-slate-100">
                <?php $__empty_1 = true; $__currentLoopData = $inquiries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $inquiry): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr class="hover:bg-slate-50 transition-colors <?php echo e(!$inquiry->is_replied ? 'bg-amber-50/50' : ''); ?>">
                        <td class="px-6 py-4 whitespace-nowrap">
                            <div class="flex items-center">
                                <div class="w-10 h-10 bg-gradient-to-br from-slate-700 to-slate-800 rounded-lg flex items-center justify-center text-white font-bold text-sm">
                                    <?php echo e(strtoupper(substr($inquiry->name, 0, 1))); ?>

                                </div>
                                <div class="ml-3">
                                    <p class="text-sm font-semibold text-slate-900"><?php echo e($inquiry->name); ?></p>
                                    <?php if($inquiry->phone): ?>
                                        <p class="text-xs text-slate-500"><?php echo e($inquiry->phone); ?></p>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <a href="mailto:<?php echo e($inquiry->email); ?>" class="text-sm text-blue-600 hover:text-blue-800 hover:underline">
                                <?php echo e($inquiry->email); ?>

                            </a>
                        </td>
                        <td class="px-6 py-4">
                            <p class="text-sm font-medium text-slate-900 truncate max-w-xs" title="<?php echo e($inquiry->subject); ?>">
                                <?php echo e($inquiry->subject); ?>

                            </p>
                            <p class="text-xs text-slate-500 truncate max-w-xs mt-1" title="<?php echo e($inquiry->message); ?>">
                                <?php echo e(Str::limit($inquiry->message, 50)); ?>

                            </p>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <p class="text-sm text-slate-900"><?php echo e($inquiry->created_at->format('M d, Y')); ?></p>
                            <p class="text-xs text-slate-500"><?php echo e($inquiry->created_at->format('h:i A')); ?></p>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <?php if($inquiry->is_replied): ?>
                                <span class="inline-flex items-center px-2.5 py-1 rounded-full text-xs font-semibold bg-green-100 text-green-800">
                                    <svg class="w-3 h-3 mr-1" fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/>
                                    </svg>
                                    Replied
                                </span>
                                <?php if($inquiry->replied_at): ?>
                                    <p class="text-xs text-slate-500 mt-1"><?php echo e($inquiry->replied_at->format('M d, Y')); ?></p>
                                <?php endif; ?>
                            <?php else: ?>
                                <span class="inline-flex items-center px-2.5 py-1 rounded-full text-xs font-semibold bg-amber-100 text-amber-800">
                                    <svg class="w-3 h-3 mr-1" fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm1-12a1 1 0 10-2 0v4a1 1 0 00.293.707l2.828 2.829a1 1 0 101.415-1.415L11 9.586V6z" clip-rule="evenodd"/>
                                    </svg>
                                    Pending
                                </span>
                            <?php endif; ?>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-right">
                            <div class="flex items-center justify-end space-x-2">
                                <!-- Toggle Reply Status -->
                                <form action="<?php echo e(route('admin.inquiries.update', $inquiry)); ?>" method="POST" class="inline">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('PUT'); ?>
                                    <button type="submit" 
                                            class="inline-flex items-center p-2 rounded-lg transition-colors <?php echo e($inquiry->is_replied ? 'text-amber-600 hover:bg-amber-50' : 'text-green-600 hover:bg-green-50'); ?>"
                                            title="<?php echo e($inquiry->is_replied ? 'Mark as Unreplied' : 'Mark as Replied'); ?>">
                                        <?php if($inquiry->is_replied): ?>
                                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                                            </svg>
                                        <?php else: ?>
                                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                                            </svg>
                                        <?php endif; ?>
                                    </button>
                                </form>

                                <!-- View Message Modal Trigger -->
                                <button type="button" 
                                        onclick="showMessage('<?php echo e(addslashes($inquiry->name)); ?>', '<?php echo e(addslashes($inquiry->subject)); ?>', `<?php echo e(addslashes($inquiry->message)); ?>`, '<?php echo e($inquiry->email); ?>', '<?php echo e($inquiry->phone ?? 'N/A'); ?>', '<?php echo e($inquiry->created_at->format('M d, Y h:i A')); ?>')"
                                        class="inline-flex items-center p-2 text-blue-600 hover:bg-blue-50 rounded-lg transition-colors"
                                        title="View Full Message">
                                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"/>
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"/>
                                    </svg>
                                </button>

                                <!-- Delete -->
                                <form action="<?php echo e(route('admin.inquiries.destroy', $inquiry)); ?>" method="POST" class="inline" onsubmit="return confirm('Are you sure you want to delete this inquiry?')">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" 
                                            class="inline-flex items-center p-2 text-red-600 hover:bg-red-50 rounded-lg transition-colors"
                                            title="Delete Inquiry">
                                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"/>
                                        </svg>
                                    </button>
                                </form>
                            </div>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="6" class="px-6 py-16 text-center">
                            <div class="flex flex-col items-center">
                                <div class="w-20 h-20 bg-slate-100 rounded-2xl flex items-center justify-center mb-4">
                                    <svg class="w-10 h-10 text-slate-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/>
                                    </svg>
                                </div>
                                <p class="text-slate-500 font-medium">No inquiries yet</p>
                                <p class="text-sm text-slate-400 mt-1">Inquiries from the contact form will appear here</p>
                            </div>
                        </td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <!-- Pagination -->
    <?php if($inquiries->hasPages()): ?>
        <div class="px-6 py-4 border-t border-slate-100">
            <?php echo e($inquiries->links()); ?>

        </div>
    <?php endif; ?>
</div>

<!-- Message View Modal -->
<div id="messageModal" class="fixed inset-0 bg-black/50 z-50 hidden items-center justify-center p-4" onclick="closeModal(event)">
    <div class="bg-white rounded-2xl shadow-2xl max-w-2xl w-full max-h-[90vh] overflow-hidden" onclick="event.stopPropagation()">
        <div class="px-6 py-4 border-b border-slate-200 flex items-center justify-between bg-slate-50">
            <h3 class="text-lg font-bold text-slate-900" id="modalTitle">Message Details</h3>
            <button onclick="document.getElementById('messageModal').classList.add('hidden'); document.getElementById('messageModal').classList.remove('flex');" 
                    class="text-slate-400 hover:text-slate-600 transition-colors">
                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/>
                </svg>
            </button>
        </div>
        <div class="p-6">
            <div class="grid grid-cols-2 gap-4 mb-6">
                <div>
                    <p class="text-xs font-semibold text-slate-500 uppercase mb-1">From</p>
                    <p class="text-sm font-medium text-slate-900" id="modalName"></p>
                </div>
                <div>
                    <p class="text-xs font-semibold text-slate-500 uppercase mb-1">Email</p>
                    <a href="#" id="modalEmail" class="text-sm text-blue-600 hover:underline"></a>
                </div>
                <div>
                    <p class="text-xs font-semibold text-slate-500 uppercase mb-1">Phone</p>
                    <p class="text-sm text-slate-900" id="modalPhone"></p>
                </div>
                <div>
                    <p class="text-xs font-semibold text-slate-500 uppercase mb-1">Date</p>
                    <p class="text-sm text-slate-900" id="modalDate"></p>
                </div>
            </div>
            <div class="mb-4">
                <p class="text-xs font-semibold text-slate-500 uppercase mb-1">Subject</p>
                <p class="text-sm font-medium text-slate-900" id="modalSubject"></p>
            </div>
            <div>
                <p class="text-xs font-semibold text-slate-500 uppercase mb-2">Message</p>
                <div class="bg-slate-50 rounded-xl p-4 max-h-64 overflow-y-auto">
                    <p class="text-sm text-slate-700 whitespace-pre-wrap" id="modalMessage"></p>
                </div>
            </div>
        </div>
        <div class="px-6 py-4 border-t border-slate-200 bg-slate-50 flex justify-end">
            <a href="#" id="replyLink" class="inline-flex items-center px-4 py-2 bg-amber-500 text-white font-semibold rounded-lg hover:bg-amber-600 transition-colors">
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/>
                </svg>
                Reply via Email
            </a>
        </div>
    </div>
</div>

<script>
function showMessage(name, subject, message, email, phone, date) {
    document.getElementById('modalName').textContent = name;
    document.getElementById('modalSubject').textContent = subject;
    document.getElementById('modalMessage').textContent = message;
    document.getElementById('modalEmail').textContent = email;
    document.getElementById('modalEmail').href = 'mailto:' + email;
    document.getElementById('modalPhone').textContent = phone;
    document.getElementById('modalDate').textContent = date;
    document.getElementById('replyLink').href = 'mailto:' + email + '?subject=Re: ' + encodeURIComponent(subject);
    document.getElementById('messageModal').classList.remove('hidden');
    document.getElementById('messageModal').classList.add('flex');
}

function closeModal(event) {
    if (event.target.id === 'messageModal') {
        document.getElementById('messageModal').classList.add('hidden');
        document.getElementById('messageModal').classList.remove('flex');
    }
}
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\Shanaka\OneDrive\Documents\hotelbooking\resources\views/admin/inquiries/index.blade.php ENDPATH**/ ?>