<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title>Admin - <?php echo e(config('app.name', 'MHEC Hotel')); ?></title>
    
    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=inter:400,500,600,700,800&display=swap" rel="stylesheet" />
    
    <!-- Scripts -->
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
    
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
    
    <style>
        [x-cloak] { display: none !important; }
    </style>
</head>
<body class="font-sans antialiased bg-gradient-to-br from-slate-50 to-slate-100">
    <?php if(isset($snow_mode) && $snow_mode === 'on'): ?>
        <?php echo $__env->make('components.snow', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <?php endif; ?>
    <div class="min-h-screen" x-data="{ sidebarOpen: true, mobileMenu: false }">
        <!-- Mobile Menu Overlay -->
        <div x-show="mobileMenu" 
             x-cloak
             @click="mobileMenu = false"
             class="fixed inset-0 bg-black/50 z-40 lg:hidden"
             x-transition:enter="transition-opacity ease-linear duration-300"
             x-transition:enter-start="opacity-0"
             x-transition:enter-end="opacity-100"
             x-transition:leave="transition-opacity ease-linear duration-300"
             x-transition:leave-start="opacity-100"
             x-transition:leave-end="opacity-0">
        </div>

        <!-- Sidebar -->
        <div :class="mobileMenu ? 'translate-x-0' : '-translate-x-full lg:translate-x-0'"
             class="fixed inset-y-0 left-0 w-72 bg-gradient-to-b from-slate-900 via-slate-800 to-slate-900 shadow-2xl z-50 transition-transform duration-300 ease-in-out flex flex-col">
            
            <!-- Logo -->
            <div class="flex-shrink-0 flex items-center justify-between h-20 px-6 border-b border-white/10">
                <div class="flex items-center space-x-3">
                    <div class="bg-gradient-to-br from-amber-400 to-amber-500 p-2 rounded-xl shadow-lg">
                        <svg class="w-8 h-8 text-slate-900" fill="currentColor" viewBox="0 0 24 24">
                            <path d="M12 2L2 7v10c0 5.55 3.84 10.74 9 12 5.16-1.26 9-6.45 9-12V7l-10-5z"/>
                        </svg>
                    </div>
                    <div>
                        <h1 class="text-white font-bold text-xl">MHEC</h1>
                        <p class="text-amber-400 text-xs font-medium">Admin Panel</p>
                    </div>
                </div>
                <button @click="mobileMenu = false" class="lg:hidden text-white">
                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/>
                    </svg>
                </button>
            </div>

            <!-- Navigation -->
            <nav class="flex-1 mt-6 px-4 space-y-2 overflow-y-auto custom-scrollbar pb-24">
                <div>
                    <p class="text-xs font-semibold text-slate-400 uppercase tracking-wider">Main Menu</p>
                </div>

                <a href="<?php echo e(route('admin.dashboard')); ?>" 
                   class="group flex items-center px-4 py-3.5 rounded-xl transition-all duration-200 <?php echo e(request()->routeIs('admin.dashboard') ? 'bg-gradient-to-r from-amber-500 to-amber-600 text-white shadow-lg shadow-amber-500/30' : 'text-slate-300 hover:bg-white/5 hover:text-white'); ?>">
                    <div class="w-10 h-10 rounded-lg flex items-center justify-center <?php echo e(request()->routeIs('admin.dashboard') ? 'bg-white/20' : 'bg-slate-700/50 group-hover:bg-slate-700'); ?> transition-colors">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6"></path>
                        </svg>
                    </div>
                    <span class="ml-3 font-semibold">Dashboard</span>
                    <?php if(request()->routeIs('admin.dashboard')): ?>
                        <svg class="w-4 h-4 ml-auto" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M7.293 14.707a1 1 0 010-1.414L10.586 10 7.293 6.707a1 1 0 011.414-1.414l4 4a1 1 0 010 1.414l-4 4a1 1 0 01-1.414 0z" clip-rule="evenodd"/>
                        </svg>
                    <?php endif; ?>
                </a>

                <a href="<?php echo e(route('admin.rooms.index')); ?>" 
                   class="group flex items-center px-4 py-3.5 rounded-xl transition-all duration-200 <?php echo e(request()->routeIs('admin.rooms.*') ? 'bg-gradient-to-r from-amber-500 to-amber-600 text-white shadow-lg shadow-amber-500/30' : 'text-slate-300 hover:bg-white/5 hover:text-white'); ?>">
                    <div class="w-10 h-10 rounded-lg flex items-center justify-center <?php echo e(request()->routeIs('admin.rooms.*') ? 'bg-white/20' : 'bg-slate-700/50 group-hover:bg-slate-700'); ?> transition-colors">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"></path>
                        </svg>
                    </div>
                    <span class="ml-3 font-semibold">Rooms</span>
                    <?php if(request()->routeIs('admin.rooms.*')): ?>
                        <svg class="w-4 h-4 ml-auto" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M7.293 14.707a1 1 0 010-1.414L10.586 10 7.293 6.707a1 1 0 011.414-1.414l4 4a1 1 0 010 1.414l-4 4a1 1 0 01-1.414 0z" clip-rule="evenodd"/>
                        </svg>
                    <?php endif; ?>
                </a>

                <a href="<?php echo e(route('admin.bookings.index')); ?>" 
                   class="group flex items-center px-4 py-3.5 rounded-xl transition-all duration-200 <?php echo e(request()->routeIs('admin.bookings.*') ? 'bg-gradient-to-r from-amber-500 to-amber-600 text-white shadow-lg shadow-amber-500/30' : 'text-slate-300 hover:bg-white/5 hover:text-white'); ?>">
                    <div class="w-10 h-10 rounded-lg flex items-center justify-center <?php echo e(request()->routeIs('admin.bookings.*') ? 'bg-white/20' : 'bg-slate-700/50 group-hover:bg-slate-700'); ?> transition-colors">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"></path>
                        </svg>
                    </div>
                    <span class="ml-3 font-semibold">Bookings</span>
                    <?php if(request()->routeIs('admin.bookings.*')): ?>
                        <svg class="w-4 h-4 ml-auto" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M7.293 14.707a1 1 0 010-1.414L10.586 10 7.293 6.707a1 1 0 011.414-1.414l4 4a1 1 0 010 1.414l-4 4a1 1 0 01-1.414 0z" clip-rule="evenodd"/>
                        </svg>
                    <?php endif; ?>
                </a>

                <a href="<?php echo e(route('admin.halls.index')); ?>" 
                   class="group flex items-center px-4 py-3.5 rounded-xl transition-all duration-200 <?php echo e(request()->routeIs('admin.halls.*') ? 'bg-gradient-to-r from-amber-500 to-amber-600 text-white shadow-lg shadow-amber-500/30' : 'text-slate-300 hover:bg-white/5 hover:text-white'); ?>">
                    <div class="w-10 h-10 rounded-lg flex items-center justify-center <?php echo e(request()->routeIs('admin.halls.*') ? 'bg-white/20' : 'bg-slate-700/50 group-hover:bg-slate-700'); ?> transition-colors">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"></path>
                        </svg>
                    </div>
                    <span class="ml-3 font-semibold">Event Halls</span>
                    <?php if(request()->routeIs('admin.halls.*')): ?>
                        <svg class="w-4 h-4 ml-auto" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M7.293 14.707a1 1 0 010-1.414L10.586 10 7.293 6.707a1 1 0 011.414-1.414l4 4a1 1 0 010 1.414l-4 4a1 1 0 01-1.414 0z" clip-rule="evenodd"/>
                        </svg>
                    <?php endif; ?>
                </a>

                <a href="<?php echo e(route('admin.hall-bookings.index')); ?>" 
                   class="group flex items-center px-4 py-3.5 rounded-xl transition-all duration-200 <?php echo e(request()->routeIs('admin.hall-bookings.*') ? 'bg-gradient-to-r from-amber-500 to-amber-600 text-white shadow-lg shadow-amber-500/30' : 'text-slate-300 hover:bg-white/5 hover:text-white'); ?>">
                    <div class="w-10 h-10 rounded-lg flex items-center justify-center <?php echo e(request()->routeIs('admin.hall-bookings.*') ? 'bg-white/20' : 'bg-slate-700/50 group-hover:bg-slate-700'); ?> transition-colors">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"></path>
                        </svg>
                    </div>
                    <span class="ml-3 font-semibold">Hall Bookings</span>
                    <?php if(request()->routeIs('admin.hall-bookings.*')): ?>
                        <svg class="w-4 h-4 ml-auto" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M7.293 14.707a1 1 0 010-1.414L10.586 10 7.293 6.707a1 1 0 011.414-1.414l4 4a1 1 0 010 1.414l-4 4a1 1 0 01-1.414 0z" clip-rule="evenodd"/>
                        </svg>
                    <?php endif; ?>
                </a>

                <a href="<?php echo e(route('admin.amenities.index')); ?>" 
                   class="group flex items-center px-4 py-3.5 rounded-xl transition-all duration-200 <?php echo e(request()->routeIs('admin.amenities.*') ? 'bg-gradient-to-r from-amber-500 to-amber-600 text-white shadow-lg shadow-amber-500/30' : 'text-slate-300 hover:bg-white/5 hover:text-white'); ?>">
                    <div class="w-10 h-10 rounded-lg flex items-center justify-center <?php echo e(request()->routeIs('admin.amenities.*') ? 'bg-white/20' : 'bg-slate-700/50 group-hover:bg-slate-700'); ?> transition-colors">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="2 2 20 20">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 3v4M3 5h4M6 17v4m-2-2h4m5-16l2.286 6.857L21 12l-7.714 2.143L11 21l-2.286-6.857L1 12l7.714-2.143L11 3z"></path>
                        </svg>
                    </div>
                    <span class="ml-3 font-semibold">Amenities</span>
                </a>

                <a href="<?php echo e(route('admin.facilities.index')); ?>" 
                   class="group flex items-center px-4 py-3.5 rounded-xl transition-all duration-200 <?php echo e(request()->routeIs('admin.facilities.*') ? 'bg-gradient-to-r from-amber-500 to-amber-600 text-white shadow-lg shadow-amber-500/30' : 'text-slate-300 hover:bg-white/5 hover:text-white'); ?>">
                    <div class="w-10 h-10 rounded-lg flex items-center justify-center <?php echo e(request()->routeIs('admin.facilities.*') ? 'bg-white/20' : 'bg-slate-700/50 group-hover:bg-slate-700'); ?> transition-colors">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"></path>
                        </svg>
                    </div>
                    <span class="ml-3 font-semibold">Facilities</span>
                </a>

                <a href="<?php echo e(route('admin.testimonials.index')); ?>" 
                   class="group flex items-center px-4 py-3.5 rounded-xl transition-all duration-200 <?php echo e(request()->routeIs('admin.testimonials.*') ? 'bg-gradient-to-r from-amber-500 to-amber-600 text-white shadow-lg shadow-amber-500/30' : 'text-slate-300 hover:bg-white/5 hover:text-white'); ?>">
                    <div class="w-10 h-10 rounded-lg flex items-center justify-center <?php echo e(request()->routeIs('admin.testimonials.*') ? 'bg-white/20' : 'bg-slate-700/50 group-hover:bg-slate-700'); ?> transition-colors">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 10h.01M12 10h.01M16 10h.01M9 16H5a2 2 0 01-2-2V6a2 2 0 012-2h14a2 2 0 012 2v8a2 2 0 01-2 2h-5l-5 5v-5z"></path>
                        </svg>
                    </div>
                    <span class="ml-3 font-semibold">Testimonials</span>
                </a>

                <a href="<?php echo e(route('admin.gallery.index')); ?>" 
                   class="group flex items-center px-4 py-3.5 rounded-xl transition-all duration-200 <?php echo e(request()->routeIs('admin.gallery.*') ? 'bg-gradient-to-r from-amber-500 to-amber-600 text-white shadow-lg shadow-amber-500/30' : 'text-slate-300 hover:bg-white/5 hover:text-white'); ?>">
                    <div class="w-10 h-10 rounded-lg flex items-center justify-center <?php echo e(request()->routeIs('admin.gallery.*') ? 'bg-white/20' : 'bg-slate-700/50 group-hover:bg-slate-700'); ?> transition-colors">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
                        </svg>
                    </div>
                    <span class="ml-3 font-semibold">Gallery</span>
                </a>

                <a href="<?php echo e(route('admin.inquiries.index')); ?>" 
                   class="group flex items-center px-4 py-3.5 rounded-xl transition-all duration-200 <?php echo e(request()->routeIs('admin.inquiries.*') ? 'bg-gradient-to-r from-amber-500 to-amber-600 text-white shadow-lg shadow-amber-500/30' : 'text-slate-300 hover:bg-white/5 hover:text-white'); ?>">
                    <div class="w-10 h-10 rounded-lg flex items-center justify-center <?php echo e(request()->routeIs('admin.inquiries.*') ? 'bg-white/20' : 'bg-slate-700/50 group-hover:bg-slate-700'); ?> transition-colors">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"></path>
                        </svg>
                    </div>
                    <span class="ml-3 font-semibold">Inquiries</span>
                </a>

                <div class="px-4 mt-8 mb-4">
                    <p class="text-xs font-semibold text-slate-400 uppercase tracking-wider">Other</p>
                </div>

                <a href="<?php echo e(route('home')); ?>" 
                   class="group flex items-center px-4 py-3.5 rounded-xl text-slate-300 hover:bg-white/5 hover:text-white transition-all duration-200">
                    <div class="w-10 h-10 rounded-lg flex items-center justify-center bg-slate-700/50 group-hover:bg-slate-700 transition-colors">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 6H6a2 2 0 00-2 2v10a2 2 0 002 2h10a2 2 0 002-2v-4M14 4h6m0 0v6m0-6L10 14"></path>
                        </svg>
                    </div>
                    <span class="ml-3 font-semibold">View Website</span>
                </a>
            </nav>

            <!-- Bottom User Card -->
            <div class="flex-shrink-0 p-4 border-t border-white/10 bg-slate-900/50">
                <div class="flex items-center space-x-3 px-3 py-3 rounded-xl bg-white/5 backdrop-blur-sm">
                    <div class="w-10 h-10 bg-gradient-to-br from-amber-400 to-amber-600 rounded-lg flex items-center justify-center text-white font-bold shadow-lg">
                        <?php echo e(substr(Auth::user()->name, 0, 1)); ?>

                    </div>
                    <div class="flex-1 min-w-0">
                        <p class="text-sm font-semibold text-white truncate"><?php echo e(Auth::user()->name); ?></p>
                        <p class="text-xs text-slate-400 truncate"><?php echo e(Auth::user()->email); ?></p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Main Content -->
        <div class="lg:ml-72">
            <!-- Top Bar -->
            <div class="sticky top-0 z-30 bg-white/80 backdrop-blur-lg border-b border-slate-200 shadow-sm">
                <div class="flex items-center justify-between h-20 px-4 sm:px-8">
                    <!-- Mobile Menu Button -->
                    <button @click="mobileMenu = !mobileMenu" class="lg:hidden text-slate-700 hover:text-slate-900">
                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16"/>
                        </svg>
                    </button>

                    <div class="flex items-center space-x-3">
                        <div class="hidden lg:block">
                            <h2 class="text-2xl font-bold bg-gradient-to-r from-slate-900 to-slate-700 bg-clip-text text-transparent">
                                <?php echo $__env->yieldContent('page-title', 'Dashboard'); ?>
                            </h2>
                        </div>
                    </div>
                    
                    <div class="flex items-center space-x-4">
                        <!-- Notifications -->
                        <button class="relative p-2 text-slate-600 hover:text-slate-900 hover:bg-slate-100 rounded-lg transition-colors">
                            <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 17h5l-1.405-1.405A2.032 2.032 0 0118 14.158V11a6.002 6.002 0 00-4-5.659V5a2 2 0 10-4 0v.341C7.67 6.165 6 8.388 6 11v3.159c0 .538-.214 1.055-.595 1.436L4 17h5m6 0v1a3 3 0 11-6 0v-1m6 0H9"></path>
                            </svg>
                            <span class="absolute top-1 right-1 w-2 h-2 bg-red-500 rounded-full"></span>
                        </button>

                        <!-- User Dropdown -->
                        <div x-data="{ open: false }" class="relative">
                            <button @click="open = !open" class="flex items-center space-x-3 px-3 py-2 rounded-lg hover:bg-slate-100 transition-colors">
                                <div class="hidden sm:block text-right">
                                    <p class="text-sm font-semibold text-slate-900"><?php echo e(Auth::user()->name); ?></p>
                                    <p class="text-xs text-slate-500">Administrator</p>
                                </div>
                                <div class="w-10 h-10 bg-gradient-to-br from-amber-400 to-amber-600 rounded-lg flex items-center justify-center text-white font-bold shadow-md">
                                    <?php echo e(substr(Auth::user()->name, 0, 1)); ?>

                                </div>
                                <svg class="w-4 h-4 text-slate-600" :class="{'rotate-180': open}" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                                </svg>
                            </button>

                            <div x-show="open" 
                                 x-cloak
                                 @click.away="open = false" 
                                 class="absolute right-0 mt-2 w-56 bg-white rounded-xl shadow-2xl border border-slate-200 py-2 z-50"
                                 x-transition:enter="transition ease-out duration-200"
                                 x-transition:enter-start="opacity-0 scale-95"
                                 x-transition:enter-end="opacity-100 scale-100"
                                 x-transition:leave="transition ease-in duration-150"
                                 x-transition:leave-start="opacity-100 scale-100"
                                 x-transition:leave-end="opacity-0 scale-95">
                                
                                <div class="px-4 py-3 border-b border-slate-200">
                                    <p class="text-sm font-semibold text-slate-900"><?php echo e(Auth::user()->name); ?></p>
                                    <p class="text-xs text-slate-500 mt-0.5"><?php echo e(Auth::user()->email); ?></p>
                                </div>

                                <a href="<?php echo e(route('profile.edit')); ?>" class="flex items-center px-4 py-2.5 text-sm text-slate-700 hover:bg-slate-50 transition-colors">
                                    <svg class="w-4 h-4 mr-3 text-slate-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"/>
                                    </svg>
                                    Profile Settings
                                </a>

                                <a href="<?php echo e(route('home')); ?>" class="flex items-center px-4 py-2.5 text-sm text-slate-700 hover:bg-slate-50 transition-colors">
                                    <svg class="w-4 h-4 mr-3 text-slate-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 6H6a2 2 0 00-2 2v10a2 2 0 002 2h10a2 2 0 002-2v-4M14 4h6m0 0v6m0-6L10 14"/>
                                    </svg>
                                    View Website
                                </a>

                                <div class="border-t border-slate-200 my-2"></div>

                                <form method="POST" action="<?php echo e(route('logout')); ?>">
                                    <?php echo csrf_field(); ?>
                                    <button type="submit" class="flex items-center w-full px-4 py-2.5 text-sm text-red-600 hover:bg-red-50 transition-colors">
                                        <svg class="w-4 h-4 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1"/>
                                        </svg>
                                        Logout
                                    </button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Page Content -->
            <main class="p-4 sm:p-8">
                <!-- Alerts -->
                <?php if(session('success')): ?>
                    <div class="mb-6 bg-green-50 border-l-4 border-green-500 rounded-lg p-4 shadow-sm" x-data="{ show: true }" x-show="show">
                        <div class="flex items-center justify-between">
                            <div class="flex items-center">
                                <svg class="w-5 h-5 text-green-500 mr-3" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                                </svg>
                                <p class="text-sm font-medium text-green-800"><?php echo e(session('success')); ?></p>
                            </div>
                            <button @click="show = false" class="text-green-500 hover:text-green-700">
                                <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z" clip-rule="evenodd"/>
                                </svg>
                            </button>
                        </div>
                    </div>
                <?php endif; ?>

                <?php if(session('error')): ?>
                    <div class="mb-6 bg-red-50 border-l-4 border-red-500 rounded-lg p-4 shadow-sm" x-data="{ show: true }" x-show="show">
                        <div class="flex items-center justify-between">
                            <div class="flex items-center">
                                <svg class="w-5 h-5 text-red-500 mr-3" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z" clip-rule="evenodd"/>
                                </svg>
                                <p class="text-sm font-medium text-red-800"><?php echo e(session('error')); ?></p>
                            </div>
                            <button @click="show = false" class="text-red-500 hover:text-red-700">
                                <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z" clip-rule="evenodd"/>
                                </svg>
                            </button>
                        </div>
                    </div>
                <?php endif; ?>

                <?php echo $__env->yieldContent('content'); ?>
            </main>
        </div>
    </div>
    <?php echo $__env->yieldPushContent('scripts'); ?>
</body>
</html><?php /**PATH C:\Users\Shanaka\OneDrive\Documents\hotelbooking\resources\views/layouts/admin.blade.php ENDPATH**/ ?>