

<?php $__env->startSection('content'); ?>



<section class="relative h-[85vh] min-h-[600px] w-full overflow-hidden flex items-center">
    
    <video autoplay muted loop playsinline class="absolute inset-0 w-full h-full object-cover z-0">
        <source src="<?php echo e(asset('videos/hero-video.mp4')); ?>" type="video/mp4">
        Your browser does not support the video tag.
    </video>
    
    
    <div class="absolute inset-0 bg-gradient-to-r from-black/80 via-black/60 to-black/30 backdrop-blur-[2px] z-10"></div>

    
    <div class="container mx-auto px-4 relative z-20">
        <div class="max-w-4xl space-y-8">
            <h1 class="font-display font-bold leading-tight drop-shadow-2xl">
                <span class="block text-5xl md:text-7xl text-white mb-2 tracking-tight">Book Your Dream</span>
                <span class="block text-5xl md:text-7xl text-white mb-2 tracking-tight">Modern Villa With</span>
                <span class="block text-5xl md:text-7xl text-[#8bc34a] drop-shadow-md">70's Eco Village</span>
            </h1>
            
            <p class="text-white/95 font-medium text-lg md:text-xl leading-relaxed max-w-2xl drop-shadow-md">
                At our hotel, luxury is more than just a word it's a tradition.
                <br>
                From exquisite design to personalized service, every detail is
                <br>
                thoughtfully curated to create unforgettable experiences.
            </p>

            <div class="flex flex-wrap gap-5 relative z-50 pt-4">
                <a href="<?php echo e(route('rooms.index')); ?>" class="px-10 py-5 bg-[#558B2F] hover:bg-[#457025] hover:-translate-y-1 text-white font-bold rounded-lg shadow-xl hover:shadow-2xl hover:shadow-[#558B2F]/40 transition-all duration-300 uppercase tracking-wider text-sm cursor-pointer flex items-center gap-2">
                    Discover Now
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3"/></svg>
                </a>
                <a href="<?php echo e(route('rooms.index')); ?>" class="px-10 py-5 bg-white/10 hover:bg-white/20 hover:-translate-y-1 text-white font-bold rounded-lg border border-white/30 hover:border-white shadow-lg backdrop-blur-md transition-all duration-300 uppercase tracking-wider text-sm cursor-pointer">
                    Book Now
                </a>
            </div>
        </div>
    </div>
</section>


<section class="relative z-30 -mt-24 pb-16">
    <div class="container mx-auto px-4">
        <div class="bg-white rounded-2xl shadow-2xl p-8 border border-gray-100">
            <div class="mb-6 flex items-center gap-2">
                <span class="w-1.5 h-8 bg-[#558B2F] rounded-full"></span>
                <h3 class="text-2xl font-bold text-gray-800 font-display">Check Availability</h3>
            </div>
            
            <form action="<?php echo e(route('rooms.index')); ?>" method="GET">
                <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-6 gap-6 items-end">
                    
                    <div class="group">
                        <label class="block text-gray-500 text-xs font-bold mb-2 uppercase tracking-wider group-focus-within:text-[#558B2F] transition-colors">Check In</label>
                        <input type="text" 
                               name="check_in" 
                               placeholder="Select Date"
                               onfocus="(this.type='date')"
                               onblur="(this.type='text')"
                               class="w-full px-4 py-3 bg-gray-50 border border-gray-200 rounded-xl text-gray-900 font-semibold focus:outline-none focus:ring-2 focus:ring-[#558B2F]/20 focus:border-[#558B2F] transition-all cursor-pointer placeholder-gray-400"
                               required>
                    </div>

                    
                    <div class="group">
                        <label class="block text-gray-500 text-xs font-bold mb-2 uppercase tracking-wider group-focus-within:text-[#558B2F] transition-colors">Check Out</label>
                        <input type="text" 
                               name="check_out" 
                               placeholder="Select Date"
                               onfocus="(this.type='date')"
                               onblur="(this.type='text')"
                               class="w-full px-4 py-3 bg-gray-50 border border-gray-200 rounded-xl text-gray-900 font-semibold focus:outline-none focus:ring-2 focus:ring-[#558B2F]/20 focus:border-[#558B2F] transition-all cursor-pointer placeholder-gray-400"
                               required>
                    </div>

                    
                    <div class="group">
                        <label class="block text-gray-500 text-xs font-bold mb-2 uppercase tracking-wider group-focus-within:text-[#558B2F] transition-colors">Rooms</label>
                        <div class="relative">
                            <select name="rooms" class="w-full px-4 py-3 bg-gray-50 border border-gray-200 rounded-xl text-gray-900 font-semibold focus:outline-none focus:ring-2 focus:ring-[#558B2F]/20 focus:border-[#558B2F] transition-all appearance-none cursor-pointer">
                                <option value="" selected disabled>Select Room</option>
                                <option value="1">1 Room</option>
                                <option value="2">2 Rooms</option>
                                <option value="3">3 Rooms</option>
                            </select>
                            <div class="absolute inset-y-0 right-0 flex items-center px-4 pointer-events-none text-gray-400">
                                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2.5" d="M19 9l-7 7-7-7"></path></svg>
                            </div>
                        </div>
                    </div>

                    
                    <div class="group">
                        <label class="block text-gray-500 text-xs font-bold mb-2 uppercase tracking-wider group-focus-within:text-[#558B2F] transition-colors">Adults</label>
                        <div class="relative">
                            <select name="adults" class="w-full px-4 py-3 bg-gray-50 border border-gray-200 rounded-xl text-gray-900 font-semibold focus:outline-none focus:ring-2 focus:ring-[#558B2F]/20 focus:border-[#558B2F] transition-all appearance-none cursor-pointer">
                                <option value="" selected disabled>Select Adults</option>
                                <option value="1">1 Adult</option>
                                <option value="2">2 Adults</option>
                                <option value="3">3 Adults</option>
                            </select>
                            <div class="absolute inset-y-0 right-0 flex items-center px-4 pointer-events-none text-gray-400">
                                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2.5" d="M19 9l-7 7-7-7"></path></svg>
                            </div>
                        </div>
                    </div>

                    
                    <div class="group">
                        <label class="block text-gray-500 text-xs font-bold mb-2 uppercase tracking-wider group-focus-within:text-[#558B2F] transition-colors">Children</label>
                        <div class="relative">
                            <select name="children" class="w-full px-4 py-3 bg-gray-50 border border-gray-200 rounded-xl text-gray-900 font-semibold focus:outline-none focus:ring-2 focus:ring-[#558B2F]/20 focus:border-[#558B2F] transition-all appearance-none cursor-pointer">
                                <option value="" selected disabled>Select Children</option>
                                <option value="0">No Children</option>
                                <option value="1">1 Child</option>
                                <option value="2">2 Children</option>
                                <option value="3">3+ Children</option>
                            </select>
                            <div class="absolute inset-y-0 right-0 flex items-center px-4 pointer-events-none text-gray-400">
                                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2.5" d="M19 9l-7 7-7-7"></path></svg>
                            </div>
                        </div>
                    </div>

                    
                    <div>
                        <button type="submit" class="w-full px-4 py-3.5 bg-[#558B2F] hover:bg-[#457025] hover:-translate-y-1 text-white rounded-xl font-bold uppercase tracking-widest text-sm shadow-lg hover:shadow-2xl hover:shadow-[#558B2F]/30 transition-all duration-300">
                            Check Rates
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</section>


<section class="bg-[#FBFBFB] py-16">
    <div class="container mx-auto px-4">
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
            
            <a href="<?php echo e(route('rooms.index')); ?>" class="bg-white p-10 rounded-[2rem] border-2 border-gray-100 hover:border-[#558B2F]/30 shadow-sm hover:shadow-lg transition-all duration-300 text-center group">
                <div class="w-24 h-24 bg-[#E8F5E9] rounded-full flex items-center justify-center mx-auto mb-6 group-hover:bg-[#C8E6C9] transition-colors">
                    <svg class="w-12 h-12 text-[#558B2F]" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M12 6.253v13m0-13C10.832 5.477 9.246 5 7.5 5S4.168 5.477 3 6.253v13C4.168 18.477 5.754 18 7.5 18s3.332.477 4.5 1.253m0-13C13.168 5.477 14.754 5 16.5 5c1.747 0 3.332.477 4.5 1.253v13C19.832 18.477 18.247 18 16.5 18c-1.746 0-3.332.477-4.5 1.253"></path>
                    </svg>
                </div>
                <h3 class="font-display text-2xl text-[#558B2F] mb-3 font-bold">Quick Booking</h3>
                <p class="text-gray-600 text-sm leading-relaxed">
                    Lorem ipsum dolor sit amet, consectetur adipiscing elit.
                </p>
            </a>

            
            <div class="bg-white p-10 rounded-[2rem] border-2 border-gray-100 hover:border-[#558B2F]/30 shadow-sm hover:shadow-lg transition-all duration-300 text-center group">
                <div class="w-24 h-24 bg-[#E8F5E9] rounded-full flex items-center justify-center mx-auto mb-6 group-hover:bg-[#C8E6C9] transition-colors">
                    <svg class="w-12 h-12 text-[#558B2F]" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>
                    </svg>
                </div>
                <h3 class="font-display text-2xl text-[#558B2F] mb-3 font-bold">Best Guide</h3>
                <p class="text-gray-600 text-sm leading-relaxed">
                    Lorem ipsum dolor sit amet, consectetur adipiscing elit.
                </p>
            </div>

            
            <div class="bg-white p-10 rounded-[2rem] border-2 border-gray-100 hover:border-[#558B2F]/30 shadow-sm hover:shadow-lg transition-all duration-300 text-center group">
                <div class="w-24 h-24 bg-[#E8F5E9] rounded-full flex items-center justify-center mx-auto mb-6 group-hover:bg-[#C8E6C9] transition-colors">
                    <svg class="w-12 h-12 text-[#558B2F]" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z"></path>
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                    </svg>
                </div>
                <h3 class="font-display text-2xl text-[#558B2F] mb-3 font-bold">Customization</h3>
                <p class="text-gray-600 text-sm leading-relaxed">
                    Lorem ipsum dolor sit amet, consectetur adipiscing elit.
                </p>
            </div>

            
            <a href="<?php echo e(route('contact')); ?>" class="bg-white p-10 rounded-[2rem] border-2 border-gray-100 hover:border-[#558B2F]/30 shadow-sm hover:shadow-lg transition-all duration-300 text-center group">
                <div class="w-24 h-24 bg-[#E8F5E9] rounded-full flex items-center justify-center mx-auto mb-6 group-hover:bg-[#C8E6C9] transition-colors">
                    <svg class="w-12 h-12 text-[#558B2F]" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M18.364 5.636l-3.536 3.536m0 5.656l3.536 3.536M9.172 9.172L5.636 5.636m3.536 9.192l-3.536 3.536M21 12a9 9 0 11-18 0 9 9 0 0118 0zm-5 0a4 4 0 11-8 0 4 4 0 018 0z"></path>
                    </svg>
                </div>
                <h3 class="font-display text-2xl text-[#558B2F] mb-3 font-bold">24/7 Support</h3>
                <p class="text-gray-600 text-sm leading-relaxed">
                    Lorem ipsum dolor sit amet, consectetur adipiscing elit.
                </p>
            </a>
        </div>
    </div>
</section>


<section class="bg-[#7A9D54] py-20">
    <div class="container mx-auto px-4">
        <div class="flex justify-between items-start mb-8">
            <div>
                <p class="text-white text-sm font-bold uppercase tracking-wider mb-2">OUR ROOM & SUITS</p>
                <h2 class="font-display text-4xl md:text-5xl text-white font-bold leading-tight max-w-xl">
                    Comfortable Modern Villa<br>Rooms Just For You
                </h2>
            </div>
            <a href="<?php echo e(route('rooms.index')); ?>" class="px-8 py-3 bg-transparent hover:bg-white/10 text-white font-bold rounded border-2 border-white transition-all duration-300 uppercase tracking-wide text-sm">
                Book Now
            </a>
        </div>

        <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
            
            <div class="space-y-6">
                <?php $__currentLoopData = $rooms->take(4); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $room): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="room-item group/item cursor-pointer border-b border-white/30 pb-6 transition-all duration-300 <?php echo e($index === 0 ? 'opacity-100 translate-x-2' : 'opacity-60 hover:opacity-100 hover:translate-x-2'); ?>"
                     data-image="<?php echo e($room->image ? asset('storage/' . $room->image) : 'https://images.unsplash.com/photo-1582268611958-ebfd161ef9cf?w=800&auto=format&fit=crop'); ?>"
                     data-name="<?php echo e($room->name); ?>"
                     data-description="<?php echo e($room->description ? Str::limit($room->description, 150) : 'A wonderful serenity has taken possession of my entire soul, like these royella dolor amet, consectetur adipiscing elit duis eiusmod tempor incididunt resort.'); ?>"
                     data-link="<?php echo e(route('rooms.show', $room)); ?>">
                    <h3 class="font-display text-2xl text-white font-bold mb-2 group-hover/item:text-white/90"><?php echo e($room->name); ?></h3>
                    <p class="text-white/90 text-sm">From $ <?php echo e(number_format($room->price, 0)); ?>/Per Night</p>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>

            
            <div class="relative rounded-2xl overflow-hidden shadow-2xl group h-[500px]">
                <img id="featured-room-image"
                     src="<?php echo e($rooms->isNotEmpty() ? ($rooms->first()->image ? asset('storage/' . $rooms->first()->image) : 'https://images.unsplash.com/photo-1582268611958-ebfd161ef9cf?w=800&auto=format&fit=crop') : 'https://images.unsplash.com/photo-1582268611958-ebfd161ef9cf?w=800&auto=format&fit=crop'); ?>" 
                     alt="Featured Room" 
                     class="w-full h-full object-cover transition-opacity duration-500">
                
                
                <div class="absolute inset-0 bg-gradient-to-t from-black/80 via-black/40 to-transparent"></div>
                
                
                <div class="absolute bottom-0 left-0 right-0 p-8 text-white transition-all duration-500 transform translate-y-0 opacity-100" id="featured-room-details">
                    <h3 id="featured-room-name" class="font-display text-3xl font-bold mb-3">
                        <?php echo e($rooms->isNotEmpty() ? $rooms->first()->name : 'Exclusive Deluxe'); ?>

                    </h3>
                    <p id="featured-room-description" class="text-white/90 text-sm mb-6 leading-relaxed">
                        <?php echo e($rooms->isNotEmpty() ? ($rooms->first()->description ? Str::limit($rooms->first()->description, 150) : 'A wonderful serenity has taken possession of my entire soul, like these royella dolor amet, consectetur adipiscing elit duis eiusmod tempor incididunt resort.') : 'A wonderful serenity has taken possession of my entire soul, like these royella dolor amet, consectetur adipiscing elit duis eiusmod tempor incididunt resort sweet spring which I enjoy with my whole heart.'); ?>

                    </p>
                    <a id="featured-room-link" 
                       href="<?php echo e($rooms->isNotEmpty() ? route('rooms.show', $rooms->first()) : '#'); ?>" 
                       class="inline-flex items-center gap-2 text-white font-bold hover:gap-3 transition-all">
                        Room Details
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                        </svg>
                    </a>
                </div>
            </div>
        </div>
    </div>
</section>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        const roomItems = document.querySelectorAll('.room-item');
        const featuredImage = document.getElementById('featured-room-image');
        const featuredName = document.getElementById('featured-room-name');
        const featuredDesc = document.getElementById('featured-room-description');
        const featuredLink = document.getElementById('featured-room-link');
        const activeClass = ['opacity-100', 'translate-x-2'];
        const inactiveClass = ['opacity-60', 'hover:opacity-100', 'hover:translate-x-2'];

        roomItems.forEach(item => {
            item.addEventListener('mouseover', function() {
                // Remove active class from all items
                roomItems.forEach(i => {
                    i.classList.remove(...activeClass);
                    i.classList.add(...inactiveClass);
                });

                // Add active class to current item
                this.classList.remove(...inactiveClass);
                this.classList.add(...activeClass);

                // Update featured content with fade effect
                featuredImage.style.opacity = '0';
                
                setTimeout(() => {
                    featuredImage.src = this.dataset.image;
                    featuredName.textContent = this.dataset.name;
                    featuredDesc.textContent = this.dataset.description;
                    featuredLink.href = this.dataset.link;
                    
                    featuredImage.onload = () => {
                        featuredImage.style.opacity = '1';
                    };
                }, 200);
            });
        });
    });
</script>



<section id="about" class="bg-white py-20">
    <div class="container mx-auto px-4">
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
            
            <div class="grid grid-cols-2 gap-4">
                <div class="space-y-4">
                    <img src="https://images.unsplash.com/photo-1540555700478-4be289fbecef?w=600&auto=format&fit=crop" 
                         alt="Sunset Yoga" 
                         class="w-full h-80 object-cover rounded-2xl shadow-lg">
                </div>
                <div class="space-y-4 pt-12">
                    <img src="<?php echo e(asset('images/hotel-staff.jpg')); ?>" 
                         alt="Hotel Staff" 
                         class="w-full h-80 object-cover rounded-2xl shadow-lg">
                </div>
            </div>

            
            <div>
                <p class="text-[#558B2F] text-sm font-bold uppercase tracking-wider mb-3">ABOUT OUR VILLA</p>
                <h2 class="font-display text-4xl md:text-5xl text-gray-900 font-bold leading-tight mb-6">
                    Situated In Prime Position At The Foot Of The Slopes Of Courchevel 70's Eco Village
                </h2>
                <p class="text-gray-600 mb-8 leading-relaxed">
                    A wonderful serenity has taken possession of my entire soul, like these royella dolor amet, consectetur adipiscing elit duis eiusmod tempor incididunt resort sweet spring which I enjoy with my whole heart.
                </p>

                
                <div class="space-y-4 mb-8">
                    <div class="flex items-start gap-4">
                        <div class="w-12 h-12 bg-[#E8F5E9] rounded-full flex items-center justify-center flex-shrink-0">
                            <svg class="w-6 h-6 text-[#558B2F]" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                            </svg>
                        </div>
                        <div>
                            <h4 class="font-bold text-gray-900 mb-1">Serenity And Bliss</h4>
                            <p class="text-gray-600 text-sm">The hotel Lorem ipsum dolor sit amet consectetur</p>
                        </div>
                    </div>

                    <div class="flex items-start gap-4">
                        <div class="w-12 h-12 bg-[#E8F5E9] rounded-full flex items-center justify-center flex-shrink-0">
                            <svg class="w-6 h-6 text-[#558B2F]" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4"></path>
                            </svg>
                        </div>
                        <div>
                            <h4 class="font-bold text-gray-900 mb-1">Store Luggage</h4>
                            <p class="text-gray-600 text-sm">The hotel Lorem ipsum dolor sit amet consectetur</p>
                        </div>
                    </div>

                    <div class="flex items-start gap-4">
                        <div class="w-12 h-12 bg-[#E8F5E9] rounded-full flex items-center justify-center flex-shrink-0">
                            <svg class="w-6 h-6 text-[#558B2F]" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6"></path>
                            </svg>
                        </div>
                        <div>
                            <h4 class="font-bold text-gray-900 mb-1">Room Services</h4>
                            <p class="text-gray-600 text-sm">The hotel Lorem ipsum dolor sit amet consectetur</p>
                        </div>
                    </div>
                </div>

                
                <div class="grid grid-cols-2 gap-4 mb-8">
                    <div class="bg-[#7A9D54] p-6 rounded-xl text-white">
                        <p class="text-4xl font-bold mb-1">20+</p>
                        <p class="text-sm">Years Of Experience</p>
                    </div>
                    <div class="bg-[#7A9D54] p-6 rounded-xl text-white">
                        <div class="flex items-center gap-2 mb-1">
                            <p class="text-4xl font-bold">4.9</p>
                            <div class="flex text-yellow-400">
                                <svg class="w-5 h-5 fill-current" viewBox="0 0 20 20"><path d="M10 15l-5.878 3.09 1.123-6.545L.489 6.91l6.572-.955L10 0l2.939 5.955 6.572.955-4.756 4.635 1.123 6.545z"/></svg>
                                <svg class="w-5 h-5 fill-current" viewBox="0 0 20 20"><path d="M10 15l-5.878 3.09 1.123-6.545L.489 6.91l6.572-.955L10 0l2.939 5.955 6.572.955-4.756 4.635 1.123 6.545z"/></svg>
                                <svg class="w-5 h-5 fill-current" viewBox="0 0 20 20"><path d="M10 15l-5.878 3.09 1.123-6.545L.489 6.91l6.572-.955L10 0l2.939 5.955 6.572.955-4.756 4.635 1.123 6.545z"/></svg>
                                <svg class="w-5 h-5 fill-current" viewBox="0 0 20 20"><path d="M10 15l-5.878 3.09 1.123-6.545L.489 6.91l6.572-.955L10 0l2.939 5.955 6.572.955-4.756 4.635 1.123 6.545z"/></svg>
                            </div>
                        </div>
                        <p class="text-sm">Rating</p>
                    </div>
                </div>

                <a href="<?php echo e(route('home')); ?>" class="inline-block px-8 py-3 bg-[#558B2F] hover:bg-[#457025] text-white font-bold rounded shadow-lg hover:shadow-xl transition-all duration-300">
                    More About
                </a>
            </div>
        </div>
    </div>
</section>


<section id="services" class="bg-[#FBFBFB] py-20">
    <div class="container mx-auto px-4">
        <div class="text-center mb-12">
            <p class="text-[#558B2F] text-sm font-bold uppercase tracking-wider mb-3">OUR SERVICES</p>
            <h2 class="font-display text-4xl md:text-5xl text-gray-900 font-bold">Explore Hotel Services</h2>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
            
            <div class="bg-white p-8 rounded-2xl shadow-sm hover:shadow-md transition-all duration-300 text-center group">
                <div class="w-20 h-20 bg-[#E8F5E9] rounded-full flex items-center justify-center mx-auto mb-6 group-hover:bg-[#C8E6C9] transition-colors">
                    <svg class="w-10 h-10 text-[#558B2F]" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h18M3 14h18m-9-4v8m-7 0h14a2 2 0 002-2V8a2 2 0 00-2-2H5a2 2 0 00-2 2v8a2 2 0 002 2z"></path>
                    </svg>
                </div>
                <h3 class="font-display text-xl text-[#558B2F] font-bold">Gym Center</h3>
            </div>

            
            <div class="bg-white p-8 rounded-2xl shadow-sm hover:shadow-md transition-all duration-300 text-center group">
                <div class="w-20 h-20 bg-[#E8F5E9] rounded-full flex items-center justify-center mx-auto mb-6 group-hover:bg-[#C8E6C9] transition-colors">
                    <svg class="w-10 h-10 text-[#558B2F]" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z"></path>
                    </svg>
                </div>
                <h3 class="font-display text-xl text-[#558B2F] font-bold">Spa & Massage</h3>
            </div>

            
            <div class="bg-white p-8 rounded-2xl shadow-sm hover:shadow-md transition-all duration-300 text-center group">
                <div class="w-20 h-20 bg-[#E8F5E9] rounded-full flex items-center justify-center mx-auto mb-6 group-hover:bg-[#C8E6C9] transition-colors">
                    <svg class="w-10 h-10 text-[#558B2F]" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M14 10h4.764a2 2 0 011.789 2.894l-3.5 7A2 2 0 0115.263 21h-4.017c-.163 0-.326-.02-.485-.06L7 20m7-10V5a2 2 0 00-2-2h-.095c-.5 0-.905.405-.905.905 0 .714-.211 1.412-.608 2.006L7 11v9m7-10h-2M7 20H5a2 2 0 01-2-2v-6a2 2 0 012-2h2.5"></path>
                    </svg>
                </div>
                <h3 class="font-display text-xl text-[#558B2F] font-bold">Swimming Pool</h3>
            </div>

            
            <div class="bg-white p-8 rounded-2xl shadow-sm hover:shadow-md transition-all duration-300 text-center group">
                <div class="w-20 h-20 bg-[#E8F5E9] rounded-full flex items-center justify-center mx-auto mb-6 group-hover:bg-[#C8E6C9] transition-colors">
                    <svg class="w-10 h-10 text-[#558B2F]" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                    </svg>
                </div>
                <h3 class="font-display text-xl text-[#558B2F] font-bold">Restaurant</h3>
            </div>
        </div>
    </div>
</section>


<section id="gallery" class="bg-[#7A9D54] py-20 relative overflow-hidden">
    
    <div class="absolute inset-0 opacity-10 pointer-events-none" 
         style="background-image: url('https://images.unsplash.com/photo-1526488733393-2715019d4586?w=1200&auto=format&fit=crop'); background-size: cover; background-position: center;">
    </div>

    <div class="container mx-auto px-4 relative z-10">
        <div class="mb-12">
            <p class="text-white text-sm font-bold uppercase tracking-wider mb-3">OUR GALLERY</p>
            <h2 class="font-display text-4xl md:text-5xl text-white font-bold">Hotel Gallery</h2>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
            <?php $__empty_1 = true; $__currentLoopData = $galleryImages->take(5); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                
                <div class="<?php echo e($index === 0 ? 'md:row-span-2' : ''); ?>">
                    <img src="<?php echo e(asset('storage/' . $image->image_path)); ?>" 
                         alt="<?php echo e($image->title ?? 'Gallery Image'); ?>" 
                         class="w-full <?php echo e($index === 0 ? 'h-full' : 'h-48'); ?> object-cover rounded-2xl shadow-lg hover:scale-105 transition-transform duration-300">
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                
                
                <div class="md:row-span-2">
                    <img src="https://images.unsplash.com/photo-1540555700478-4be289fbecef?w=800&auto=format&fit=crop" 
                         alt="Spa and Pool Area" 
                         class="w-full h-full object-cover rounded-2xl shadow-lg hover:scale-105 transition-transform duration-300">
                </div>

                
                <div>
                    <img src="https://images.unsplash.com/photo-1566073771259-6a8506099945?w=600&auto=format&fit=crop" 
                         alt="Hotel Staff" 
                         class="w-full h-48 object-cover rounded-2xl shadow-lg hover:scale-105 transition-transform duration-300">
                </div>

                
                <div>
                    <img src="https://images.unsplash.com/photo-1542314831-068cd1dbfeeb?w=600&auto=format&fit=crop" 
                         alt="Hotel Entrance" 
                         class="w-full h-48 object-cover rounded-2xl shadow-lg hover:scale-105 transition-transform duration-300">
                </div>

                
                <div>
                    <img src="https://images.unsplash.com/photo-1582268611958-ebfd161ef9cf?w=600&auto=format&fit=crop" 
                         alt="Luxury Room" 
                         class="w-full h-48 object-cover rounded-2xl shadow-lg hover:scale-105 transition-transform duration-300">
                </div>

                
                <div>
                    <img src="https://images.unsplash.com/photo-1517248135467-4c7edcad34c4?w=600&auto=format&fit=crop" 
                         alt="Restaurant" 
                         class="w-full h-48 object-cover rounded-2xl shadow-lg hover:scale-105 transition-transform duration-300">
                </div>
            <?php endif; ?>
        </div>
    </div>
</section>



<section id="testimonials" class="bg-white py-20">
    <div class="container mx-auto px-4">
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
            
            <div>
                <img src="<?php echo e(asset('images/testimonial-customer-v2.jpg')); ?>" 
                     alt="Happy Customer" 
                     class="w-full h-[500px] object-cover rounded-2xl shadow-xl">
            </div>

            
            <div>
                <p class="text-[#558B2F] text-sm font-bold uppercase tracking-wider mb-3">TESTIMONIALS</p>
                <h2 class="font-display text-4xl md:text-5xl text-gray-900 font-bold mb-12">
                    Hear From Our Satisfied Customers
                </h2>

                <div class="relative overflow-hidden" id="testimonial-slider">
                    <div class="testimonial-wrapper transition-transform duration-500 flex ease-in-out">
                        <?php $__empty_1 = true; $__currentLoopData = $testimonials; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $testimonial): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <div class="w-full flex-shrink-0 bg-[#E8F5E9] p-8 rounded-2xl relative">
                            
                            <div class="absolute top-4 right-4 w-12 h-12 bg-[#558B2F] rounded-full flex items-center justify-center">
                                <svg class="w-6 h-6 text-white" fill="currentColor" viewBox="0 0 24 24">
                                    <path d="M14.017 21v-7.391c0-5.704 3.731-9.57 8.983-10.609l.995 2.151c-2.432.917-3.995 3.638-3.995 5.849h4v10h-9.983zm-14.017 0v-7.391c0-5.704 3.748-9.57 9-10.609l.996 2.151c-2.433.917-3.996 3.638-3.996 5.849h3.983v10h-9.983z"/>
                                </svg>
                            </div>

                            <p class="text-gray-700 mb-6 leading-relaxed min-h-[80px]">
                                "<?php echo e($testimonial->content); ?>"
                            </p>

                            <div class="flex items-center gap-4">
                                <img src="https://ui-avatars.com/api/?name=<?php echo e(urlencode($testimonial->name)); ?>&size=60&background=558B2F&color=fff" 
                                     alt="<?php echo e($testimonial->name); ?>" 
                                     class="w-14 h-14 rounded-full">
                                <div>
                                    <h4 class="font-bold text-gray-900"><?php echo e($testimonial->name); ?></h4>
                                    <p class="text-sm text-gray-600">Guest</p>
                                    <div class="flex text-yellow-400 mt-1">
                                        <?php for($i = 0; $i < $testimonial->rating; $i++): ?>
                                        <svg class="w-4 h-4 fill-current" viewBox="0 0 20 20"><path d="M10 15l-5.878 3.09 1.123-6.545L.489 6.91l6.572-.955L10 0l2.939 5.955 6.572.955-4.756 4.635 1.123 6.545z"/></svg>
                                        <?php endfor; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <div class="bg-[#E8F5E9] p-8 rounded-2xl relative">
                            <p class="text-gray-700 mb-6 leading-relaxed">
                                No testimonials available yet. Be the first to review us!
                            </p>
                        </div>
                        <?php endif; ?>
                    </div>

                    
                    <?php if($testimonials->count() > 1): ?>
                    <div class="flex justify-center gap-2 mt-6">
                        <?php $__currentLoopData = $testimonials; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $testimonial): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <button class="dot-btn w-3 h-3 rounded-full <?php echo e($index === 0 ? 'bg-[#558B2F]' : 'bg-gray-300'); ?> transition-colors" onclick="goToSlide(<?php echo e($index); ?>)"></button>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                    <?php endif; ?>
                </div>

                <script>
                    let currentSlide = 0;
                    const slides = document.querySelectorAll('.testimonial-wrapper > div').length;
                    const wrapper = document.querySelector('.testimonial-wrapper');
                    const dots = document.querySelectorAll('.dot-btn');

                    function goToSlide(n) {
                        currentSlide = n;
                        updateSlider();
                    }

                    function updateSlider() {
                        wrapper.style.transform = `translateX(-${currentSlide * 100}%)`;
                        
                        // Update dots
                        dots.forEach((dot, index) => {
                            if (index === currentSlide) {
                                dot.classList.remove('bg-gray-300');
                                dot.classList.add('bg-[#558B2F]');
                            } else {
                                dot.classList.remove('bg-[#558B2F]');
                                dot.classList.add('bg-gray-300');
                            }
                        });
                    }

                    // Auto advance every 5 seconds
                    setInterval(() => {
                        if (slides > 1) {
                            currentSlide = (currentSlide + 1) % slides;
                            updateSlider();
                        }
                    }, 5000);
                </script>
            </div>
        </div>
    </div>
</section>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\Shanaka\OneDrive\Documents\hotelbooking\resources\views/home.blade.php ENDPATH**/ ?>