

<?php $__env->startSection('content'); ?>
<div class="py-12">
    <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
        <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
            <div class="p-6 text-gray-900">
                <div class="mb-6 border-b pb-4">
                    <h2 class="text-2xl font-semibold text-gray-800">Add New Event Hall</h2>
                </div>

                <form action="<?php echo e(route('admin.halls.store')); ?>" method="POST" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div class="mb-4">
                            <label for="name" class="block text-gray-700 text-sm font-bold mb-2">Hall Name</label>
                            <input type="text" name="name" id="name" class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline" required>
                        </div>

                        <div class="mb-4">
                            <label for="capacity" class="block text-gray-700 text-sm font-bold mb-2">Capacity (Number of guests)</label>
                            <input type="number" name="capacity" id="capacity" class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline" required>
                        </div>

                        <div class="mb-4">
                            <label for="price_per_day" class="block text-gray-700 text-sm font-bold mb-2">Price Per Day (LKR)</label>
                            <input type="number" step="0.01" name="price_per_day" id="price_per_day" class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline" required>
                        </div>

                        <div class="mb-4">
                            <label for="image" class="block text-gray-700 text-sm font-bold mb-2">Hall Image</label>
                            <input type="file" name="image" id="image" class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline">
                        </div>
                    </div>

                    <div class="mb-4">
                        <label for="description" class="block text-gray-700 text-sm font-bold mb-2">Description</label>
                        <textarea name="description" id="description" class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline" rows="4"></textarea>
                    </div>

                    <div class="mb-6">
                        <label class="block text-gray-700 text-sm font-bold mb-2">Features</label>
                        <div class="grid grid-cols-2 md:grid-cols-4 gap-4">
                            <label class="inline-flex items-center">
                                <input type="checkbox" name="features[]" value="Air Conditioning" class="rounded text-indigo-600 focus:ring-indigo-500">
                                <span class="ml-2">Air Conditioning</span>
                            </label>
                            <label class="inline-flex items-center">
                                <input type="checkbox" name="features[]" value="Sound System" class="rounded text-indigo-600 focus:ring-indigo-500">
                                <span class="ml-2">Sound System</span>
                            </label>
                            <label class="inline-flex items-center">
                                <input type="checkbox" name="features[]" value="Projector" class="rounded text-indigo-600 focus:ring-indigo-500">
                                <span class="ml-2">Projector</span>
                            </label>
                            <label class="inline-flex items-center">
                                <input type="checkbox" name="features[]" value="Stage" class="rounded text-indigo-600 focus:ring-indigo-500">
                                <span class="ml-2">Stage</span>
                            </label>
                            <label class="inline-flex items-center">
                                <input type="checkbox" name="features[]" value="Wifi" class="rounded text-indigo-600 focus:ring-indigo-500">
                                <span class="ml-2">Wifi</span>
                            </label>
                            <label class="inline-flex items-center">
                                <input type="checkbox" name="features[]" value="Parking" class="rounded text-indigo-600 focus:ring-indigo-500">
                                <span class="ml-2">Parking</span>
                            </label>
                        </div>
                    </div>

                    <div class="flex items-center space-x-4">
                        <button type="submit" class="bg-indigo-600 hover:bg-indigo-700 text-white font-bold py-2 px-6 rounded transition">
                            Create Hall
                        </button>
                        <a href="<?php echo e(route('admin.halls.index')); ?>" class="text-gray-600 hover:text-gray-900">Cancel</a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\Shanaka\OneDrive\Documents\hotelbooking\resources\views/admin/halls/create.blade.php ENDPATH**/ ?>