

<?php $__env->startSection('page-title', 'Dashboard'); ?>

<?php $__env->startSection('content'); ?>
<!-- Welcome Banner -->
<div class="bg-gradient-to-r from-slate-900 via-slate-800 to-slate-900 rounded-2xl p-8 mb-8 shadow-xl relative overflow-hidden">
    <div class="absolute top-0 right-0 w-64 h-64 bg-amber-500/10 rounded-full -mr-32 -mt-32"></div>
    <div class="absolute bottom-0 left-0 w-48 h-48 bg-amber-500/10 rounded-full -ml-24 -mb-24"></div>
    <div class="relative">
        <div class="flex items-center justify-between">
            <div>
                <h1 class="text-3xl font-bold text-white mb-2">Welcome back, <?php echo e(Auth::user()->name); ?>! 👋</h1>
                <p class="text-slate-300">Here's what's happening with your hotel today.</p>
            </div>
            <div class="flex items-center gap-4">
                <!-- Christmas Snow Mode Toggle -->
                <div class="bg-white/10 backdrop-blur-md rounded-2xl px-6 py-3 border border-white/20 flex items-center gap-4">
                    <div class="flex items-center gap-3">
                        <div class="w-10 h-10 bg-blue-500/20 rounded-xl flex items-center justify-center text-blue-300">
                            <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 15a4 4 0 004 4h9a5 5 0 10-.1-9.999 5.002 5.002 0 10-9.78 2.096A4.001 4.001 0 003 15z"/>
                            </svg>
                        </div>
                        <div>
                            <p class="text-xs font-semibold text-slate-300 uppercase tracking-wider">Site Effect</p>
                            <p class="text-sm font-bold text-white">Christmas Snow</p>
                        </div>
                    </div>
                    <label class="relative inline-flex items-center cursor-pointer group">
                        <input type="checkbox" id="snow-toggle" class="sr-only peer" <?php echo e($snow_mode === 'on' ? 'checked' : ''); ?>>
                        <div class="w-14 h-7 bg-slate-700 peer-focus:outline-none rounded-full peer peer-checked:after:translate-x-full rtl:peer-checked:after:-translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:start-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-6 after:w-6 after:transition-all peer-checked:bg-emerald-500"></div>
                    </label>
                </div>

                <div class="hidden md:flex items-center space-x-3">
                    <div class="text-right">
                        <p class="text-sm text-slate-400">Current Date</p>
                        <p class="text-lg font-semibold text-white"><?php echo e(now()->format('M d, Y')); ?></p>
                    </div>
                    <div class="w-12 h-12 bg-amber-500/20 backdrop-blur-sm rounded-xl flex items-center justify-center">
                        <svg class="w-6 h-6 text-amber-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"/>
                        </svg>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Stats Grid -->
<div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">
    <!-- Total Rooms -->
    <div class="group bg-white rounded-2xl shadow-sm hover:shadow-xl p-6 border border-slate-100 transition-all duration-300 hover:-translate-y-1">
        <div class="flex items-center justify-between mb-4">
            <div class="w-14 h-14 bg-gradient-to-br from-blue-500 to-blue-600 rounded-xl flex items-center justify-center shadow-lg shadow-blue-500/30 group-hover:scale-110 transition-transform">
                <svg class="w-7 h-7 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"></path>
                </svg>
            </div>
            <span class="text-xs font-semibold text-blue-600 bg-blue-50 px-3 py-1 rounded-full">+12%</span>
        </div>
        <div>
            <p class="text-sm font-medium text-slate-600 mb-1">Total Rooms</p>
            <p class="text-4xl font-bold bg-gradient-to-r from-slate-900 to-slate-700 bg-clip-text text-transparent"><?php echo e($stats['total_rooms'] ?? 0); ?></p>
        </div>
    </div>

    <!-- Total Bookings -->
    <div class="group bg-white rounded-2xl shadow-sm hover:shadow-xl p-6 border border-slate-100 transition-all duration-300 hover:-translate-y-1">
        <div class="flex items-center justify-between mb-4">
            <div class="w-14 h-14 bg-gradient-to-br from-amber-500 to-amber-600 rounded-xl flex items-center justify-center shadow-lg shadow-amber-500/30 group-hover:scale-110 transition-transform">
                <svg class="w-7 h-7 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"></path>
                </svg>
            </div>
            <span class="text-xs font-semibold text-amber-600 bg-amber-50 px-3 py-1 rounded-full">+24%</span>
        </div>
        <div>
            <p class="text-sm font-medium text-slate-600 mb-1">Total Bookings</p>
            <p class="text-4xl font-bold bg-gradient-to-r from-slate-900 to-slate-700 bg-clip-text text-transparent"><?php echo e($stats['total_bookings'] ?? 0); ?></p>
        </div>
    </div>

    <!-- Active Bookings -->
    <div class="group bg-white rounded-2xl shadow-sm hover:shadow-xl p-6 border border-slate-100 transition-all duration-300 hover:-translate-y-1">
        <div class="flex items-center justify-between mb-4">
            <div class="w-14 h-14 bg-gradient-to-br from-green-500 to-green-600 rounded-xl flex items-center justify-center shadow-lg shadow-green-500/30 group-hover:scale-110 transition-transform">
                <svg class="w-7 h-7 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                </svg>
            </div>
            <span class="text-xs font-semibold text-green-600 bg-green-50 px-3 py-1 rounded-full">Live</span>
        </div>
        <div>
            <p class="text-sm font-medium text-slate-600 mb-1">Active Bookings</p>
            <p class="text-4xl font-bold bg-gradient-to-r from-slate-900 to-slate-700 bg-clip-text text-transparent"><?php echo e($stats['active_bookings'] ?? 0); ?></p>
        </div>
    </div>

    <!-- Total Revenue -->
    <div class="group bg-white rounded-2xl shadow-sm hover:shadow-xl p-6 border border-slate-100 transition-all duration-300 hover:-translate-y-1">
        <div class="flex items-center justify-between mb-4">
            <div class="w-14 h-14 bg-gradient-to-br from-purple-500 to-purple-600 rounded-xl flex items-center justify-center shadow-lg shadow-purple-500/30 group-hover:scale-110 transition-transform">
                <svg class="w-7 h-7 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                </svg>
            </div>
            <span class="text-xs font-semibold text-purple-600 bg-purple-50 px-3 py-1 rounded-full">+18%</span>
        </div>
        <div>
            <p class="text-sm font-medium text-slate-600 mb-1">Total Revenue</p>
            <p class="text-4xl font-bold bg-gradient-to-r from-slate-900 to-slate-700 bg-clip-text text-transparent">LKR <?php echo e(number_format($stats['total_revenue'] ?? 0, 0)); ?></p>
        </div>
    </div>
</div>

<!-- Recent Bookings & Room Status -->
<div class="grid grid-cols-1 lg:grid-cols-3 gap-6 mb-8">
    <!-- Recent Bookings -->
    <div class="lg:col-span-2 bg-white rounded-2xl shadow-sm border border-slate-100">
        <div class="p-6 border-b border-slate-100">
            <div class="flex items-center justify-between">
                <div>
                    <h3 class="text-xl font-bold text-slate-900">Recent Bookings</h3>
                    <p class="text-sm text-slate-500 mt-1">Latest reservations from customers</p>
                </div>
                <a href="<?php echo e(route('admin.bookings.index')); ?>" class="inline-flex items-center px-4 py-2 bg-slate-900 text-white text-sm font-semibold rounded-lg hover:bg-slate-800 transition">
                    View All
                    <svg class="w-4 h-4 ml-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"/>
                    </svg>
                </a>
            </div>
        </div>
        <div class="p-6">
            <?php if(isset($recent_bookings) && $recent_bookings->count() > 0): ?>
                <div class="space-y-4">
                    <?php $__currentLoopData = $recent_bookings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $booking): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="group flex items-center justify-between p-4 bg-slate-50 rounded-xl hover:bg-slate-100 transition-all duration-200 border border-slate-100 hover:border-slate-200">
                            <div class="flex items-center space-x-4">
                                <div class="relative">
                                    <div class="w-14 h-14 bg-gradient-to-br from-amber-500 to-amber-600 rounded-xl flex items-center justify-center shadow-md">
                                        <span class="text-white font-bold text-lg"><?php echo e($booking->room->room_number); ?></span>
                                    </div>
                                    <div class="absolute -top-1 -right-1 w-5 h-5 bg-green-500 rounded-full border-2 border-white flex items-center justify-center">
                                        <svg class="w-3 h-3 text-white" fill="currentColor" viewBox="0 0 20 20">
                                            <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/>
                                        </svg>
                                    </div>
                                </div>
                                <div>
                                    <p class="font-bold text-slate-900 text-lg"><?php echo e($booking->user->name); ?></p>
                                    <p class="text-sm text-slate-500 flex items-center mt-1">
                                        <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16"/>
                                        </svg>
                                        <?php echo e($booking->room->type); ?> Room
                                    </p>
                                </div>
                            </div>
                            <div class="text-right">
                                <p class="font-bold text-slate-900 text-lg mb-2">LKR <?php echo e(number_format($booking->total_price, 0)); ?></p>
                                <span class="inline-flex items-center text-xs font-semibold px-3 py-1.5 rounded-full
                                    <?php if($booking->status === 'confirmed'): ?> bg-green-100 text-green-700
                                    <?php elseif($booking->status === 'pending'): ?> bg-yellow-100 text-yellow-700
                                    <?php else: ?> bg-red-100 text-red-700
                                    <?php endif; ?>">
                                    <span class="w-1.5 h-1.5 rounded-full mr-2
                                        <?php if($booking->status === 'confirmed'): ?> bg-green-500
                                        <?php elseif($booking->status === 'pending'): ?> bg-yellow-500
                                        <?php else: ?> bg-red-500
                                        <?php endif; ?>"></span>
                                    <?php echo e(ucfirst($booking->status)); ?>

                                </span>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            <?php else: ?>
                <div class="text-center py-16">
                    <div class="w-20 h-20 bg-slate-100 rounded-2xl flex items-center justify-center mx-auto mb-4">
                        <svg class="w-10 h-10 text-slate-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"/>
                        </svg>
                    </div>
                    <p class="text-slate-500 font-medium">No recent bookings</p>
                    <p class="text-sm text-slate-400 mt-1">New bookings will appear here</p>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <!-- Room Status -->
    <div class="bg-white rounded-2xl shadow-sm border border-slate-100">
        <div class="p-6 border-b border-slate-100">
            <h3 class="text-xl font-bold text-slate-900">Room Status</h3>
            <p class="text-sm text-slate-500 mt-1">Current availability</p>
        </div>
        <div class="p-6">
            <?php if(isset($room_stats)): ?>
                <div class="space-y-4">
                    <!-- Available -->
                    <div class="group relative overflow-hidden rounded-xl bg-gradient-to-br from-green-50 to-emerald-50 p-5 border border-green-100 hover:shadow-md transition-all duration-200">
                        <div class="flex items-center justify-between relative z-10">
                            <div class="flex items-center space-x-3">
                                <div class="w-12 h-12 bg-green-500 rounded-xl flex items-center justify-center shadow-lg shadow-green-500/30">
                                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                                    </svg>
                                </div>
                                <div>
                                    <p class="font-semibold text-green-900">Available</p>
                                    <p class="text-xs text-green-600">Ready to book</p>
                                </div>
                            </div>
                            <div class="text-right">
                                <p class="text-3xl font-bold text-green-700"><?php echo e($room_stats['available'] ?? 0); ?></p>
                                <p class="text-xs text-green-600 mt-1">rooms</p>
                            </div>
                        </div>
                        <div class="absolute top-0 right-0 w-32 h-32 bg-green-500/5 rounded-full -mr-16 -mt-16"></div>
                    </div>

                    <!-- Occupied -->
                    <div class="group relative overflow-hidden rounded-xl bg-gradient-to-br from-yellow-50 to-orange-50 p-5 border border-yellow-100 hover:shadow-md transition-all duration-200">
                        <div class="flex items-center justify-between relative z-10">
                            <div class="flex items-center space-x-3">
                                <div class="w-12 h-12 bg-yellow-500 rounded-xl flex items-center justify-center shadow-lg shadow-yellow-500/30">
                                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197M13 7a4 4 0 11-8 0 4 4 0 018 0z"/>
                                    </svg>
                                </div>
                                <div>
                                    <p class="font-semibold text-yellow-900">Occupied</p>
                                    <p class="text-xs text-yellow-600">Currently in use</p>
                                </div>
                            </div>
                            <div class="text-right">
                                <p class="text-3xl font-bold text-yellow-700"><?php echo e($room_stats['occupied'] ?? 0); ?></p>
                                <p class="text-xs text-yellow-600 mt-1">rooms</p>
                            </div>
                        </div>
                        <div class="absolute top-0 right-0 w-32 h-32 bg-yellow-500/5 rounded-full -mr-16 -mt-16"></div>
                    </div>

                    <!-- Maintenance -->
                    <div class="group relative overflow-hidden rounded-xl bg-gradient-to-br from-red-50 to-rose-50 p-5 border border-red-100 hover:shadow-md transition-all duration-200">
                        <div class="flex items-center justify-between relative z-10">
                            <div class="flex items-center space-x-3">
                                <div class="w-12 h-12 bg-red-500 rounded-xl flex items-center justify-center shadow-lg shadow-red-500/30">
                                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z"/>
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"/>
                                    </svg>
                                </div>
                                <div>
                                    <p class="font-semibold text-red-900">Maintenance</p>
                                    <p class="text-xs text-red-600">Under repair</p>
                                </div>
                            </div>
                            <div class="text-right">
                                <p class="text-3xl font-bold text-red-700"><?php echo e($room_stats['maintenance'] ?? 0); ?></p>
                                <p class="text-xs text-red-600 mt-1">rooms</p>
                            </div>
                        </div>
                        <div class="absolute top-0 right-0 w-32 h-32 bg-red-500/5 rounded-full -mr-16 -mt-16"></div>
                    </div>
                </div>

                <!-- Total Progress -->
                <div class="mt-6 p-4 bg-slate-50 rounded-xl border border-slate-100">
                    <div class="flex items-center justify-between mb-2">
                        <span class="text-sm font-medium text-slate-600">Occupancy Rate</span>
                        <span class="text-sm font-bold text-slate-900">
                            <?php echo e($room_stats['total'] > 0 ? round(($room_stats['occupied'] / $room_stats['total']) * 100) : 0); ?>%
                        </span>
                    </div>
                    <div class="w-full bg-slate-200 rounded-full h-2.5 overflow-hidden">
                        <div class="bg-gradient-to-r from-amber-500 to-amber-600 h-2.5 rounded-full transition-all duration-500" 
                             style="width: <?php echo e($room_stats['total'] > 0 ? ($room_stats['occupied'] / $room_stats['total']) * 100 : 0); ?>%">
                        </div>
                    </div>
                </div>
            <?php else: ?>
                <div class="text-center py-12">
                    <div class="w-16 h-16 bg-slate-100 rounded-2xl flex items-center justify-center mx-auto mb-4">
                        <svg class="w-8 h-8 text-slate-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16"/>
                        </svg>
                    </div>
                    <p class="text-slate-500 font-medium">No room data</p>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<!-- Quick Actions -->
<div class="grid grid-cols-1 md:grid-cols-3 gap-6">
    <!-- Add New Room -->
    <a href="<?php echo e(route('admin.rooms.create')); ?>" class="group relative overflow-hidden bg-gradient-to-br from-slate-900 via-slate-800 to-slate-900 rounded-2xl p-6 hover:shadow-2xl transition-all duration-300 hover:-translate-y-1">
        <div class="absolute top-0 right-0 w-32 h-32 bg-amber-500/10 rounded-full -mr-16 -mt-16"></div>
        <div class="relative">
            <div class="flex items-start justify-between mb-4">
                <div class="w-14 h-14 bg-amber-500/20 backdrop-blur-sm rounded-xl flex items-center justify-center group-hover:scale-110 transition-transform">
                    <svg class="w-7 h-7 text-amber-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"></path>
                    </svg>
                </div>
                <svg class="w-6 h-6 text-amber-400 opacity-50 group-hover:opacity-100 transition" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3"/>
                </svg>
            </div>
            <h4 class="text-xl font-bold text-white mb-2">Add New Room</h4>
            <p class="text-slate-400 text-sm">Create a new room listing for your hotel</p>
        </div>
    </a>

    <!-- Manage Bookings -->
    <a href="<?php echo e(route('admin.bookings.index')); ?>" class="group relative overflow-hidden bg-gradient-to-br from-amber-500 via-amber-600 to-amber-500 rounded-2xl p-6 hover:shadow-2xl transition-all duration-300 hover:-translate-y-1">
        <div class="absolute top-0 right-0 w-32 h-32 bg-white/10 rounded-full -mr-16 -mt-16"></div>
        <div class="relative">
            <div class="flex items-start justify-between mb-4">
                <div class="w-14 h-14 bg-white/20 backdrop-blur-sm rounded-xl flex items-center justify-center group-hover:scale-110 transition-transform">
                    <svg class="w-7 h-7 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"></path>
                    </svg>
                </div>
                <svg class="w-6 h-6 text-white opacity-50 group-hover:opacity-100 transition" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3"/>
                </svg>
            </div>
            <h4 class="text-xl font-bold text-white mb-2">Manage Bookings</h4>
            <p class="text-amber-100 text-sm">View and manage all reservations</p>
        </div>
    </a>

    <!-- View Website -->
    <a href="<?php echo e(route('home')); ?>" class="group relative overflow-hidden bg-white border-2 border-slate-200 rounded-2xl p-6 hover:shadow-2xl transition-all duration-300 hover:-translate-y-1 hover:border-amber-500">
        <div class="absolute top-0 right-0 w-32 h-32 bg-amber-500/5 rounded-full -mr-16 -mt-16"></div>
        <div class="relative">
            <div class="flex items-start justify-between mb-4">
                <div class="w-14 h-14 bg-slate-100 group-hover:bg-amber-50 rounded-xl flex items-center justify-center group-hover:scale-110 transition-all">
                    <svg class="w-7 h-7 text-slate-700 group-hover:text-amber-600 transition" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 6H6a2 2 0 00-2 2v10a2 2 0 002 2h10a2 2 0 002-2v-4M14 4h6m0 0v6m0-6L10 14"></path>
                    </svg>
                </div>
                <svg class="w-6 h-6 text-slate-400 group-hover:text-amber-600 opacity-50 group-hover:opacity-100 transition" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3"/>
                </svg>
            </div>
            <h4 class="text-xl font-bold text-slate-900 mb-2">View Website</h4>
            <p class="text-slate-600 text-sm">Check the public-facing hotel site</p>
        </div>
    </a>
</div>
<?php $__env->startPush('scripts'); ?>
<script>
    document.getElementById('snow-toggle')?.addEventListener('change', function() {
        fetch("<?php echo e(route('admin.settings.toggle-snow')); ?>", {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': "<?php echo e(csrf_token()); ?>"
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.status === 'success') {
                window.location.reload();
            }
        });
    });
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\Shanaka\OneDrive\Documents\hotelbooking\resources\views/admin/dashboard.blade.php ENDPATH**/ ?>