

<?php $__env->startSection('content'); ?>
<div class="py-12">
    <div class="max-w-4xl mx-auto sm:px-6 lg:px-8">
        <div class="mb-6 flex items-center justify-between">
            <h2 class="text-2xl font-semibold text-gray-800">Hall Booking Details #<?php echo e($hallBooking->id); ?></h2>
            <a href="<?php echo e(route('admin.hall-bookings.index')); ?>" class="text-indigo-600 hover:text-indigo-900 font-medium">&larr; Back to List</a>
        </div>

        <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
            <div class="p-8">
                <div class="grid grid-cols-1 md:grid-cols-2 gap-8 mb-8 border-b pb-8">
                    <div>
                        <h3 class="text-sm font-bold text-gray-400 uppercase tracking-widest mb-4">Customer Info</h3>
                        <p class="text-lg font-bold text-gray-900"><?php echo e($hallBooking->user->name); ?></p>
                        <p class="text-gray-500"><?php echo e($hallBooking->user->email); ?></p>
                    </div>
                    <div>
                        <h3 class="text-sm font-bold text-gray-400 uppercase tracking-widest mb-4">Venue Info</h3>
                        <p class="text-lg font-bold text-gray-900"><?php echo e($hallBooking->hall->name); ?></p>
                        <p class="text-indigo-600 font-bold">LKR <?php echo e(number_format($hallBooking->total_price, 2)); ?></p>
                    </div>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-3 gap-8 mb-8">
                    <div>
                        <h3 class="text-sm font-bold text-gray-400 uppercase tracking-widest mb-2">Event Date</h3>
                        <p class="text-lg font-bold text-gray-900"><?php echo e($hallBooking->event_date->format('F d, Y')); ?></p>
                    </div>
                    <div>
                        <h3 class="text-sm font-bold text-gray-400 uppercase tracking-widest mb-2">Event Type</h3>
                        <p class="text-lg font-bold text-gray-900"><?php echo e($hallBooking->event_type); ?></p>
                    </div>
                    <div>
                        <h3 class="text-sm font-bold text-gray-400 uppercase tracking-widest mb-2">Status</h3>
                        <span class="px-3 py-1 inline-flex text-xs leading-5 font-bold rounded-full 
                            <?php if($hallBooking->status === 'confirmed'): ?> bg-green-100 text-green-800 
                            <?php elseif($hallBooking->status === 'pending'): ?> bg-yellow-100 text-yellow-800 
                            <?php else: ?> bg-red-100 text-red-800 <?php endif; ?> uppercase">
                            <?php echo e($hallBooking->status); ?>

                        </span>
                    </div>
                </div>

                <div class="bg-gray-50 p-6 rounded-2xl border border-gray-100">
                    <h3 class="text-lg font-bold text-gray-900 mb-4">Update Status</h3>
                    <form action="<?php echo e(route('admin.hall-bookings.update', $hallBooking->id)); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PUT'); ?>
                        <div class="flex items-end space-x-4">
                            <div class="flex-1">
                                <label for="status" class="block text-sm font-medium text-gray-700 mb-1">Booking Status</label>
                                <select name="status" id="status" class="w-full rounded-xl border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                                    <option value="pending" <?php echo e($hallBooking->status === 'pending' ? 'selected' : ''); ?>>Pending</option>
                                    <option value="confirmed" <?php echo e($hallBooking->status === 'confirmed' ? 'selected' : ''); ?>>Confirmed</option>
                                    <option value="cancelled" <?php echo e($hallBooking->status === 'cancelled' ? 'selected' : ''); ?>>Cancelled</option>
                                    <option value="completed" <?php echo e($hallBooking->status === 'completed' ? 'selected' : ''); ?>>Completed</option>
                                </select>
                            </div>
                            <button type="submit" class="bg-indigo-600 hover:bg-indigo-700 text-white font-bold py-2.5 px-6 rounded-xl transition shadow-lg">
                                Update Status
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\Shanaka\OneDrive\Documents\hotelbooking\resources\views/admin/hall_bookings/show.blade.php ENDPATH**/ ?>