<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title><?php echo e(config('app.name', "70's Eco Village")); ?></title>
    
    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=playfair-display:400,500,600,700,800,900|inter:300,400,500,600,700&display=swap" rel="stylesheet" />
    
    <!-- Scripts -->
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
    
    <style>
        .font-display { font-family: 'Playfair Display', serif; }
        .font-body { font-family: 'Inter', sans-serif; }
        
        /* Smooth Page Transitions */
        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(20px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        
        .page-enter {
            animation: fadeInUp 0.6s ease-out;
        }

        /* Custom Scrollbar */
        ::-webkit-scrollbar {
            width: 12px;
        }

        ::-webkit-scrollbar-track {
            background: linear-gradient(180deg, #f1f5f9, #e2e8f0);
        }

        ::-webkit-scrollbar-thumb {
            background: linear-gradient(180deg, #558B2F, #33691E);
            border-radius: 6px;
            border: 2px solid #f1f5f9;
        }

        ::-webkit-scrollbar-thumb:hover {
            background: linear-gradient(180deg, #33691E, #1B5E20);
        }

        /* Smooth Scroll */
        html {
            scroll-behavior: smooth;
        }

        /* Navigation Animation */
        @keyframes slideDown {
            from {
                transform: translateY(-100%);
                opacity: 0;
            }
            to {
                transform: translateY(0);
                opacity: 1;
            }
        }

        .nav-enter {
            animation: slideDown 0.5s ease-out;
        }

        /* Glass Effect */
        .glass-effect {
            background: rgba(255, 255, 255, 0.1);
            backdrop-filter: blur(10px);
            -webkit-backdrop-filter: blur(10px);
        }

        /* Gradient Text */
        .gradient-text {
            background: linear-gradient(135deg, #558B2F, #f59e0b);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }
    </style>
</head>
<body class="font-body antialiased bg-white">
    <?php if(isset($snow_mode) && $snow_mode === 'on'): ?>
        <?php echo $__env->make('components.snow', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <?php endif; ?>
    <!-- Top Bar -->
    <div class="bg-[#558B2F] text-white py-2.5">
        <div class="container mx-auto px-4">
            <div class="flex flex-col md:flex-row justify-between items-center gap-2">
                <div class="flex items-center gap-6 text-sm font-medium tracking-wide">
                    <div class="flex items-center gap-2">
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"/>
                        </svg>
                        123 Lake Road, Colombo 02
                    </div>
                    <div class="flex items-center gap-2">
                        <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 20 20">
                            <path d="M2 3a1 1 0 011-1h2.153a1 1 0 01.986.836l.74 4.435a1 1 0 01-.54 1.06l-1.548.773a11.037 11.037 0 006.105 6.105l.774-1.548a1 1 0 011.059-.54l4.435.74a1 1 0 01.836.986V17a1 1 0 01-1 1h-2C7.82 18 2 12.18 2 5V3z"/>
                        </svg>
                        +94 77 123 3652
                    </div>
                </div>
                <div class="flex items-center gap-4">
                    <a href="#" class="hover:text-white/80 transition-colors">
                        <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24"><path d="M18.244 2.25h3.308l-7.227 8.26 8.502 11.24H16.17l-5.214-6.817L4.99 21.75H1.68l7.73-8.835L1.254 2.25H8.08l4.713 6.231zm-1.161 17.52h1.833L7.084 4.126H5.117z"/></svg>
                    </a>
                    <a href="#" class="hover:text-white/80 transition-colors">
                        <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24"><path d="M24 12.073c0-6.627-5.373-12-12-12s-12 5.373-12 12c0 5.99 4.388 10.954 10.125 11.854v-8.385H7.078v-3.47h3.047V9.43c0-3.007 1.791-4.669 4.533-4.669 1.312 0 2.686.235 2.686.235v2.953H15.83c-1.491 0-1.956.925-1.956 1.874v2.25h3.328l-.532 3.47h-2.796v8.385C19.612 23.027 24 18.062 24 12.073z"/></svg>
                    </a>
                    <a href="#" class="hover:text-white/80 transition-colors">
                        <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24"><path d="M12 2.163c3.204 0 3.584.012 4.85.07 3.252.148 4.771 1.691 4.919 4.919.058 1.265.069 1.645.069 4.849 0 3.205-.012 3.584-.069 4.849-.149 3.225-1.664 4.771-4.919 4.919-1.266.058-1.644.07-4.85.07-3.204 0-3.584-.012-4.849-.07-3.26-.149-4.771-1.699-4.919-4.92-.058-1.265-.07-1.644-.07-4.849 0-3.204.013-3.583.07-4.849.149-3.227 1.664-4.771 4.919-4.919 1.266-.057 1.645-.069 4.849-.069zm0-2.163c-3.259 0-3.667.014-4.947.072-4.358.2-6.78 2.618-6.98 6.98-.059 1.281-.073 1.689-.073 4.948 0 3.259.014 3.668.072 4.948.2 4.358 2.618 6.78 6.98 6.98 1.281.058 1.689.072 4.948.072 3.259 0 3.668-.014 4.948-.072 4.354-.2 6.782-2.618 6.979-6.98.059-1.28.073-1.689.073-4.949 0-3.259-.014-3.667-.072-4.947-.196-4.354-2.617-6.78-6.979-6.98-1.281-.059-1.69-.073-4.949-.073zm0 5.838c-3.403 0-6.162 2.759-6.162 6.162s2.759 6.163 6.162 6.163 6.162-2.759 6.162-6.163c0-3.403-2.759-6.162-6.162-6.162zm0 10.162c-2.209 0-4-1.79-4-4 0-2.209 1.791-4 4-4s4 1.791 4 4c0 2.21-1.791 4-4 4zm6.406-11.845c-.796 0-1.441.645-1.441 1.44s.645 1.44 1.441 1.44c.795 0 1.439-.645 1.439-1.44s-.644-1.44-1.439-1.44z"/></svg>
                    </a>
                    <a href="#" class="hover:text-white/80 transition-colors">
                        <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24"><path d="M19 0h-14c-2.761 0-5 2.239-5 5v14c0 2.761 2.239 5 5 5h14c2.761 0 5-2.239 5-5v-14c0-2.761-2.239-5-5-5zm-11 19h-3v-11h3v11zm-1.5-12.268c-.966 0-1.75-.79-1.75-1.764s.784-1.764 1.75-1.764 1.75.79 1.75 1.764-.783 1.764-1.75 1.764zm13.5 12.268h-3v-5.604c0-3.368-4-3.113-4 0v5.604h-3v-11h3v1.765c1.396-2.586 7-2.777 7 2.476v6.759z"/></svg>
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Main Navigation -->
    <nav class="bg-white sticky top-0 z-50 shadow-sm border-b border-gray-100">
        <div class="container mx-auto px-4">
            <div class="flex justify-between items-center h-32">
                <!-- Logo -->
                <a href="<?php echo e(route('home')); ?>" class="flex items-center py-2">
                    <video autoplay muted loop playsinline poster="<?php echo e(asset('images/logo.png')); ?>" class="h-28 w-auto object-contain mix-blend-multiply">
                        <source src="<?php echo e(asset('videos/70_Logo.mp4')); ?>" type="video/mp4">
                        Your browser does not support the video tag.
                    </video>
                </a>

                <!-- Desktop Menu -->
                <div class="hidden lg:flex items-center gap-10">
                    <a href="<?php echo e(route('home')); ?>" class="text-gray-800 hover:text-[#558B2F] font-bold uppercase tracking-wider text-sm transition-colors">About</a>
                    
                    <a href="<?php echo e(route('rooms.index')); ?>" class="text-gray-800 hover:text-[#558B2F] font-bold uppercase tracking-wider text-sm transition-colors">Room</a>


                    <div class="relative group">
                        <button class="flex items-center gap-1 text-gray-800 hover:text-[#558B2F] font-bold uppercase tracking-wider text-sm transition-colors">
                            Services
                            <svg class="w-3 h-3" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/></svg>
                        </button>
                    </div>

                    <a href="<?php echo e(route('contact')); ?>" class="text-gray-800 hover:text-[#558B2F] font-bold uppercase tracking-wider text-sm transition-colors">Contact Us</a>
                </div>

                <!-- Right Action -->
                <div class="hidden lg:flex items-center gap-6">
                    <?php if(auth()->guard()->check()): ?>
                        <div class="relative group">
                            <button class="flex items-center gap-2 px-6 py-2.5 bg-[#558B2F] text-white rounded-md font-bold hover:bg-[#457025] transition-all shadow-md">
                                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"/>
                                </svg>
                                <?php echo e(Auth::user()->name); ?>

                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                                </svg>
                            </button>
                            
                            <!-- Dropdown Menu -->
                            <div class="absolute right-0 mt-2 w-56 bg-white rounded-lg shadow-xl border border-gray-100 opacity-0 invisible group-hover:opacity-100 group-hover:visible transition-all duration-200 z-50">
                                <div class="py-2">
                                    <a href="<?php echo e(route('dashboard')); ?>" class="flex items-center gap-3 px-4 py-3 text-gray-700 hover:bg-[#558B2F] hover:text-white transition-colors">
                                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6"/>
                                        </svg>
                                        Dashboard
                                    </a>
                                    <a href="<?php echo e(route('profile.edit')); ?>" class="flex items-center gap-3 px-4 py-3 text-gray-700 hover:bg-[#558B2F] hover:text-white transition-colors">
                                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"/>
                                        </svg>
                                        Profile
                                    </a>
                                    <div class="border-t border-gray-100 my-2"></div>
                                    <form method="POST" action="<?php echo e(route('logout')); ?>">
                                        <?php echo csrf_field(); ?>
                                        <button type="submit" class="flex items-center gap-3 w-full px-4 py-3 text-left text-red-600 hover:bg-red-50 transition-colors">
                                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1"/>
                                            </svg>
                                            Logout
                                        </button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    <?php else: ?>
                        <a href="<?php echo e(route('rooms.index')); ?>" class="px-8 py-3 bg-[#558B2F] hover:bg-[#457025] text-white font-bold rounded shadow-lg hover:shadow-xl transition-all duration-300 uppercase tracking-widest text-sm">
                            Book Now
                        </a>
                        <a href="<?php echo e(route('login')); ?>" class="px-6 py-2.5 text-[#558B2F] font-bold hover:text-[#457025] transition-colors">Login</a>
                        <a href="<?php echo e(route('register')); ?>" class="px-8 py-3 bg-[#558B2F] text-white rounded-md font-bold hover:bg-[#457025] transition-all shadow-md">Register</a>
                    <?php endif; ?>
                </div>

                <!-- Mobile menu button -->
                <button id="mobile-menu-btn" class="lg:hidden text-gray-800 p-2">
                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16"/>
                    </svg>
                </button>
            </div>
        </div>

        <!-- Mobile Menu -->
        <div id="mobile-menu" class="hidden lg:hidden bg-white border-t border-gray-100 p-4">
            <div class="flex flex-col gap-4">
                <a href="<?php echo e(route('home')); ?>" class="text-gray-800 font-semibold hover:text-[#558B2F]">About</a>
                <a href="<?php echo e(route('rooms.index')); ?>" class="text-gray-800 font-semibold hover:text-[#558B2F]">Room</a>

                <button class="text-gray-800 font-semibold hover:text-[#558B2F] text-left">Services</button>
                <a href="<?php echo e(route('contact')); ?>" class="text-gray-800 font-semibold hover:text-[#558B2F]">Contact Us</a>
                <?php if(auth()->guard()->check()): ?>
                    <a href="<?php echo e(route('dashboard')); ?>" class="w-full text-center py-3 bg-[#558B2F] text-white rounded-md font-bold">Dashboard</a>
                <?php else: ?>
                    <a href="<?php echo e(route('rooms.index')); ?>" class="w-full text-center py-3 bg-[#558B2F] text-white rounded-md font-bold">Book Now</a>
                <?php endif; ?>
            </div>
        </div>
    </nav>


    <!-- Page Content -->
    <main class="min-h-screen page-enter">
        <?php echo $__env->yieldContent('content'); ?>
        <?php echo e($slot ?? ''); ?>

    </main>

    <!-- Footer -->
    <!-- Footer -->
    <footer class="footer-pattern text-white pt-16 pb-8">
        <style>
            .footer-pattern {
                background-color: #2c2c2c;
                background-image: 
                    linear-gradient(30deg, #333 12%, transparent 12.5%, transparent 87%, #333 87.5%, #333),
                    linear-gradient(150deg, #333 12%, transparent 12.5%, transparent 87%, #333 87.5%, #333),
                    linear-gradient(30deg, #2a2a2a 12%, transparent 12.5%, transparent 87%, #2a2a2a 87.5%, #2a2a2a),
                    linear-gradient(150deg, #2a2a2a 12%, transparent 12.5%, transparent 87%, #2a2a2a 87.5%, #2a2a2a),
                    linear-gradient(60deg, #3a3a3a 25%, transparent 25.5%, transparent 75%, #3a3a3a 75%, #3a3a3a),
                    linear-gradient(60deg, #3a3a3a 25%, transparent 25.5%, transparent 75%, #3a3a3a 75%, #3a3a3a);
                background-size: 40px 70px;
                background-position: 0 0, 0 0, 20px 35px, 20px 35px, 0 0, 20px 35px;
            }
            .footer-logo-pic {
                height: 7rem;
                width: auto;
                margin-bottom: 1.5rem;
                filter: brightness(0) invert(1);
                opacity: 0.9;
            }
            .footer-title {
                font-family: 'Playfair Display', serif;
                font-weight: 700;
                font-size: 1.75rem;
                margin-bottom: 1.5rem;
                color: #ffffff;
            }
            .footer-link {
                color: #d1d1d1;
                transition: color 0.3s;
                font-size: 1.1rem;
            }
            .footer-link:hover {
                color: #ffffff;
            }
            .social-icon-btn {
                width: 3.5rem;
                height: 3.5rem;
                background-color: rgba(255, 255, 255, 0.4);
                border-radius: 9999px;
                display: flex;
                align-items: center;
                justify-content: center;
                transition: background-color 0.3s, transform 0.3s;
                color: white;
            }
            .social-icon-btn:hover {
                background-color: rgba(255, 255, 255, 0.6);
                transform: translateY(-4px);
            }
        </style>
        <div class="container mx-auto px-4 sm:px-6 lg:px-8">
            <div class="grid grid-cols-1 md:grid-cols-3 gap-16 mb-16">
                <!-- Logo & Description -->
                <div>
                    <div class="mb-8">
                        <img src="<?php echo e(asset('images/logo.png')); ?>" class="footer-logo-pic" alt="70's Eco Village Logo">
                        <p class="text-white/80 text-lg leading-relaxed mb-8 max-w-sm">
                            Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor asin incididunt ut magna.
                        </p>
                    </div>
                    <div class="flex items-center gap-4 text-white">
                        <div class="w-12 h-12 flex items-center justify-center">
                            <svg class="w-8 h-8 rotate-90" fill="currentColor" viewBox="0 0 20 20">
                                <path d="M2 3a1 1 0 011-1h2.153a1 1 0 01.986.836l.74 4.435a1 1 0 01-.54 1.06l-1.548.773a11.037 11.037 0 006.105 6.105l.774-1.548a1 1 0 011.059-.54l4.435.74a1 1 0 01.836.986V17a1 1 0 01-1-1h-2C7.82 18 2 12.18 2 5V3z"/>
                            </svg>
                        </div>
                        <div>
                            <p class="text-sm font-medium text-white/70">Have Any Question?</p>
                            <a href="tel:+94771233652" class="text-xl font-bold hover:text-white transition-colors tracking-wide">+94 77 123 3652</a>
                        </div>
                    </div>
                </div>

                <!-- Quick Links -->
                <div class="md:pl-10">
                    <h3 class="footer-title">Quick Links</h3>
                    <ul class="space-y-4">
                        <li><a href="<?php echo e(route('home')); ?>#about" class="footer-link">About Us</a></li>
                        <li><a href="<?php echo e(route('home')); ?>#services" class="footer-link">Services</a></li>
                        <li><a href="<?php echo e(route('contact')); ?>" class="footer-link">Contact us</a></li>
                        <li><a href="<?php echo e(route('rooms.index')); ?>" class="footer-link">Book An Appointment</a></li>
                        <li><a href="<?php echo e(route('contact')); ?>" class="footer-link">FAQ</a></li>
                    </ul>
                </div>

                <!-- Explore -->
                <div>
                    <h3 class="footer-title">Explore</h3>
                    <ul class="space-y-4">
                        <li><a href="<?php echo e(route('rooms.index')); ?>" class="footer-link">Offers</a></li>
                        <li><a href="<?php echo e(route('rooms.index')); ?>" class="footer-link">Rooms</a></li>
                        <li><a href="<?php echo e(route('home')); ?>#gallery" class="footer-link">Gallery</a></li>
                        <li><a href="<?php echo e(route('home')); ?>#testimonials" class="footer-link">Testimonials</a></li>
                        <li><a href="<?php echo e(route('home')); ?>#services" class="footer-link">Restaurant</a></li>
                    </ul>
                </div>
            </div>

            <!-- Social Icons -->
            <div class="flex justify-center flex-wrap gap-8 mb-12">
                <a href="#" class="social-icon-btn">
                    <svg class="w-7 h-7" fill="currentColor" viewBox="0 0 24 24"><path d="M18.244 2.25h3.308l-7.227 8.26 8.502 11.24H16.17l-5.214-6.817L4.99 21.75H1.68l7.73-8.835L1.254 2.25H8.08l4.713 6.231zm-1.161 17.52h1.833L7.084 4.126H5.117z"/></svg>
                </a>
                <a href="#" class="social-icon-btn">
                    <svg class="w-7 h-7" fill="currentColor" viewBox="0 0 24 24"><path d="M24 12.073c0-6.627-5.373-12-12-12s-12 5.373-12 12c0 5.99 4.388 10.954 10.125 11.854v-8.385H7.078v-3.47h3.047V9.43c0-3.007 1.791-4.669 4.533-4.669 1.312 0 2.686.235 2.686.235v2.953H15.83c-1.491 0-1.956.925-1.956 1.874v2.25h3.328l-.532 3.47h-2.796v8.385C19.612 23.027 24 18.062 24 12.073z"/></svg>
                </a>
                <a href="#" class="social-icon-btn">
                    <svg class="w-7 h-7" fill="currentColor" viewBox="0 0 24 24"><path d="M12 2.163c3.204 0 3.584.012 4.85.07 3.252.148 4.771 1.691 4.919 4.919.058 1.265.069 1.645.069 4.849 0 3.205-.012 3.584-.069 4.849-.149 3.225-1.664 4.771-4.919 4.919-1.266.058-1.644.07-4.85.07-3.204 0-3.584-.012-4.849-.07-3.26-.149-4.771-1.699-4.919-4.92-.058-1.265-.07-1.644-.07-4.849 0-3.204.013-3.583.07-4.849.149-3.227 1.664-4.771 4.919-4.919 1.266-.057 1.645-.069 4.849-.069zm0-2.163c-3.259 0-3.667.014-4.947.072-4.358.2-6.78 2.618-6.98 6.98-.059 1.281-.073 1.689-.073 4.948 0 3.259.014 3.668.072 4.948.2 4.358 2.618 6.78 6.98 6.98 1.281.058 1.689.072 4.948.072 3.259 0 3.668-.014 4.948-.072 4.354-.2 6.782-2.618 6.979-6.98.059-1.28.073-1.689.073-4.949 0-3.259-.014-3.667-.072-4.947-.196-4.354-2.617-6.78-6.979-6.98-1.281-.059-1.69-.073-4.949-.073zm0 5.838c-3.403 0-6.162 2.759-6.162 6.162s2.759 6.163 6.162 6.163 6.162-2.759 6.162-6.163c0-3.403-2.759-6.162-6.162-6.162zm0 10.162c-2.209 0-4-1.79-4-4 0-2.209 1.791-4 4-4s4 1.791 4 4c0 2.21-1.791 4-4 4zm6.406-11.845c-.796 0-1.441.645-1.441 1.44s.645 1.44 1.441 1.44c.795 0 1.439-.645 1.439-1.44s-.644-1.44-1.439-1.44z"/></svg>
                </a>
                <a href="#" class="social-icon-btn">
                    <svg class="w-7 h-7" fill="currentColor" viewBox="0 0 24 24"><path d="M19 0h-14c-2.761 0-5 2.239-5 5v14c0 2.761 2.239 5 5 5h14c2.761 0 5-2.239 5-5v-14c0-2.761-2.239-5-5-5zm-11 19h-3v-11h3v11zm-1.5-12.268c-.966 0-1.75-.79-1.75-1.764s.784-1.764 1.75-1.764 1.75.79 1.75 1.764-.783 1.764-1.75 1.764zm13.5 12.268h-3v-5.604c0-3.368-4-3.113-4 0v5.604h-3v-11h3v1.765c1.396-2.586 7-2.777 7 2.476v6.759z"/></svg>
                </a>
                <a href="#" class="social-icon-btn">
                    <svg class="w-7 h-7" fill="currentColor" viewBox="0 0 24 24">
                        <path d="M2.003 5.884L10 9.882l7.997-3.998A2 2 0 0016 4H4a2 2 0 00-1.997 1.884z"/>
                        <path d="M18 8.118l-8 4-8-4V14a2 2 0 002 2h12a2 2 0 002-2V8.118z"/>
                    </svg>
                </a>
            </div>

            <!-- Copyright -->
            <div class="pt-8 border-t border-white/20 text-center">
                <p class="text-white/80 text-lg font-medium">
                    Copyright © 70's Eco Village | Design by <span class="text-white font-bold uppercase">SATASME</span>
                </p>
            </div>
        </div>
    </footer>

    <!-- Back to Top Button -->
    <button onclick="window.scrollTo({top: 0, behavior: 'smooth'})" 
            class="fixed bottom-8 right-8 bg-gradient-to-r from-emerald-500 to-emerald-600 hover:from-emerald-600 hover:to-emerald-700 text-white w-14 h-14 rounded-2xl shadow-2xl hover:shadow-emerald-500/50 transition-all duration-300 flex items-center justify-center z-50 opacity-0 pointer-events-none group" 
            id="backToTop">
        <svg class="w-6 h-6 group-hover:-translate-y-1 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 10l7-7m0 0l7 7m-7-7v18"/>
        </svg>
    </button>

    <!-- WhatsApp Float Button -->
    <a href="https://wa.me/94112345678" target="_blank" class="fixed bottom-24 right-8 bg-green-500 hover:bg-green-600 text-white w-14 h-14 rounded-2xl shadow-2xl hover:shadow-green-500/50 transition-all duration-300 flex items-center justify-center z-50 group hover:scale-110">
        <svg class="w-7 h-7" fill="currentColor" viewBox="0 0 24 24">
            <path d="M17.472 14.382c-.297-.149-1.758-.867-2.03-.967-.273-.099-.471-.148-.67.15-.197.297-.767.966-.94 1.164-.173.199-.347.223-.644.075-.297-.15-1.255-.463-2.39-1.475-.883-.788-1.48-1.761-1.653-2.059-.173-.297-.018-.458.13-.606.134-.133.298-.347.446-.52.149-.174.198-.298.298-.497.099-.198.05-.371-.025-.52-.075-.149-.669-1.612-.916-2.207-.242-.579-.487-.5-.669-.51-.173-.008-.371-.01-.57-.01-.198 0-.52.074-.792.372-.272.297-1.04 1.016-1.04 2.479 0 1.462 1.065 2.875 1.213 3.074.149.198 2.096 3.2 5.077 4.487.709.306 1.262.489 1.694.625.712.227 1.36.195 1.871.118.571-.085 1.758-.719 2.006-1.413.248-.694.248-1.289.173-1.413-.074-.124-.272-.198-.57-.347m-5.421 7.403h-.004a9.87 9.87 0 01-5.031-1.378l-.361-.214-3.741.982.998-3.648-.235-.374a9.86 9.86 0 01-1.51-5.26c.001-5.45 4.436-9.884 9.888-9.884 2.64 0 5.122 1.03 6.988 2.898a9.825 9.825 0 012.893 6.994c-.003 5.45-4.437 9.884-9.885 9.884m8.413-18.297A11.815 11.815 0 0012.05 0C5.495 0 .16 5.335.157 11.892c0 2.096.547 4.142 1.588 5.945L.057 24l6.305-1.654a11.882 11.882 0 005.683 1.448h.005c6.554 0 11.89-5.335 11.893-11.893a11.821 11.821 0 00-3.48-8.413Z"/>
        </svg>
    </a>

    <script>
        // Mobile menu toggle
        document.getElementById('mobile-menu-btn')?.addEventListener('click', function() {
            const menu = document.getElementById('mobile-menu');
            menu.classList.toggle('hidden');
        });

        // Back to top button
        window.addEventListener('scroll', function() {
            const backToTop = document.getElementById('backToTop');
            if (window.scrollY > 300) {
                backToTop.classList.remove('opacity-0', 'pointer-events-none');
                backToTop.classList.add('opacity-100');
            } else {
                backToTop.classList.add('opacity-0', 'pointer-events-none');
                backToTop.classList.remove('opacity-100');
            }
        });

        // Flash Messages
        document.addEventListener('DOMContentLoaded', () => {
            <?php if(session('success')): ?>
                showToast("<?php echo e(session('success')); ?>", 'success');
            <?php endif; ?>

            <?php if(session('error')): ?>
                showToast("<?php echo e(session('error')); ?>", 'error');
            <?php endif; ?>

            <?php if(session('info')): ?>
                showToast("<?php echo e(session('info')); ?>", 'info');
            <?php endif; ?>

            <?php if($errors->any()): ?>
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    showToast("<?php echo e($error); ?>", 'error');
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endif; ?>
        });

        // Toast Notification Function
        function showToast(message, type = 'info') {
            const toast = document.createElement('div');
            const colors = {
                success: 'from-emerald-500 to-emerald-600',
                error: 'from-red-500 to-red-600',
                info: 'from-blue-500 to-blue-600'
            };
            
            toast.className = `fixed top-24 right-8 bg-gradient-to-r ${colors[type]} text-white px-6 py-4 rounded-xl shadow-2xl z-50 transform translate-x-full transition-transform duration-300 max-w-md`;
            toast.innerHTML = `
                <div class="flex items-center gap-3">
                    <svg class="w-6 h-6 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        ${type === 'success' ? '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>' : 
                          type === 'error' ? '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 14l2-2m0 0l2-2m-2 2l-2-2m2 2l2 2m7-2a9 9 0 11-18 0 9 9 0 0118 0z"/>' :
                          '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>'}
                    </svg>
                    <p class="font-medium">${message}</p>
                    <button onclick="this.parentElement.parentElement.remove()" class="ml-4 text-white/80 hover:text-white">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/>
                        </svg>
                    </button>
                </div>
            `;
            document.body.appendChild(toast);
            
            setTimeout(() => toast.classList.remove('translate-x-full'), 100);
            setTimeout(() => {
                toast.classList.add('translate-x-full');
                setTimeout(() => toast.remove(), 300);
            }, 5000);
        }
    </script>

    <!-- Modern Cookie Consent -->
    <div id="cookieConsent" class="fixed bottom-0 left-0 right-0 bg-gradient-to-r from-slate-900 via-emerald-900 to-slate-900 backdrop-blur-xl text-white p-6 shadow-2xl z-50 transform translate-y-full transition-transform duration-500 border-t-4 border-emerald-500">
        <div class="container mx-auto">
            <div class="flex flex-col lg:flex-row items-center justify-between gap-6">
                <div class="flex items-start gap-4 flex-1">
                    <div class="w-14 h-14 bg-gradient-to-br from-emerald-500 to-emerald-600 rounded-2xl flex items-center justify-center flex-shrink-0 shadow-lg">
                        <svg class="w-7 h-7 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6V4m0 2a2 2 0 100 4m0-4a2 2 0 110 4m-6 8a2 2 0 100-4m0 4a2 2 0 110-4m0 4v2m0-6V4m6 6v10m6-2a2 2 0 100-4m0 4a2 2 0 110-4m0 4v2m0-6V4"/>
                        </svg>
                    </div>
                    <div>
                        <h3 class="font-bold text-xl mb-2 flex items-center gap-2">
                            🍪 We Value Your Privacy
                        </h3>
                        <p class="text-slate-300 text-sm leading-relaxed max-w-2xl">
                            We use cookies to enhance your browsing experience, serve personalized content, and analyze our traffic. 
                            By clicking "Accept All", you consent to our use of cookies. 
                            <a href="#" class="text-emerald-400 hover:text-emerald-300 underline font-semibold">Learn more</a>
                        </p>
                    </div>
                </div>
                <div class="flex gap-3 flex-shrink-0">
                    <button onclick="declineCookies()" class="px-6 py-3 bg-white/10 hover:bg-white/20 text-white rounded-xl font-semibold transition-all duration-300 border-2 border-white/20 hover:border-white/40 hover:scale-105">
                        Decline
                    </button>
                    <button onclick="acceptCookies()" class="px-8 py-3 bg-gradient-to-r from-emerald-500 to-emerald-600 hover:from-emerald-600 hover:to-emerald-700 text-white rounded-xl font-bold transition-all duration-300 shadow-lg hover:shadow-2xl hover:shadow-emerald-500/50 hover:scale-105">
                        Accept All
                    </button>
                </div>
            </div>
        </div>
    </div>

    <script>
        // Show cookie banner on page load if not already accepted
        window.addEventListener('DOMContentLoaded', function() {
            const cookieConsent = localStorage.getItem('cookieConsent');
            if (!cookieConsent) {
                setTimeout(function() {
                    document.getElementById('cookieConsent').style.transform = 'translateY(0)';
                }, 1500);
            }
        });

        function acceptCookies() {
            localStorage.setItem('cookieConsent', 'accepted');
            hideCookieBanner();
            showToast('Cookie preferences saved!', 'success');
        }

        function declineCookies() {
            localStorage.setItem('cookieConsent', 'declined');
            hideCookieBanner();
            showToast('Cookie preferences saved!', 'info');
        }

        function hideCookieBanner() {
            document.getElementById('cookieConsent').style.transform = 'translateY(100%)';
        }
    </script>
</body>
</html><?php /**PATH C:\Users\Shanaka\OneDrive\Documents\hotelbooking\resources\views/layouts/app.blade.php ENDPATH**/ ?>