<?php

use App\Http\Controllers\ProfileController;
use Illuminate\Support\Facades\Route;

// Customer Routes
Route::get('/', [\App\Http\Controllers\HomeController::class, 'index'])->name('home');
Route::get('/rooms', [\App\Http\Controllers\RoomController::class, 'index'])->name('rooms.index');
Route::get('/rooms/{room}', [\App\Http\Controllers\RoomController::class, 'show'])->name('rooms.show');
Route::get('/rooms/{room}/ai-analysis', [\App\Http\Controllers\RoomAnalysisController::class, 'analyze'])->name('rooms.ai-analysis');
Route::get('/contact', [\App\Http\Controllers\ContactController::class, 'index'])->name('contact');
Route::post('/contact', [\App\Http\Controllers\ContactController::class, 'store'])->name('contact.store');

// Hall Routes
Route::get('/halls', [\App\Http\Controllers\HallController::class, 'index'])->name('halls.index');
Route::get('/halls/{hall}', [\App\Http\Controllers\HallController::class, 'show'])->name('halls.show');

// Booking Routes (require auth)
Route::middleware('auth')->group(function () {
    Route::post('/bookings', [\App\Http\Controllers\BookingController::class, 'store'])->name('bookings.store');
    Route::get('/bookings/{booking}/confirmation', [\App\Http\Controllers\BookingController::class, 'confirmation'])->name('booking.confirmation');
    Route::post('/bookings/check-availability', [\App\Http\Controllers\BookingController::class, 'checkAvailability'])->name('bookings.check-availability');
    Route::post('/reviews', [\App\Http\Controllers\TestimonialController::class, 'store'])->name('testimonials.store');
    
    // Hall Booking Routes
    Route::post('/hall-bookings', [\App\Http\Controllers\HallBookingController::class, 'store'])->name('hall-bookings.store');
    Route::get('/hall-bookings/{booking}/confirmation', [\App\Http\Controllers\HallBookingController::class, 'confirmation'])->name('hall-booking.confirmation');
});

Route::get('/dashboard', function () {
    $user = auth()->user();
    $bookings = \App\Models\Booking::where('user_id', $user->id)
        ->with('room')
        ->latest()
        ->get();
    
    $hallBookings = \App\Models\HallBooking::where('user_id', $user->id)
        ->with('hall')
        ->latest()
        ->get();
    
    $stats = [
        'total_bookings' => $bookings->count() + $hallBookings->count(),
        'active_bookings' => $bookings->where('status', 'confirmed')->where('check_out', '>=', now())->count() + 
                         $hallBookings->where('status', 'confirmed')->where('event_date', '>=', now())->count(),
        'total_spent' => $bookings->sum('total_price') + $hallBookings->sum('total_price'),
    ];

    $canReview = \App\Models\Booking::where('user_id', $user->id)
        ->where('status', 'confirmed')
        ->where('check_out', '<', now())
        ->exists();

    return view('dashboard', compact('bookings', 'hallBookings', 'stats', 'canReview'));
})->middleware(['auth', 'verified'])->name('dashboard');

Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});

Route::middleware(['auth', 'verified', 'admin'])->prefix('admin')->name('admin.')->group(function () {
    Route::get('/dashboard', [\App\Http\Controllers\Admin\DashboardController::class, 'index'])->name('dashboard');
    Route::resource('rooms', \App\Http\Controllers\Admin\RoomController::class);
    Route::resource('halls', \App\Http\Controllers\Admin\HallController::class);
    Route::resource('hall-bookings', \App\Http\Controllers\Admin\HallBookingController::class)->only(['index', 'show', 'update']);
    Route::resource('bookings', \App\Http\Controllers\Admin\BookingController::class);
    Route::resource('gallery', \App\Http\Controllers\Admin\GalleryController::class)->only(['index', 'store', 'destroy']);
    Route::resource('testimonials', \App\Http\Controllers\Admin\TestimonialController::class)->only(['index', 'update', 'destroy']);
    Route::resource('amenities', \App\Http\Controllers\Admin\AmenityController::class)->except(['show', 'edit', 'update']);
    Route::resource('facilities', \App\Http\Controllers\Admin\FacilityController::class)->except(['show', 'edit', 'update']);
    Route::resource('inquiries', \App\Http\Controllers\Admin\InquiryController::class)->only(['index', 'update', 'destroy']);
    Route::post('/settings/toggle-snow', [\App\Http\Controllers\Admin\SettingController::class, 'toggleSnowMode'])->name('settings.toggle-snow');
});

require __DIR__.'/auth.php';
