<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>{{ config('app.name', 'Lucxorio Hotel') }}</title>
    
    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=figtree:400,500,600|playfair-display:400,700&display=swap" rel="stylesheet" />

    <!-- Scripts -->
    @vite(['resources/css/app.css', 'resources/js/app.js'])
</head>
<body class="font-sans antialiased bg-theme-gold text-white">

    @include('layouts.public-navigation')

    <!-- Hero Section -->
    <div class="relative bg-gradient-to-br from-[#3d6320] via-[#558B2F] to-[#4a7a28] pt-20 pb-44 lg:pb-64 overflow-hidden">
        <!-- Background Pattern -->
        <div class="absolute inset-0 opacity-10" style="background-image: radial-gradient(circle at 2px 2px, rgba(255,255,255,0.15) 1px, transparent 0); background-size: 40px 40px;"></div>
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 relative z-10">
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 lg:gap-8 items-center">
                
                <!-- Left Content -->
                <div class="text-left">
                    <h1 class="font-serif text-5xl md:text-6xl lg:text-7xl font-bold mb-6 leading-tight text-white drop-shadow-md">
                        Modern Villa With <br>
                        <span class="text-[#c6d95f]">70's Eco Village</span>
                    </h1>
                    <p class="text-white/90 text-lg mb-8 max-w-lg leading-relaxed font-medium">
                        At our hotel, luxury is more than just a word it's a tradition. 
                        From exquisite design to personalized service, every detail is 
                        thoughtfully curated to create unforgettable experiences.
                    </p>
                    <div class="flex flex-wrap gap-4">
                        <a href="#rooms" class="px-8 py-4 bg-[#558b2f] text-white font-bold rounded-lg shadow-lg hover:bg-[#467526] transition-all duration-300 uppercase tracking-wider text-sm flex items-center gap-2">
                            Discover Now <span class="text-lg">→</span>
                        </a>
                        <a href="{{ route('rooms.index') }}" class="px-8 py-4 bg-black/20 backdrop-blur-md border border-white/20 text-white font-bold rounded-lg hover:bg-black/30 transition-all duration-300 uppercase tracking-wider text-sm">
                            Book Now
                        </a>
                    </div>
                </div>

                <!-- Right Video -->
                <div class="relative mt-12 lg:mt-0">
                    <!-- Decorative background blob -->
                    <div class="absolute -inset-4 bg-[#E8F1DE] rounded-[3rem] transform rotate-3 -z-10 opacity-70"></div>
                    
                    <div class="relative rounded-[2.5rem] overflow-hidden shadow-2xl border-4 border-white">
                        <video autoplay muted loop playsinline class="w-full h-[400px] lg:h-[500px] object-cover">
                            <source src="{{ asset('videos/hero-video.mp4') }}" type="video/mp4">
                            Your browser does not support the video tag.
                        </video>
                    </div>
                </div>

            </div>
        </div>

        <!-- Booking Form Container (Overlapping) -->
        <div class="absolute bottom-0 left-0 right-0 translate-y-1/2 px-4 z-20">
             <div class="max-w-7xl mx-auto bg-white p-8 rounded-2xl shadow-2xl">
                <div class="flex items-center gap-3 mb-8">
                    <div class="w-1.5 h-8 bg-[#558B2F] rounded-full"></div>
                    <h2 class="font-serif text-3xl text-gray-900 font-bold">Check Availability</h2>
                </div>
                
                <form action="{{ route('rooms.index') }}" method="GET">
                    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-6 gap-6 items-end">
                        <!-- Check In -->
                        <div class="text-left">
                            <label class="block text-gray-400 text-[10px] font-bold mb-2 uppercase tracking-widest">Check In</label>
                            <div class="relative">
                                <input type="text" onfocus="(this.type='date')" onblur="(this.type='text')"
                                       name="check_in" 
                                       placeholder="Select Date"
                                       class="w-full px-4 py-3 bg-gray-50 border border-gray-200 rounded-lg text-gray-700 placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-[#558B2F] focus:border-transparent transition-all duration-300"
                                       required>
                            </div>
                        </div>
    
                        <!-- Check Out -->
                        <div class="text-left">
                            <label class="block text-gray-400 text-[10px] font-bold mb-2 uppercase tracking-widest">Check Out</label>
                            <div class="relative">
                                <input type="text" onfocus="(this.type='date')" onblur="(this.type='text')"
                                       name="check_out" 
                                       placeholder="Select Date"
                                       class="w-full px-4 py-3 bg-gray-50 border border-gray-200 rounded-lg text-gray-700 placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-[#558B2F] focus:border-transparent transition-all duration-300"
                                       required>
                            </div>
                        </div>
    
                        <!-- Rooms -->
                        <div class="text-left">
                            <label class="block text-gray-400 text-[10px] font-bold mb-2 uppercase tracking-widest">Rooms</label>
                            <div class="relative">
                                <select name="rooms" class="w-full px-4 py-3 bg-gray-50 border border-gray-200 rounded-lg text-gray-700 focus:outline-none focus:ring-2 focus:ring-[#558B2F] focus:border-transparent transition-all duration-300 appearance-none cursor-pointer">
                                    <option value="" class="text-gray-500">Select Room</option>
                                    <option value="1">1 Room</option>
                                    <option value="2">2 Rooms</option>
                                    <option value="3">3 Rooms</option>
                                    <option value="4">4+ Rooms</option>
                                </select>
                                <div class="absolute inset-y-0 right-0 flex items-center px-4 pointer-events-none text-gray-400">
                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path></svg>
                                </div>
                            </div>
                        </div>
    
                        <!-- Adults -->
                        <div class="text-left">
                            <label class="block text-gray-400 text-[10px] font-bold mb-2 uppercase tracking-widest">Adults</label>
                            <div class="relative">
                                <select name="adults" class="w-full px-4 py-3 bg-gray-50 border border-gray-200 rounded-lg text-gray-700 focus:outline-none focus:ring-2 focus:ring-[#558B2F] focus:border-transparent transition-all duration-300 appearance-none cursor-pointer">
                                    <option value="" class="text-gray-500">Select Adults</option>
                                    <option value="1">1 Adult</option>
                                    <option value="2">2 Adults</option>
                                    <option value="3">3 Adults</option>
                                    <option value="4">4+ Adults</option>
                                </select>
                                <div class="absolute inset-y-0 right-0 flex items-center px-4 pointer-events-none text-gray-400">
                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path></svg>
                                </div>
                            </div>
                        </div>

                        <!-- Children -->
                        <div class="text-left">
                            <label class="block text-gray-400 text-[10px] font-bold mb-2 uppercase tracking-widest">Children</label>
                            <div class="relative">
                                <select name="children" class="w-full px-4 py-3 bg-gray-50 border border-gray-200 rounded-lg text-gray-700 focus:outline-none focus:ring-2 focus:ring-[#558B2F] focus:border-transparent transition-all duration-300 appearance-none cursor-pointer">
                                    <option value="" class="text-gray-500">Select Children</option>
                                    <option value="0">None</option>
                                    <option value="1">1 Child</option>
                                    <option value="2">2 Children</option>
                                    <option value="3">3 Children</option>
                                </select>
                                <div class="absolute inset-y-0 right-0 flex items-center px-4 pointer-events-none text-gray-400">
                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path></svg>
                                </div>
                            </div>
                        </div>
    
                        <!-- Submit Button -->
                        <div>
                            <button type="submit" class="w-full px-6 py-3.5 bg-[#558B2F] hover:bg-[#457025] text-white rounded-lg font-black uppercase tracking-widest text-xs transition-all duration-300 shadow-lg hover:shadow-xl active:scale-95 flex items-center justify-center gap-2">
                                CHECK RATES
                            </button>
                        </div>
                    </div>
                </form>
             </div>
        </div>
    </div>

    <!-- Features Section -->
    <div class="bg-[#FBFBFB] pt-12 pb-16">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
                <!-- Quick Booking -->
                <a href="{{ route('rooms.index') }}" class="bg-white p-10 rounded-[2rem] border border-gray-100 shadow-sm hover:shadow-md transition-all duration-300 text-center group">
                    <div class="w-24 h-24 bg-[#E8F1DE] rounded-full flex items-center justify-center mx-auto mb-8 group-hover:bg-[#D9E8C7] transition-colors">
                        <svg class="w-12 h-12 text-[#7A9D54]" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M12 6.253v13m0-13C10.832 5.477 9.246 5 7.5 5S4.168 5.477 3 6.253v13C4.168 18.477 5.754 18 7.5 18s3.332.477 4.5 1.253m0-13C13.168 5.477 14.754 5 16.5 5c1.747 0 3.332.477 4.5 1.253v13C19.832 18.477 18.247 18 16.5 18c-1.746 0-3.332.477-4.5 1.253"></path>
                        </svg>
                    </div>
                    <h3 class="font-serif text-[1.75rem] text-[#7A9D54] mb-4">Quick Booking</h3>
                    <p class="text-[#888] text-base leading-relaxed">
                        Lorem ipsum dolor sit amet, consectetur adipiscing elit.
                    </p>
                </a>

                <!-- Best Guide -->
                <div class="bg-white p-10 rounded-[2rem] border border-gray-100 shadow-sm hover:shadow-md transition-all duration-300 text-center group">
                    <div class="w-24 h-24 bg-[#E8F1DE] rounded-full flex items-center justify-center mx-auto mb-8 group-hover:bg-[#D9E8C7] transition-colors">
                        <svg class="w-12 h-12 text-[#7A9D54]" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"></path>
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"></path>
                        </svg>
                    </div>
                    <h3 class="font-serif text-[1.75rem] text-[#7A9D54] mb-4">Best Guide</h3>
                    <p class="text-[#888] text-base leading-relaxed">
                        Lorem ipsum dolor sit amet, consectetur adipiscing elit.
                    </p>
                </div>

                <!-- Customization -->
                <div class="bg-white p-10 rounded-[2rem] border border-gray-100 shadow-sm hover:shadow-md transition-all duration-300 text-center group">
                    <div class="w-24 h-24 bg-[#E8F1DE] rounded-full flex items-center justify-center mx-auto mb-8 group-hover:bg-[#D9E8C7] transition-colors">
                        <svg class="w-12 h-12 text-[#7A9D54]" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z"></path>
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                        </svg>
                    </div>
                    <h3 class="font-serif text-[1.75rem] text-[#7A9D54] mb-4">Customization</h3>
                    <p class="text-[#888] text-base leading-relaxed">
                        Lorem ipsum dolor sit amet, consectetur adipiscing elit.
                    </p>
                </div>

                <!-- 24/7 Support -->
                <a href="{{ route('contact') }}" class="bg-white p-10 rounded-[2rem] border border-gray-100 shadow-sm hover:shadow-md transition-all duration-300 text-center group">
                    <div class="w-24 h-24 bg-[#E8F1DE] rounded-full flex items-center justify-center mx-auto mb-8 group-hover:bg-[#D9E8C7] transition-colors">
                        <svg class="w-12 h-12 text-[#7A9D54]" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M18.364 5.636l-3.536 3.536m0 5.656l3.536 3.536M9.172 9.172L5.636 5.636m3.536 9.192l-3.536 3.536M21 12a9 9 0 11-18 0 9 9 0 0118 0zm-5 0a4 4 0 11-8 0 4 4 0 018 0z"></path>
                        </svg>
                    </div>
                    <h3 class="font-serif text-[1.75rem] text-[#7A9D54] mb-4">24/7 Support</h3>
                    <p class="text-[#888] text-base leading-relaxed">
                        Lorem ipsum dolor sit amet, consectetur adipiscing elit.
                    </p>
                </a>
            </div>
        </div>
    </div>


    <!-- Room Grid Section -->
    <div class="bg-[#FBFBFB] py-24">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-16">
                 <h2 class="font-serif text-5xl text-theme-green mb-4">Room Grid</h2>
                 <div class="h-1 w-24 bg-theme-gold mx-auto"></div>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
                @forelse($rooms as $room)
                <div class="bg-gray-50 rounded-2xl overflow-hidden shadow-xl hover:shadow-2xl transition duration-300 group">
                    <div class="relative h-64 overflow-hidden">
                        @if($room->image)
                            <img src="{{ asset($room->image) }}" alt="{{ $room->room_number }}" class="w-full h-full object-cover transform group-hover:scale-110 transition duration-500">
                        @else
                            <div class="w-full h-full bg-gray-200 flex items-center justify-center text-gray-400">
                                <svg class="w-12 h-12" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"></path></svg>
                            </div>
                        @endif
                        <div class="absolute top-4 right-4 bg-theme-green/90 text-white px-4 py-1 rounded-full text-sm font-semibold">
                            ${{ $room->price }}/Night
                        </div>
                    </div>
                    <div class="p-8">
                        <div class="flex items-center justify-between mb-4">
                            <span class="text-theme-gold flex text-sm">
                                <svg class="w-4 h-4 fill-current" viewBox="0 0 20 20"><path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"/></svg>
                                <span class="ml-1 text-gray-600 font-sans">4.8</span>
                            </span>
                             <span class="text-xs text-gray-500 font-sans uppercase tracking-wider">{{ $room->type }}</span>
                        </div>
                        <h3 class="font-serif text-2xl text-gray-900 mb-2 truncate">{{ $room->room_number }}</h3> <!-- Ideally Room Title would be here -->
                        <p class="text-gray-600 line-clamp-2 mb-6 text-sm">
                            Experience luxury in our meticulously designed rooms featuring modern amenities and breathtaking views.
                        </p>
                        
                        <div class="border-t border-gray-100 pt-6">
                            <a href="{{ route('rooms.show', $room) }}" class="inline-block w-full text-center bg-gray-100 hover:bg-theme-gold hover:text-theme-green text-gray-800 font-bold py-3 px-4 rounded-lg transition duration-200 uppercase text-xs tracking-wider">
                                View Details
                            </a>
                        </div>
                    </div>
                </div>
                @empty
                    <div class="col-span-3 text-center py-12">
                        <p class="text-gray-500">No rooms available at the moment.</p>
                    </div>
                @endforelse
            </div>
        </div>
    </div>

    <!-- Footer -->
    <footer class="bg-[#1a1a1a] text-white py-12 border-t border-gray-800">
         <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 flex flex-col md:flex-row justify-between items-center">
             <div class="mb-4 md:mb-0">
                 <span class="font-serif text-2xl font-bold tracking-widest text-[#D4AF37]">LUCXORIO</span>
             </div>
             <div class="text-gray-400 text-sm">
                 &copy; {{ date('Y') }} Lucxorio Hotel. All rights reserved.
             </div>
         </div>
    </footer>

</body>
</html>
