@extends('layouts.app')

@section('content')
<!-- Hero Section - Matching Home Page Theme -->
<section class="relative min-h-[60vh] flex items-center justify-center overflow-hidden">
    <!-- Background with Home Page Green Theme -->
    <div class="absolute inset-0 bg-gradient-to-br from-[#3d6320] via-[#558B2F] to-[#4a7a28]">
        <div class="absolute inset-0 opacity-20">
            <div class="absolute top-0 -left-4 w-96 h-96 bg-[#558B2F] rounded-full mix-blend-multiply filter blur-3xl animate-blob"></div>
            <div class="absolute top-0 -right-4 w-96 h-96 bg-[#8bc34a] rounded-full mix-blend-multiply filter blur-3xl animate-blob animation-delay-2000"></div>
            <div class="absolute -bottom-8 left-20 w-96 h-96 bg-[#558B2F] rounded-full mix-blend-multiply filter blur-3xl animate-blob animation-delay-4000"></div>
        </div>
        <!-- Pattern Overlay -->
        <div class="absolute inset-0 opacity-10" style="background-image: radial-gradient(circle at 2px 2px, rgba(255,255,255,0.15) 1px, transparent 0); background-size: 40px 40px;"></div>
    </div>

    <!-- Floating Particles -->
    <div class="absolute inset-0 overflow-hidden pointer-events-none z-0">
        <div class="particle-float absolute w-2 h-2 bg-white/30 rounded-full" style="top: 20%; left: 15%; animation-delay: 0s;"></div>
        <div class="particle-float absolute w-3 h-3 bg-[#8bc34a]/30 rounded-full" style="top: 60%; left: 75%; animation-delay: 2s;"></div>
    </div>
    
    <div class="relative z-10 container mx-auto px-6 text-center">
        <div class="inline-flex items-center gap-2 px-4 py-2 bg-white/10 backdrop-blur-md rounded-full border border-white/20 mb-8 animate-fade-in-down">
            <span class="text-white/90 text-sm font-medium tracking-wider uppercase">Our Accommodations</span>
        </div>
        
        <h1 class="text-6xl md:text-7xl font-bold text-white mb-8 animate-fade-in-up font-display">
            Our Luxury
            <span class="text-white">Villas</span>
        </h1>
        
        <p class="text-xl text-white/80 max-w-2xl mx-auto animate-fade-in-up animation-delay-200 leading-relaxed">
            Discover a sustainable sanctuary where luxury meets nature. Each villa is a masterpiece of eco-friendly comfort.
        </p>
    </div>
</section>

<!-- Rooms Collection Section -->
<section class="relative -mt-20 z-20 pb-24">
    <div class="container mx-auto px-6">
        @if($rooms->count() > 0)
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-10">
                @foreach($rooms as $room)
                    <div class="group relative bg-white rounded-2xl overflow-hidden shadow-xl hover:shadow-2xl transition-all duration-500 hover:-translate-y-3 border border-gray-100">
                        <!-- Villa Image & Badges -->
                        <div class="relative h-80 overflow-hidden">
                            @if($room->image)
                                <img src="{{ asset('storage/' . $room->image) }}" 
                                     alt="{{ $room->name }}" 
                                     class="w-full h-full object-cover group-hover:scale-110 transition-transform duration-700">
                            @else
                                <div class="w-full h-full bg-gradient-to-br from-[#558B2F] to-[#3d6320] flex items-center justify-center">
                                    <svg class="w-20 h-20 text-white/20" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6"></path>
                                    </svg>
                                </div>
                            @endif

                            <div class="absolute inset-0 bg-gradient-to-t from-black/60 via-transparent to-transparent"></div>
                            
                            <!-- Price Tag -->
                            <div class="absolute top-6 right-6 bg-white/95 backdrop-blur-sm px-5 py-2.5 rounded-xl shadow-xl flex flex-col items-center">
                                <span class="text-[#558B2F] font-bold text-lg">LKR {{ number_format($room->price, 0) }}</span>
                                <span class="text-[10px] text-gray-500 font-black uppercase tracking-widest">Per Night</span>
                            </div>

                            <!-- Villa Type Badge -->
                            <div class="absolute bottom-6 left-6 px-4 py-1.5 bg-[#558B2F]/90 backdrop-blur-md rounded-full text-white text-xs font-bold uppercase tracking-widest border border-white/20">
                                {{ $room->type }}
                            </div>
                        </div>

                        <!-- Villa Content -->
                        <div class="p-8">
                            <div class="flex justify-between items-start mb-4">
                                <h3 class="text-2xl font-bold text-gray-900 group-hover:text-[#558B2F] transition-colors">
                                    {{ $room->name }}
                                </h3>
                                <div class="flex items-center gap-1 text-amber-500">
                                    <svg class="w-4 h-4 fill-current" viewBox="0 0 20 20"><path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"/></svg>
                                    <span class="text-sm font-bold">5.0</span>
                                </div>
                            </div>
                            
                            <p class="text-gray-600 mb-6 line-clamp-2 leading-relaxed text-sm">
                                {{ $room->description ?? 'Experience luxury and comfort in this beautifully appointed eco-villa, designed for harmony with nature.' }}
                            </p>

                            <!-- Mini Features -->
                            <div class="flex items-center gap-4 mb-8 text-gray-500 text-xs font-semibold uppercase tracking-wider">
                                <span class="flex items-center gap-2 bg-gray-50 px-3 py-2 rounded-lg">
                                    <svg class="w-4 h-4 text-[#558B2F]" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"/></svg>
                                    {{ $room->capacity }} Guests
                                </span>
                                <span class="flex items-center gap-2 bg-gray-50 px-3 py-2 rounded-lg">
                                    <svg class="w-4 h-4 text-[#558B2F]" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6"/></svg>
                                    Villa
                                </span>
                            </div>

                            <!-- CTA Button -->
                            <a href="{{ route('rooms.show', $room) }}" 
                               class="group/btn relative w-full py-4 bg-[#558B2F] hover:bg-[#457025] text-white rounded-md font-bold text-center transition-all duration-300 shadow-lg flex items-center justify-center gap-2 uppercase tracking-widest text-sm">
                                <span>Explore Villa</span>
                                <svg class="w-5 h-5 group-hover/btn:translate-x-1 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M14 5l7 7m0 0l-7 7m7-7H3"/></svg>
                            </a>
                        </div>
                    </div>
                @endforeach
            </div>
        @else
            <!-- Empty State -->
            <div class="max-w-xl mx-auto text-center py-20 bg-white rounded-2xl shadow-xl p-12 animate-fade-in-up">
                <div class="w-32 h-32 bg-[#558B2F]/10 rounded-full flex items-center justify-center mx-auto mb-8">
                    <svg class="w-16 h-16 text-[#558B2F]" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6"/></svg>
                </div>
                <h3 class="text-3xl font-bold text-gray-900 mb-4 font-display">Peaceful Rest in Progress</h3>
                <p class="text-gray-600 mb-10 leading-relaxed">We're currently preparing more eco-spaces for our guests. Please check back soon or reach out to us directly for early bird reservations.</p>
                <a href="{{ route('contact') }}" class="inline-flex items-center gap-2 px-10 py-4 bg-[#558B2F] hover:bg-[#457025] text-white font-bold rounded-md shadow-lg transition-all hover:scale-105 active:scale-95 uppercase tracking-widest text-sm">
                    Contact Our Concierge
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 12h.01M12 12h.01M16 12h.01M21 12c0 4.418-4.03 8-9 8a9.863 9.863 0 01-4.255-.949L3 20l1.395-3.72C3.512 15.042 3 13.574 3 12c0-4.418 4.03-8 9-8s9 3.582 9 8z"/></svg>
                </a>
            </div>
        @endif
    </div>
</section>

<!-- Features Spotlight Section -->
<section class="py-24 bg-gradient-to-br from-gray-50 to-white relative overflow-hidden">
    <div class="absolute top-0 right-0 w-96 h-96 bg-[#558B2F]/10 rounded-full blur-3xl"></div>
    
    <div class="container mx-auto px-6 relative z-10">
        <div class="text-center mb-16">
            <span class="inline-block px-5 py-2 bg-[#558B2F]/10 text-[#558B2F] rounded-full text-xs font-bold uppercase tracking-[0.2em] mb-4">Signature Value</span>
            <h2 class="text-4xl md:text-5xl font-bold text-gray-900 mb-6 font-display">
                Why Experience Our <span class="text-gray-900">Eco Village?</span>
            </h2>
            <div class="w-32 h-1.5 bg-[#558B2F] mx-auto rounded-full"></div>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-3 gap-12 max-w-6xl mx-auto">
            <!-- Feature 1 -->
            <div class="group relative p-10 bg-white rounded-2xl shadow-xl hover:shadow-2xl transition-all duration-500 hover:-translate-y-2 border border-gray-100">
                <div class="w-20 h-20 bg-[#558B2F]/10 text-[#558B2F] rounded-2xl flex items-center justify-center mb-8 group-hover:scale-110 group-hover:rotate-6 transition-all duration-500">
                    <svg class="w-10 h-10" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 3v4M3 5h4M6 17v4m-2-2h4m5-16l2.286 6.857L21 12l-5.714 2.143L13 21l-2.286-6.857L5 12l5.714-2.143L13 3z"/></svg>
                </div>
                <h3 class="text-2xl font-bold text-gray-900 mb-4 group-hover:text-[#558B2F] transition-colors">Luxury Sustainability</h3>
                <p class="text-gray-600 leading-relaxed">Premium comfort harmonized with eco-conscious practices, ensuring a guilt-free luxury experience.</p>
            </div>

            <!-- Feature 2 -->
            <div class="group relative p-10 bg-white rounded-2xl shadow-xl hover:shadow-2xl transition-all duration-500 hover:-translate-y-2 border border-gray-100">
                <div class="w-20 h-20 bg-amber-100 text-amber-600 rounded-2xl flex items-center justify-center mb-8 group-hover:scale-110 group-hover:-rotate-6 transition-all duration-500">
                    <svg class="w-10 h-10" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/></svg>
                </div>
                <h3 class="text-2xl font-bold text-gray-900 mb-4 group-hover:text-amber-600 transition-colors">Mindful Concierge</h3>
                <p class="text-gray-600 leading-relaxed">Personalized 24/7 service dedicated to curating your perfect mindful escape across our entire estate.</p>
            </div>

            <!-- Feature 3 -->
            <div class="group relative p-10 bg-white rounded-2xl shadow-xl hover:shadow-2xl transition-all duration-500 hover:-translate-y-2 border border-gray-100">
                <div class="w-20 h-20 bg-[#558B2F]/10 text-[#558B2F] rounded-2xl flex items-center justify-center mb-8 group-hover:scale-110 group-hover:rotate-6 transition-all duration-500">
                    <svg class="w-10 h-10" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"/><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"/></svg>
                </div>
                <h3 class="text-2xl font-bold text-gray-900 mb-4 group-hover:text-[#558B2F] transition-colors">Nature's Gateway</h3>
                <p class="text-gray-600 leading-relaxed">Perfectly positioned as the ultimate portal to Sri Lanka's pristine wilderness and cultural heritage.</p>
            </div>
        </div>
    </div>
</section>

<style>
@keyframes blob {
    0% { transform: translate(0px, 0px) scale(1); }
    33% { transform: translate(30px, -50px) scale(1.1); }
    66% { transform: translate(-20px, 20px) scale(0.9); }
    100% { transform: translate(0px, 0px) scale(1); }
}

.animate-blob {
    animation: blob 7s infinite;
}

.animation-delay-2000 {
    animation-delay: 2s;
}

.animation-delay-4000 {
    animation-delay: 4s;
}

@keyframes fade-in-down {
    from { opacity: 0; transform: translateY(-30px); }
    to { opacity: 1; transform: translateY(0); }
}

@keyframes fade-in-up {
    from { opacity: 0; transform: translateY(30px); }
    to { opacity: 1; transform: translateY(0); }
}

@keyframes particle-float {
    0%, 100% { transform: translateY(0) translateX(0); opacity: 0.3; }
    50% { transform: translateY(-100px) translateX(50px); opacity: 0.6; }
}

.animate-fade-in-down {
    animation: fade-in-down 0.8s ease-out forwards;
}

.animate-fade-in-up {
    animation: fade-in-up 0.8s ease-out 0.2s forwards;
    opacity: 0;
}

.particle-float {
    animation: particle-float 8s ease-in-out infinite;
}

.animation-delay-200 {
    animation-delay: 0.2s;
    animation-fill-mode: both;
}
</style>
@endsection
