<section>
    <form id="send-verification" method="post" action="{{ route('verification.send') }}">
        @csrf
    </form>

    <form method="post" action="{{ route('profile.update') }}" class="space-y-6" enctype="multipart/form-data">
        @csrf
        @method('patch')

        <!-- Avatar -->
        <div>
            <x-input-label for="avatar" :value="__('Profile Picture')" class="text-xs uppercase tracking-wider text-gray-500 font-bold mb-2 ml-1" />
            <div class="mt-2 flex items-center gap-6">
                <div class="relative">
                    @if($user->avatar)
                        <img src="{{ asset('storage/' . $user->avatar) }}" alt="Avatar" class="w-24 h-24 rounded-2xl object-cover shadow-lg border-2 border-white ring-2 ring-gray-100">
                    @else
                        <div class="w-24 h-24 rounded-2xl bg-gradient-to-br from-gray-100 to-gray-200 flex items-center justify-center text-gray-400 shadow-inner border-2 border-white ring-2 ring-gray-100">
                            <svg class="w-10 h-10" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M10 9a3 3 0 100-6 3 3 0 000 6zm-7 9a7 7 0 1114 0H3z" clip-rule="evenodd" /></svg>
                        </div>
                    @endif
                    <div class="absolute -bottom-2 -right-2 w-8 h-8 bg-[#558B2F] rounded-full flex items-center justify-center text-white border-2 border-white shadow-md">
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 9a2 2 0 012-2h.93a2 2 0 001.664-.89l.812-1.22A2 2 0 0110.07 4h3.86a2 2 0 011.664.89l.812 1.22A2 2 0 0018.07 7H19a2 2 0 012 2v9a2 2 0 01-2 2H5a2 2 0 01-2-2V9z"/><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 13a3 3 0 11-6 0 3 3 0 016 0z"/></svg>
                    </div>
                </div>
                
                <div class="flex-1">
                    <input type="file" name="avatar" id="avatar" class="block w-full text-sm text-gray-500 file:mr-4 file:py-2.5 file:px-6 file:rounded-xl file:border-0 file:text-sm file:font-bold file:uppercase file:tracking-wider file:bg-[#558B2F]/10 file:text-[#558B2F] hover:file:bg-[#558B2F] hover:file:text-white transition-all cursor-pointer">
                    <p class="mt-2 text-xs text-gray-400">JPG, GIF or PNG. Max size of 2MB</p>
                </div>
            </div>
            <x-input-error class="mt-2" :messages="$errors->get('avatar')" />
        </div>

        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <div>
                <x-input-label for="name" :value="__('Full Name')" class="text-xs uppercase tracking-wider text-gray-500 font-bold mb-2 ml-1" />
                <x-text-input id="name" name="name" type="text" class="mt-1 block w-full bg-gray-50 border-gray-100 focus:border-[#558B2F] focus:ring-[#558B2F] rounded-xl py-3" :value="old('name', $user->name)" required autofocus autocomplete="name" />
                <x-input-error class="mt-2" :messages="$errors->get('name')" />
            </div>

            <div>
                <x-input-label for="email" :value="__('Email Address')" class="text-xs uppercase tracking-wider text-gray-500 font-bold mb-2 ml-1" />
                <x-text-input id="email" name="email" type="email" class="mt-1 block w-full bg-gray-50 border-gray-100 focus:border-[#558B2F] focus:ring-[#558B2F] rounded-xl py-3" :value="old('email', $user->email)" required autocomplete="username" />
                <x-input-error class="mt-2" :messages="$errors->get('email')" />

                @if ($user instanceof \Illuminate\Contracts\Auth\MustVerifyEmail && ! $user->hasVerifiedEmail())
                    <div class="mt-2">
                        <p class="text-sm text-amber-600 bg-amber-50 px-3 py-2 rounded-lg inline-flex items-center gap-2">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z"/></svg>
                            {{ __('Your email address is unverified.') }}
                            <button form="send-verification" class="underline text-amber-700 hover:text-amber-900 font-bold">
                                {{ __('Re-send email') }}
                            </button>
                        </p>

                        @if (session('status') === 'verification-link-sent')
                            <p class="mt-2 font-medium text-sm text-[#558B2F]">
                                {{ __('A new verification link has been sent to your email address.') }}
                            </p>
                        @endif
                    </div>
                @endif
            </div>

            <div>
                <x-input-label for="phone" :value="__('Phone Number')" class="text-xs uppercase tracking-wider text-gray-500 font-bold mb-2 ml-1" />
                <x-text-input id="phone" name="phone" type="tel" class="mt-1 block w-full bg-gray-50 border-gray-100 focus:border-[#558B2F] focus:ring-[#558B2F] rounded-xl py-3" :value="old('phone', $user->phone)" />
                <x-input-error class="mt-2" :messages="$errors->get('phone')" />
            </div>

            <div>
                <x-input-label for="country" :value="__('Country')" class="text-xs uppercase tracking-wider text-gray-500 font-bold mb-2 ml-1" />
                <x-text-input id="country" name="country" type="text" class="mt-1 block w-full bg-gray-50 border-gray-100 focus:border-[#558B2F] focus:ring-[#558B2F] rounded-xl py-3" :value="old('country', $user->country)" />
                <x-input-error class="mt-2" :messages="$errors->get('country')" />
            </div>

            <div class="md:col-span-2">
                <x-input-label for="address" :value="__('Address')" class="text-xs uppercase tracking-wider text-gray-500 font-bold mb-2 ml-1" />
                <x-text-input id="address" name="address" type="text" class="mt-1 block w-full bg-gray-50 border-gray-100 focus:border-[#558B2F] focus:ring-[#558B2F] rounded-xl py-3" :value="old('address', $user->address)" />
                <x-input-error class="mt-2" :messages="$errors->get('address')" />
            </div>
        </div>

        <div class="flex items-center gap-4 pt-4 border-t border-gray-50">
            <x-primary-button class="bg-[#558B2F] hover:bg-[#457025] !rounded-xl !py-3 !px-6 shadow-lg shadow-green-900/10">{{ __('Save Changes') }}</x-primary-button>

            @if (session('status') === 'profile-updated')
                <p
                    x-data="{ show: true }"
                    x-show="show"
                    x-transition
                    x-init="setTimeout(() => show = false, 2000)"
                    class="text-sm text-[#558B2F] font-bold flex items-center gap-1"
                >
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/></svg>
                    {{ __('Saved Successfully.') }}
                </p>
            @endif
        </div>
    </form>
</section>
