<section>
    <form method="post" action="{{ route('password.update') }}" class="space-y-6">
        @csrf
        @method('put')

        <div class="grid grid-cols-1 gap-6">
            <div>
                <x-input-label for="update_password_current_password" :value="__('Current Password')" class="text-xs uppercase tracking-wider text-gray-500 font-bold mb-2 ml-1" />
                <x-text-input id="update_password_current_password" name="current_password" type="password" class="mt-1 block w-full bg-gray-50 border-gray-100 focus:border-amber-500 focus:ring-amber-500 rounded-xl py-3" autocomplete="current-password" />
                <x-input-error :messages="$errors->updatePassword->get('current_password')" class="mt-2" />
            </div>

            <div>
                <x-input-label for="update_password_password" :value="__('New Password')" class="text-xs uppercase tracking-wider text-gray-500 font-bold mb-2 ml-1" />
                <x-text-input id="update_password_password" name="password" type="password" class="mt-1 block w-full bg-gray-50 border-gray-100 focus:border-amber-500 focus:ring-amber-500 rounded-xl py-3" autocomplete="new-password" />
                <x-input-error :messages="$errors->updatePassword->get('password')" class="mt-2" />
            </div>

            <div>
                <x-input-label for="update_password_password_confirmation" :value="__('Confirm Password')" class="text-xs uppercase tracking-wider text-gray-500 font-bold mb-2 ml-1" />
                <x-text-input id="update_password_password_confirmation" name="password_confirmation" type="password" class="mt-1 block w-full bg-gray-50 border-gray-100 focus:border-amber-500 focus:ring-amber-500 rounded-xl py-3" autocomplete="new-password" />
                <x-input-error :messages="$errors->updatePassword->get('password_confirmation')" class="mt-2" />
            </div>
        </div>

        <div class="flex items-center gap-4 pt-4 border-t border-gray-50">
            <x-primary-button class="bg-amber-500 hover:bg-amber-600 !rounded-xl !py-3 !px-6 shadow-lg shadow-amber-900/10 focus:ring-amber-500">{{ __('Update Password') }}</x-primary-button>

            @if (session('status') === 'password-updated')
                <p
                    x-data="{ show: true }"
                    x-show="show"
                    x-transition
                    x-init="setTimeout(() => show = false, 2000)"
                    class="text-sm text-amber-600 font-bold flex items-center gap-1"
                >
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/></svg>
                    {{ __('Password Updated.') }}
                </p>
            @endif
        </div>
    </form>
</section>
