<section class="space-y-6">
    <div class="bg-red-50/50 rounded-xl p-6 border border-red-100">
        <p class="text-sm text-red-600 mb-6 font-medium">
            {{ __('Once your account is deleted, all of its resources and data will be permanently deleted. Before deleting your account, please download any data or information that you wish to retain.') }}
        </p>

        <x-danger-button
            x-data=""
            x-on:click.prevent="$dispatch('open-modal', 'confirm-user-deletion')"
            class="!rounded-xl !py-3 !px-6 shadow-lg shadow-red-900/10 hover:shadow-red-900/20 transition-all transform hover:scale-105"
        >{{ __('Delete Account') }}</x-danger-button>
    </div>

    <x-modal name="confirm-user-deletion" :show="$errors->userDeletion->isNotEmpty()" focusable>
        <form method="post" action="{{ route('profile.destroy') }}" class="p-8">
            @csrf
            @method('delete')

            <div class="text-center mb-6">
                <div class="mx-auto flex items-center justify-center h-16 w-16 rounded-full bg-red-100 mb-4">
                    <svg class="h-8 w-8 text-red-600" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z" />
                    </svg>
                </div>
                <h2 class="text-xl font-bold text-gray-900">
                    {{ __('Are you sure you want to delete your account?') }}
                </h2>
                <p class="mt-2 text-sm text-gray-500">
                    {{ __('Once your account is deleted, all of its resources and data will be permanently deleted. Please enter your password to confirm you would like to permanently delete your account.') }}
                </p>
            </div>

            <div class="mt-6">
                <x-input-label for="password" value="{{ __('Password') }}" class="sr-only" />

                <x-text-input
                    id="password"
                    name="password"
                    type="password"
                    class="mt-1 block w-full bg-gray-50 border-gray-100 focus:border-red-500 focus:ring-red-500 rounded-xl py-3 text-center"
                    placeholder="{{ __('Enter Password to Confirm') }}"
                />

                <x-input-error :messages="$errors->userDeletion->get('password')" class="mt-2 text-center" />
            </div>

            <div class="mt-8 flex justify-center gap-4">
                <x-secondary-button x-on:click="$dispatch('close')" class="!rounded-xl !py-3 !px-6">
                    {{ __('Cancel') }}
                </x-secondary-button>

                <x-danger-button class="ms-3 !rounded-xl !py-3 !px-6 shadow-lg shadow-red-900/20">
                    {{ __('Delete Account') }}
                </x-danger-button>
            </div>
        </form>
    </x-modal>
</section>
