<x-app-layout>
    <!-- Hero Section -->
    <div class="relative bg-gradient-to-br from-[#3d6320] via-[#558B2F] to-[#4a7a28] py-16 mb-12 overflow-hidden">
        <!-- Abstract Background Shapes -->
        <div class="absolute inset-0 opacity-10">
            <div class="absolute -top-24 -left-20 w-96 h-96 bg-white rounded-full mix-blend-overlay filter blur-3xl animate-blob"></div>
            <div class="absolute -bottom-24 -right-20 w-96 h-96 bg-[#c6d95f] rounded-full mix-blend-overlay filter blur-3xl animate-blob animation-delay-2000"></div>
        </div>
        
        <div class="container mx-auto px-6 relative z-10 text-center">
            <div class="inline-flex items-center gap-2 px-4 py-2 bg-white/10 backdrop-blur-md rounded-full border border-white/20 mb-6 animate-fade-in-down">
                <span class="text-white/90 text-sm font-medium uppercase tracking-widest">Account Settings</span>
            </div>
            <h1 class="text-4xl md:text-5xl font-display font-bold text-white mb-4 animate-fade-in-up">
                My Profile
            </h1>
            <p class="text-green-100 text-lg max-w-2xl mx-auto animate-fade-in-up animation-delay-200">
                Manage your personal information, security preferences, and account details in one place.
            </p>
        </div>
    </div>

    <!-- Main Content -->
    <div class="container mx-auto px-6 pb-24">
        <div class="max-w-4xl mx-auto space-y-8 animate-fade-in-up animation-delay-400">
            
            <!-- Profile Information Card -->
            <div class="bg-white rounded-2xl p-8 md:p-10 shadow-xl border border-gray-100 relative overflow-hidden group hover:border-[#558B2F]/30 transition-all duration-300">
                <div class="absolute top-0 right-0 w-32 h-32 bg-[#558B2F]/5 rounded-bl-[4rem] -mr-4 -mt-4 transition-all duration-500 group-hover:bg-[#558B2F]/10"></div>
                <div class="relative z-10">
                    <div class="flex items-center gap-4 mb-8">
                        <div class="w-12 h-12 rounded-xl bg-[#558B2F]/10 flex items-center justify-center text-[#558B2F]">
                            <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"/></svg>
                        </div>
                        <div>
                            <h3 class="text-xl font-bold text-gray-900">Personal Information</h3>
                            <p class="text-sm text-gray-500">Update your verify profile details</p>
                        </div>
                    </div>
                    @include('profile.partials.update-profile-information-form')
                </div>
            </div>

            <!-- Update Password Card -->
            <div class="bg-white rounded-2xl p-8 md:p-10 shadow-xl border border-gray-100 relative overflow-hidden group hover:border-[#558B2F]/30 transition-all duration-300">
                <div class="absolute top-0 right-0 w-32 h-32 bg-amber-50 rounded-bl-[4rem] -mr-4 -mt-4 transition-all duration-500 group-hover:bg-amber-100"></div>
                <div class="relative z-10">
                    <div class="flex items-center gap-4 mb-8">
                        <div class="w-12 h-12 rounded-xl bg-amber-100 flex items-center justify-center text-amber-600">
                            <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"/></svg>
                        </div>
                        <div>
                            <h3 class="text-xl font-bold text-gray-900">Security</h3>
                            <p class="text-sm text-gray-500">Ensure your account uses a strong password</p>
                        </div>
                    </div>
                    @include('profile.partials.update-password-form')
                </div>
            </div>

            <!-- Delete Account Card -->
            <div class="bg-white rounded-2xl p-8 md:p-10 shadow-xl border border-red-100 relative overflow-hidden group hover:border-red-200 transition-all duration-300">
                <div class="absolute top-0 right-0 w-32 h-32 bg-red-50 rounded-bl-[4rem] -mr-4 -mt-4 transition-all duration-500 group-hover:bg-red-100"></div>
                <div class="relative z-10">
                    <div class="flex items-center gap-4 mb-8">
                        <div class="w-12 h-12 rounded-xl bg-red-100 flex items-center justify-center text-red-600">
                            <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"/></svg>
                        </div>
                        <div>
                            <h3 class="text-xl font-bold text-gray-900">Danger Zone</h3>
                            <p class="text-sm text-gray-500">Permanently delete your account</p>
                        </div>
                    </div>
                    @include('profile.partials.delete-user-form')
                </div>
            </div>

        </div>
    </div>

    <!-- Styles for animations -->
    <style>
        @keyframes blob {
            0% { transform: translate(0px, 0px) scale(1); }
            33% { transform: translate(30px, -50px) scale(1.1); }
            66% { transform: translate(-20px, 20px) scale(0.9); }
            100% { transform: translate(0px, 0px) scale(1); }
        }
        .animate-blob { animation: blob 7s infinite; }
        .animation-delay-2000 { animation-delay: 2s; }
        .animate-fade-in-down { animation: fade-in-down 0.8s ease-out forwards; }
        .animate-fade-in-up { animation: fade-in-up 0.8s ease-out forwards; opacity: 0; }
        .animation-delay-200 { animation-delay: 0.2s; animation-fill-mode: both; }
        .animation-delay-400 { animation-delay: 0.4s; animation-fill-mode: both; }
        @keyframes fade-in-down { from { opacity: 0; transform: translateY(-20px); } to { opacity: 1; transform: translateY(0); } }
        @keyframes fade-in-up { from { opacity: 0; transform: translateY(20px); } to { opacity: 1; transform: translateY(0); } }
    </style>
</x-app-layout>
