<!-- Top Bar -->
<div class="bg-[#558B2F] text-white py-2.5">
    <div class="container mx-auto px-4">
        <div class="flex flex-col md:flex-row justify-between items-center gap-2">
            <div class="flex items-center gap-6 text-sm font-medium tracking-wide">
                <div class="flex items-center gap-2">
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"/>
                    </svg>
                    123 Lake Road, Colombo 02
                </div>
                <div class="flex items-center gap-2">
                    <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 20 20">
                        <path d="M2 3a1 1 0 011-1h2.153a1 1 0 01.986.836l.74 4.435a1 1 0 01-.54 1.06l-1.548.773a11.037 11.037 0 006.105 6.105l.774-1.548a1 1 0 011.059-.54l4.435.74a1 1 0 01.836.986V17a1 1 0 01-1 1h-2C7.82 18 2 12.18 2 5V3z"/>
                    </svg>
                    +94 77 123 3652
                </div>
            </div>
            <div class="flex items-center gap-4">
                <a href="#" class="hover:text-white/80 transition-colors">
                    <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24"><path d="M18.244 2.25h3.308l-7.227 8.26 8.502 11.24H16.17l-5.214-6.817L4.99 21.75H1.68l7.73-8.835L1.254 2.25H8.08l4.713 6.231zm-1.161 17.52h1.833L7.084 4.126H5.117z"/></svg>
                </a>
                <a href="#" class="hover:text-white/80 transition-colors">
                    <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24"><path d="M24 12.073c0-6.627-5.373-12-12-12s-12 5.373-12 12c0 5.99 4.388 10.954 10.125 11.854v-8.385H7.078v-3.47h3.047V9.43c0-3.007 1.791-4.669 4.533-4.669 1.312 0 2.686.235 2.686.235v2.953H15.83c-1.491 0-1.956.925-1.956 1.874v2.25h3.328l-.532 3.47h-2.796v8.385C19.612 23.027 24 18.062 24 12.073z"/></svg>
                </a>
                <a href="#" class="hover:text-white/80 transition-colors">
                    <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24"><path d="M12 2.163c3.204 0 3.584.012 4.85.07 3.252.148 4.771 1.691 4.919 4.919.058 1.265.069 1.645.069 4.849 0 3.205-.012 3.584-.069 4.849-.149 3.225-1.664 4.771-4.919 4.919-1.266.058-1.644.07-4.85.07-3.204 0-3.584-.012-4.849-.07-3.26-.149-4.771-1.699-4.919-4.92-.058-1.265-.07-1.644-.07-4.849 0-3.204.013-3.583.07-4.849.149-3.227 1.664-4.771 4.919-4.919 1.266-.057 1.645-.069 4.849-.069zm0-2.163c-3.259 0-3.667.014-4.947.072-4.358.2-6.78 2.618-6.98 6.98-.059 1.281-.073 1.689-.073 4.948 0 3.259.014 3.668.072 4.948.2 4.358 2.618 6.78 6.98 6.98 1.281.058 1.689.072 4.948.072 3.259 0 3.668-.014 4.948-.072 4.354-.2 6.782-2.618 6.979-6.98.059-1.28.073-1.689.073-4.949 0-3.259-.014-3.667-.072-4.947-.196-4.354-2.617-6.78-6.979-6.98-1.281-.059-1.69-.073-4.949-.073zm0 5.838c-3.403 0-6.162 2.759-6.162 6.162s2.759 6.163 6.162 6.163 6.162-2.759 6.162-6.163c0-3.403-2.759-6.162-6.162-6.162zm0 10.162c-2.209 0-4-1.79-4-4 0-2.209 1.791-4 4-4s4 1.791 4 4c0 2.21-1.791 4-4 4zm6.406-11.845c-.796 0-1.441.645-1.441 1.44s.645 1.44 1.441 1.44c.795 0 1.439-.645 1.439-1.44s-.644-1.44-1.439-1.44z"/></svg>
                </a>
                <a href="#" class="hover:text-white/80 transition-colors">
                    <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24"><path d="M19 0h-14c-2.761 0-5 2.239-5 5v14c0 2.761 2.239 5 5 5h14c2.761 0 5-2.239 5-5v-14c0-2.761-2.239-5-5-5zm-11 19h-3v-11h3v11zm-1.5-12.268c-.966 0-1.75-.79-1.75-1.764s.784-1.764 1.75-1.764 1.75.79 1.75 1.764-.783 1.764-1.75 1.764zm13.5 12.268h-3v-5.604c0-3.368-4-3.113-4 0v5.604h-3v-11h3v1.765c1.396-2.586 7-2.777 7 2.476v6.759z"/></svg>
                </a>
            </div>
        </div>
    </div>
</div>

<!-- Main Navigation -->
<nav class="bg-white sticky top-0 z-50 shadow-sm border-b border-gray-100">
    <div class="container mx-auto px-4">
        <div class="flex justify-between items-center h-32">
            <!-- Logo -->
            <a href="{{ route('home') }}" class="flex items-center py-2">
                <video autoplay muted loop playsinline poster="{{ asset('images/logo.png') }}" class="h-28 w-auto object-contain mix-blend-multiply">
                    <source src="{{ asset('videos/70_Logo.mp4') }}" type="video/mp4">
                    Your browser does not support the video tag.
                </video>
            </a>

            <!-- Desktop Menu -->
            <div class="hidden lg:flex items-center gap-10">
                <a href="{{ route('home') }}#about" class="text-gray-800 hover:text-[#558B2F] font-bold uppercase tracking-wider text-sm transition-colors">About</a>
                
                <!-- Room Dropdown -->
                <div class="relative group">
                    <button class="flex items-center gap-1 text-gray-800 hover:text-[#558B2F] font-bold uppercase tracking-wider text-sm transition-colors py-8">
                        Room
                        <svg class="w-3 h-3 transition-transform group-hover:rotate-180" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/></svg>
                    </button>
                    <div class="absolute left-0 mt-0 w-48 bg-white rounded-md shadow-xl border border-gray-100 opacity-0 invisible group-hover:opacity-100 group-hover:visible transition-all duration-200 z-50">
                        <div class="py-2">
                            <a href="{{ route('rooms.index') }}" class="block px-4 py-2.5 text-sm text-gray-700 hover:bg-[#558B2F] hover:text-white transition-colors uppercase font-bold tracking-wider">All Rooms</a>
                            <a href="{{ route('rooms.index') }}" class="block px-4 py-2.5 text-sm text-gray-700 hover:bg-[#558B2F] hover:text-white transition-colors uppercase font-bold tracking-wider">Luxury Villa</a>
                        </div>
                    </div>
                </div>

                <!-- Services Dropdown -->
                <div class="relative group">
                    <button class="flex items-center gap-1 text-gray-800 hover:text-[#558B2F] font-bold uppercase tracking-wider text-sm transition-colors py-8">
                        Services
                        <svg class="w-3 h-3 transition-transform group-hover:rotate-180" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/></svg>
                    </button>
                    <div class="absolute left-0 mt-0 w-48 bg-white rounded-md shadow-xl border border-gray-100 opacity-0 invisible group-hover:opacity-100 group-hover:visible transition-all duration-200 z-50">
                        <div class="py-2">
                            <a href="{{ route('home') }}#services" class="block px-4 py-2.5 text-sm text-gray-700 hover:bg-[#558B2F] hover:text-white transition-colors uppercase font-bold tracking-wider">Our Services</a>
                            <a href="#" class="block px-4 py-2.5 text-sm text-gray-700 hover:bg-[#558B2F] hover:text-white transition-colors uppercase font-bold tracking-wider">Spa & Wellness</a>
                            <a href="#" class="block px-4 py-2.5 text-sm text-gray-700 hover:bg-[#558B2F] hover:text-white transition-colors uppercase font-bold tracking-wider">Restaurant</a>
                        </div>
                    </div>
                </div>

                <a href="{{ route('contact') }}" class="text-gray-800 hover:text-[#558B2F] font-bold uppercase tracking-wider text-sm transition-colors">Contact Us</a>
            </div>

            <!-- Right Action -->
            <div class="hidden lg:flex items-center gap-6">
                @auth
                    <div class="relative group">
                        <button class="flex items-center gap-2 px-6 py-2.5 bg-[#558B2F] text-white rounded-md font-bold hover:bg-[#457025] transition-all shadow-md">
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"/>
                            </svg>
                            {{ Auth::user()->name }}
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                            </svg>
                        </button>
                        
                        <!-- Dropdown Menu -->
                        <div class="absolute right-0 mt-2 w-56 bg-white rounded-lg shadow-xl border border-gray-100 opacity-0 invisible group-hover:opacity-100 group-hover:visible transition-all duration-200 z-50">
                            <div class="py-2">
                                <a href="{{ route('dashboard') }}" class="flex items-center gap-3 px-4 py-3 text-gray-700 hover:bg-[#558B2F] hover:text-white transition-colors">
                                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6"/>
                                    </svg>
                                    Dashboard
                                </a>
                                <a href="{{ route('profile.edit') }}" class="flex items-center gap-3 px-4 py-3 text-gray-700 hover:bg-[#558B2F] hover:text-white transition-colors">
                                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"/>
                                    </svg>
                                    Profile
                                </a>
                                <div class="border-t border-gray-100 my-2"></div>
                                <form method="POST" action="{{ route('logout') }}">
                                    @csrf
                                    <button type="submit" class="flex items-center gap-3 w-full px-4 py-3 text-left text-red-600 hover:bg-red-50 transition-colors">
                                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1"/>
                                        </svg>
                                        Logout
                                    </button>
                                </form>
                            </div>
                        </div>
                    </div>
                @else
                    <a href="{{ route('rooms.index') }}" class="px-8 py-3 bg-[#558B2F] hover:bg-[#457025] text-white font-bold rounded shadow-lg hover:shadow-xl transition-all duration-300 uppercase tracking-widest text-sm">
                        Book Now
                    </a>
                    <a href="{{ route('login') }}" class="px-6 py-2.5 text-[#558B2F] font-bold hover:text-[#457025] transition-colors uppercase tracking-wider text-sm">Login</a>
                    <a href="{{ route('register') }}" class="px-8 py-3 bg-[#558B2F] text-white rounded font-bold hover:bg-[#457025] transition-all shadow-md uppercase tracking-wider text-sm">Register</a>
                @endauth
            </div>

            <!-- Mobile menu button -->
            <button id="mobile-menu-btn" class="lg:hidden text-gray-800 p-2">
                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16"/>
                </svg>
            </button>
        </div>
    </div>

    <!-- Mobile Menu -->
    <div id="mobile-menu" class="hidden lg:hidden bg-white border-t border-gray-100 p-4">
        <div class="flex flex-col gap-4">
            <a href="{{ route('home') }}#about" class="text-gray-800 font-semibold hover:text-[#558B2F]">About</a>
            <a href="{{ route('rooms.index') }}" class="text-gray-800 font-semibold hover:text-[#558B2F]">Room</a>
            <a href="{{ route('halls.index') }}" class="text-gray-800 font-semibold hover:text-[#558B2F]">Halls</a>
            <a href="{{ route('home') }}#services" class="text-gray-800 font-semibold hover:text-[#558B2F]">Services</a>
            <a href="{{ route('contact') }}" class="text-gray-800 font-semibold hover:text-[#558B2F]">Contact Us</a>
            @auth
                <a href="{{ route('dashboard') }}" class="w-full text-center py-3 bg-[#558B2F] text-white rounded-md font-bold">Dashboard</a>
            @else
                <a href="{{ route('rooms.index') }}" class="w-full text-center py-3 bg-[#558B2F] text-white rounded-md font-bold">Book Now</a>
            @endauth
        </div>
    </div>
</nav>

<script>
    // Mobile menu toggle
    document.getElementById('mobile-menu-btn')?.addEventListener('click', function() {
        document.getElementById('mobile-menu')?.classList.toggle('hidden');
    });
</script>
