@extends('layouts.app')

@section('content')
<section class="relative min-h-screen flex items-center justify-center overflow-hidden py-20">
    <!-- Animated Background -->
    <div class="absolute inset-0 bg-gradient-to-br from-emerald-950 via-slate-900 to-emerald-900">
        <div class="absolute inset-0 opacity-20">
            <div class="absolute top-0 -left-10 w-96 h-96 bg-emerald-500 rounded-full mix-blend-multiply filter blur-3xl animate-blob"></div>
            <div class="absolute top-0 -right-10 w-96 h-96 bg-amber-500 rounded-full mix-blend-multiply filter blur-3xl animate-blob animation-delay-2000"></div>
            <div class="absolute -bottom-20 left-1/2 -translate-x-1/2 w-[30rem] h-[30rem] bg-emerald-400/20 rounded-full mix-blend-overlay filter blur-3xl animate-blob animation-delay-4000"></div>
        </div>
        <!-- Modern Pattern Overlay -->
        <div class="absolute inset-0 opacity-10" style="background-image: radial-gradient(circle at 2px 2px, rgba(255,255,255,0.15) 1px, transparent 0); background-size: 40px 40px;"></div>
    </div>

    <!-- Floating Particles -->
    <div class="absolute inset-0 overflow-hidden pointer-events-none z-0">
        <div class="particle-float absolute w-2 h-2 bg-emerald-400/30 rounded-full" style="top: 20%; left: 10%; animation-delay: 0s;"></div>
        <div class="particle-float absolute w-3 h-3 bg-amber-400/20 rounded-full" style="top: 70%; left: 80%; animation-delay: 2s;"></div>
        <div class="particle-float absolute w-2 h-2 bg-white/20 rounded-full" style="top: 40%; left: 40%; animation-delay: 5s;"></div>
    </div>

    <div class="relative z-10 container mx-auto px-6">
        <div class="max-w-3xl mx-auto">
            <div class="bg-white rounded-[3rem] shadow-2xl p-8 md:p-16 text-center animate-fade-in-up border border-white/50 relative overflow-hidden italic-none">
                <!-- Success Icon -->
                <div class="relative w-32 h-32 mx-auto mb-10">
                    <div class="absolute inset-0 bg-emerald-500/10 rounded-full animate-ping"></div>
                    <div class="relative w-32 h-32 bg-emerald-100 text-emerald-600 rounded-full flex items-center justify-center shadow-lg shadow-emerald-500/20">
                        <svg class="w-16 h-16" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                    </div>
                </div>

                <h1 class="text-4xl md:text-5xl font-bold text-slate-900 mb-6">Request Received!</h1>
                <p class="text-lg text-slate-500 mb-12 italic-none leading-relaxed">
                    Thank you for choosing Harmony Nature Village. Your request for the <span class="text-emerald-600 font-bold">{{ $booking->hall->name }}</span> venue is now aligned for review.
                </p>

                <!-- Details Panel -->
                <div class="bg-slate-50 rounded-[2rem] p-8 mb-12 text-left border border-slate-100 italic-none">
                    <div class="flex items-center gap-4 mb-8">
                        <div class="w-12 h-1 bg-gradient-to-r from-emerald-500 to-emerald-300 rounded-full"></div>
                        <h3 class="text-xs font-black uppercase tracking-[0.2em] text-slate-400">Booking Essence</h3>
                    </div>
                    
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
                        <div class="italic-none">
                            <p class="text-[10px] text-slate-400 font-bold uppercase tracking-widest mb-1 italic-none">Event Date</p>
                            <p class="text-lg font-bold text-slate-900 italic-none">{{ $booking->event_date->format('F d, Y') }}</p>
                        </div>
                        <div class="italic-none">
                            <p class="text-[10px] text-slate-400 font-bold uppercase tracking-widest mb-1 italic-none">Occasion</p>
                            <p class="text-lg font-bold text-slate-900 italic-none">{{ $booking->event_type }}</p>
                        </div>
                        <div class="italic-none">
                            <p class="text-[10px] text-slate-400 font-bold uppercase tracking-widest mb-1 italic-none">Total Investment</p>
                            <p class="text-xl font-bold text-emerald-600 italic-none">LKR {{ number_format($booking->total_price) }}</p>
                        </div>
                        <div class="italic-none">
                            <p class="text-[10px] text-slate-400 font-bold uppercase tracking-widest mb-1 italic-none">Current State</p>
                            <span class="inline-flex items-center gap-2 px-4 py-1.5 bg-amber-100 text-amber-700 text-[10px] font-black uppercase tracking-widest rounded-full border border-amber-200">
                                <span class="w-1.5 h-1.5 bg-amber-500 rounded-full animate-pulse"></span>
                                {{ $booking->status }}
                            </span>
                        </div>
                    </div>
                </div>

                <!-- Action Buttons -->
                <div class="flex flex-col sm:flex-row items-center justify-center gap-6 italic-none">
                    <a href="{{ route('dashboard') }}" class="group w-full sm:w-auto flex items-center justify-center gap-3 bg-slate-900 text-white font-bold py-5 px-10 rounded-2xl transition-all hover:bg-emerald-600 hover:scale-105 shadow-xl shadow-slate-900/20 italic-none">
                        <span>My Journeys</span>
                        <svg class="w-5 h-5 group-hover:translate-x-1 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M14 5l7 7m0 0l-7 7m7-7H3"/></svg>
                    </a>
                    <a href="{{ route('home') }}" class="w-full sm:w-auto bg-white border-2 border-slate-100 hover:border-emerald-200 text-slate-600 font-bold py-5 px-10 rounded-2xl transition-all hover:bg-emerald-50 italic-none">
                        Return to Village
                    </a>
                </div>
            </div>
        </div>
    </div>
</section>

<style>
@keyframes blob {
    0% { transform: translate(0px, 0px) scale(1); }
    33% { transform: translate(30px, -50px) scale(1.1); }
    66% { transform: translate(-20px, 20px) scale(0.9); }
    100% { transform: translate(0px, 0px) scale(1); }
}

.animate-blob {
    animation: blob 7s infinite;
}

.animation-delay-2000 {
    animation-delay: 2s;
}

.animation-delay-4000 {
    animation-delay: 4s;
}

@keyframes fade-in-up {
    from { opacity: 0; transform: translateY(30px); }
    to { opacity: 1; transform: translateY(0); }
}

@keyframes particle-float {
    0%, 100% { transform: translateY(0) translateX(0); opacity: 0.3; }
    50% { transform: translateY(-100px) translateX(50px); opacity: 0.6; }
}

.animate-fade-in-up {
    animation: fade-in-up 0.8s ease-out forwards;
}

.particle-float {
    animation: particle-float 10s ease-in-out infinite;
}
</style>
@endsection
