<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            color: #333;
            max-width: 600px;
            margin: 0 auto;
            padding: 20px;
        }
        .header {
            background: linear-gradient(135deg, #2563eb 0%, #4f46e5 100%);
            color: white;
            padding: 30px;
            text-align: center;
            border-radius: 8px 8px 0 0;
        }
        .content {
            background: #fff;
            padding: 30px;
            border: 1px solid #e5e7eb;
        }
        .booking-details {
            background: #f9fafb;
            padding: 20px;
            border-radius: 8px;
            margin: 20px 0;
        }
        .detail-row {
            display: flex;
            justify-content: space-between;
            padding: 10px 0;
            border-bottom: 1px solid #e5e7eb;
        }
        .detail-label {
            font-weight: bold;
            color: #6b7280;
        }
        .detail-value {
            color: #111827;
        }
        .total {
            font-size: 24px;
            color: #2563eb;
            font-weight: bold;
        }
        .footer {
            background: #f9fafb;
            padding: 20px;
            text-align: center;
            border-radius: 0 0 8px 8px;
            color: #6b7280;
        }
        .button {
            display: inline-block;
            background: #2563eb;
            color: white;
            padding: 12px 30px;
            text-decoration: none;
            border-radius: 6px;
            margin: 20px 0;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1 style="margin: 0;">MHEC Hotel</h1>
        <p style="margin: 10px 0 0 0;">Booking Confirmation</p>
    </div>

    <div class="content">
        <h2>Dear {{ $booking->user->name }},</h2>
        <p>Thank you for choosing MHEC Hotel! Your booking has been confirmed.</p>

        <div class="booking-details">
            <h3 style="margin-top: 0;">Booking Details</h3>
            
            <div class="detail-row">
                <span class="detail-label">Booking ID:</span>
                <span class="detail-value">#{{ $booking->id }}</span>
            </div>

            <div class="detail-row">
                <span class="detail-label">Room:</span>
                <span class="detail-value">{{ $booking->room->name }}</span>
            </div>

            <div class="detail-row">
                <span class="detail-label">Room Type:</span>
                <span class="detail-value">{{ $booking->room->type }}</span>
            </div>

            <div class="detail-row">
                <span class="detail-label">Check-in:</span>
                <span class="detail-value">{{ $booking->check_in->format('F d, Y') }}</span>
            </div>

            <div class="detail-row">
                <span class="detail-label">Check-out:</span>
                <span class="detail-value">{{ $booking->check_out->format('F d, Y') }}</span>
            </div>

            <div class="detail-row">
                <span class="detail-label">Duration:</span>
                <span class="detail-value">{{ $booking->check_in->diffInDays($booking->check_out) }} nights</span>
            </div>

            <div class="detail-row" style="border-bottom: none; margin-top: 10px;">
                <span class="detail-label">Total Amount:</span>
                <span class="total">LKR {{ number_format($booking->total_price, 2) }}</span>
            </div>
        </div>

        <h3>Important Information:</h3>
        <ul>
            <li>Check-in time: 2:00 PM</li>
            <li>Check-out time: 12:00 PM</li>
            <li>Please bring a valid ID for verification</li>
            <li>Payment can be made at the hotel reception</li>
        </ul>

        <p>If you have any questions or need to make changes to your booking, please contact us.</p>

        <center>
            <a href="{{ route('booking.confirmation', $booking) }}" class="button">View Booking Details</a>
        </center>
    </div>

    <div class="footer">
        <p><strong>MHEC Hotel</strong></p>
        <p>Email: info@mhechotel.com | Phone: +94 XX XXX XXXX</p>
        <p>&copy; {{ date('Y') }} MHEC Hotel. All rights reserved.</p>
    </div>
</body>
</html>
