@extends('layouts.app')

@section('content')
<!-- Dashboard Header - Matching Home Page Theme -->
<section class="relative min-h-[50vh] flex items-center overflow-hidden pb-24">
    <!-- Background with Home Page Green Theme -->
    <div class="absolute inset-0 bg-gradient-to-br from-[#3d6320] via-[#558B2F] to-[#4a7a28]">
        <div class="absolute inset-0 opacity-20">
            <div class="absolute top-0 -left-10 w-96 h-96 bg-[#558B2F] rounded-full mix-blend-multiply filter blur-3xl animate-blob"></div>
            <div class="absolute top-0 -right-10 w-96 h-96 bg-[#7cb342] rounded-full mix-blend-multiply filter blur-3xl animate-blob animation-delay-2000"></div>
            <div class="absolute -bottom-20 left-1/2 -translate-x-1/2 w-[30rem] h-[30rem] bg-[#8bc34a]/20 rounded-full mix-blend-overlay filter blur-3xl animate-blob animation-delay-4000"></div>
        </div>
        <!-- Pattern Overlay -->
        <div class="absolute inset-0 opacity-10" style="background-image: radial-gradient(circle at 2px 2px, rgba(255,255,255,0.15) 1px, transparent 0); background-size: 40px 40px;"></div>
    </div>

    <!-- Floating Particles -->
    <div class="absolute inset-0 overflow-hidden pointer-events-none z-0">
        <div class="particle-float absolute w-2 h-2 bg-white/30 rounded-full" style="top: 20%; left: 10%; animation-delay: 0s;"></div>
        <div class="particle-float absolute w-3 h-3 bg-[#8bc34a]/30 rounded-full" style="top: 70%; left: 80%; animation-delay: 2s;"></div>
        <div class="particle-float absolute w-2 h-2 bg-white/20 rounded-full" style="top: 40%; left: 40%; animation-delay: 5s;"></div>
    </div>
    
    <div class="relative z-10 container mx-auto px-6">
        <div class="flex flex-col md:flex-row md:items-center justify-between gap-8">
            <div class="animate-fade-in-up">
                <div class="inline-flex items-center gap-2 px-4 py-2 bg-white/10 backdrop-blur-md rounded-full border border-white/20 mb-6">
                    <span class="flex h-2 w-2 rounded-full bg-[#8bc34a] animate-pulse"></span>
                    <span class="text-white/90 text-xs font-bold uppercase tracking-widest">Guest Member</span>
                </div>
                <h1 class="text-5xl md:text-6xl font-bold text-white mb-4 font-display">
                    Welcome back, <br>
                    <span class="text-white">
                        {{ Auth::user()->name }}
                    </span>
                </h1>
                <p class="text-lg text-white/70 max-w-xl leading-relaxed text-sm md:text-lg">
                    Harmony awaits you in the eco village. Manage your sustainable sanctuary stays and experiences here.
                </p>
            </div>
            
            <div class="animate-fade-in-up animation-delay-200">
                <a href="{{ route('rooms.index') }}" 
                   class="group relative inline-flex items-center gap-3 px-8 py-4 bg-amber-400 hover:bg-amber-500 text-gray-900 font-bold rounded-md shadow-2xl transition-all hover:scale-105 uppercase tracking-widest text-sm">
                    <svg class="w-5 h-5 group-hover:rotate-12 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"></path>
                    </svg>
                    Book New Experience
                </a>
            </div>
        </div>
    </div>
</section>

<!-- Stats Grid -->
@if(isset($stats))
<section class="relative -mt-16 z-20 pb-12">
    <div class="container mx-auto px-6">
        <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
            <!-- Stat 1 -->
            <div class="group relative bg-white/95 backdrop-blur-xl p-8 rounded-2xl shadow-xl border border-gray-100 overflow-hidden hover:shadow-2xl transition-all duration-300">
                <div class="absolute -right-4 -top-4 w-32 h-32 bg-[#558B2F]/5 rounded-full group-hover:scale-150 transition-transform duration-700"></div>
                <div class="relative flex items-center gap-6">
                    <div class="w-16 h-16 bg-[#558B2F]/10 text-[#558B2F] rounded-xl flex items-center justify-center">
                        <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"></path>
                        </svg>
                    </div>
                    <div>
                        <p class="text-sm font-bold text-gray-500 uppercase tracking-widest">Total Stays</p>
                        <p class="text-4xl font-bold text-gray-900 mt-1">{{ $stats['total_bookings'] }}</p>
                    </div>
                </div>
            </div>

            <!-- Stat 2 -->
            <div class="group relative bg-white/95 backdrop-blur-xl p-8 rounded-2xl shadow-xl border border-gray-100 overflow-hidden hover:shadow-2xl transition-all duration-300">
                <div class="absolute -right-4 -top-4 w-32 h-32 bg-[#8bc34a]/5 rounded-full group-hover:scale-150 transition-transform duration-700"></div>
                <div class="relative flex items-center gap-6">
                    <div class="w-16 h-16 bg-[#8bc34a]/10 text-[#558B2F] rounded-xl flex items-center justify-center">
                        <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                    </div>
                    <div>
                        <p class="text-sm font-bold text-gray-500 uppercase tracking-widest">Active Now</p>
                        <p class="text-4xl font-bold text-gray-900 mt-1">{{ $stats['active_bookings'] }}</p>
                    </div>
                </div>
            </div>

            <!-- Stat 3 -->
            <div class="group relative bg-white/95 backdrop-blur-xl p-8 rounded-2xl shadow-xl border border-gray-100 overflow-hidden hover:shadow-2xl transition-all duration-300">
                <div class="absolute -right-4 -top-4 w-32 h-32 bg-[#558B2F]/5 rounded-full group-hover:scale-150 transition-transform duration-700"></div>
                <div class="relative flex items-center gap-6">
                    <div class="w-16 h-16 bg-[#558B2F] text-white rounded-xl flex items-center justify-center">
                        <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                    </div>
                    <div>
                        <p class="text-sm font-bold text-gray-500 uppercase tracking-widest">Village Credit</p>
                        <p class="text-3xl font-bold text-gray-900 mt-1">LKR {{ number_format($stats['total_spent'], 0) }}</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
@endif

<!-- Content Section -->
<section class="py-12 bg-gray-50/50 min-h-screen">
    <div class="container mx-auto px-6">
        <div class="grid grid-cols-1 lg:grid-cols-12 gap-12">
            
            <!-- Main Content: Bookings -->
            <div class="lg:col-span-8" x-data="{ activeTab: 'rooms' }">
                <div class="flex flex-col md:flex-row md:items-center justify-between mb-10 gap-6">
                    <div>
                        <h2 class="text-4xl font-bold text-gray-900 mb-2 font-display">My Journey</h2>
                        <div class="w-20 h-1.5 bg-[#558B2F] rounded-full"></div>
                    </div>
                    
                    <div class="bg-white/80 backdrop-blur-md p-1.5 rounded-xl border border-gray-200 shadow-sm flex gap-1 w-full md:w-auto">
                        <button @click="activeTab = 'rooms'" 
                                :class="activeTab === 'rooms' ? 'bg-[#558B2F] text-white shadow-lg' : 'text-gray-500 hover:bg-gray-100'"
                                class="flex-1 md:flex-none px-6 py-2.5 rounded-lg font-bold transition-all text-sm flex items-center justify-center gap-2">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6"/></svg>
                            Villas
                        </button>
                        <button @click="activeTab = 'halls'" 
                                :class="activeTab === 'halls' ? 'bg-[#558B2F] text-white shadow-lg' : 'text-gray-500 hover:bg-gray-100'"
                                class="flex-1 md:flex-none px-6 py-2.5 rounded-lg font-bold transition-all text-sm flex items-center justify-center gap-2">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"/></svg>
                            Venues
                        </button>
                    </div>
                </div>

                <!-- Villa Bookings -->
                <div x-show="activeTab === 'rooms'" x-transition:enter="transition-all ease-out duration-500" x-transition:enter-start="opacity-0 translate-y-4">
                    @if(isset($bookings) && $bookings->count() > 0)
                        <div class="space-y-8">
                            @foreach($bookings as $booking)
                                <div class="group bg-white rounded-2xl shadow-lg hover:shadow-xl transition-all duration-500 overflow-hidden border border-gray-100">
                                    <div class="md:flex">
                                        <div class="md:w-72 h-64 md:h-auto relative overflow-hidden">
                                            @if($booking->room->image)
                                                <img src="{{ asset('storage/' . $booking->room->image) }}" class="w-full h-full object-cover group-hover:scale-110 transition-transform duration-700">
                                            @else
                                                <div class="w-full h-full bg-[#558B2F] flex items-center justify-center">
                                                    <span class="text-4xl">🌿</span>
                                                </div>
                                            @endif
                                            <div class="absolute inset-0 bg-gradient-to-r from-black/20 to-transparent"></div>
                                        </div>

                                        <div class="flex-1 p-8">
                                            <div class="flex items-start justify-between mb-6 gap-4">
                                                <div>
                                                    <span class="px-3 py-1 bg-[#558B2F]/10 text-[#558B2F] text-[10px] font-black uppercase tracking-[0.2em] rounded-full">Villa Sanctuary</span>
                                                    <h3 class="text-2xl font-bold text-gray-900 mt-2">{{ $booking->room->name }}</h3>
                                                </div>
                                                <span class="inline-flex items-center gap-2 px-4 py-2 rounded-lg text-xs font-bold uppercase tracking-wider
                                                    @if($booking->status === 'confirmed') bg-[#558B2F]/10 text-[#558B2F]
                                                    @elseif($booking->status === 'pending') bg-amber-100 text-amber-700
                                                    @else bg-rose-100 text-rose-700
                                                    @endif shadow-sm whitespace-nowrap">
                                                    {{ $booking->status }}
                                                </span>
                                            </div>

                                            <div class="grid grid-cols-2 md:grid-cols-4 gap-6 mb-8">
                                                <div>
                                                    <p class="text-[10px] text-gray-400 font-bold uppercase tracking-widest mb-1">Check In</p>
                                                    <p class="font-bold text-gray-800 text-sm">{{ \Carbon\Carbon::parse($booking->check_in)->format('M d, Y') }}</p>
                                                </div>
                                                <div>
                                                    <p class="text-[10px] text-gray-400 font-bold uppercase tracking-widest mb-1">Check Out</p>
                                                    <p class="font-bold text-gray-800 text-sm">{{ \Carbon\Carbon::parse($booking->check_out)->format('M d, Y') }}</p>
                                                </div>
                                                <div>
                                                    <p class="text-[10px] text-gray-400 font-bold uppercase tracking-widest mb-1">Duration</p>
                                                    <p class="font-bold text-gray-800 text-sm">{{ \Carbon\Carbon::parse($booking->check_in)->diffInDays($booking->check_out) }} Nights</p>
                                                </div>
                                                <div>
                                                    <p class="text-[10px] text-gray-400 font-bold uppercase tracking-widest mb-1">Value</p>
                                                    <p class="font-bold text-[#558B2F] text-sm">LKR {{ number_format($booking->total_price, 0) }}</p>
                                                </div>
                                            </div>

                                            <div class="flex flex-col sm:flex-row items-center justify-between pt-6 border-t border-gray-100 gap-4">
                                                <p class="text-xs font-medium text-gray-400">ID: <span class="font-mono text-gray-600">#VS-{{ $booking->id }}</span></p>
                                                <a href="{{ route('rooms.show', $booking->room) }}" class="w-full sm:w-auto inline-flex items-center justify-center gap-2 px-6 py-2.5 bg-[#558B2F] hover:bg-[#457025] text-white rounded-md text-sm font-bold transition-colors uppercase tracking-wider">
                                                    Explore Details
                                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M14 5l7 7m0 0l-7 7m7-7H3"/></svg>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    @else
                        <div class="bg-white rounded-2xl p-16 text-center shadow-lg border border-gray-100">
                            <div class="w-24 h-24 bg-[#558B2F]/10 text-[#558B2F] rounded-full flex items-center justify-center mx-auto mb-8">
                                <span class="text-5xl">🎍</span>
                            </div>
                            <h3 class="text-3xl font-bold text-gray-900 mb-4 font-display">No Active Sanctuaries</h3>
                            <p class="text-gray-500 mb-10 text-lg max-w-md mx-auto">Your journey of sustainable luxury is waiting to begin. Discover our eco-villas today.</p>
                            <a href="{{ route('rooms.index') }}" class="inline-flex px-10 py-4 bg-[#558B2F] hover:bg-[#457025] text-white font-bold rounded-md shadow-lg transition-all hover:scale-105 uppercase tracking-widest text-sm">Find Your Villa</a>
                        </div>
                    @endif
                </div>

                <!-- Hall Bookings (Venues) -->
                <div x-show="activeTab === 'halls'" x-transition:enter="transition-all ease-out duration-500" x-transition:enter-start="opacity-0 translate-y-4" x-cloak>
                    @if(isset($hallBookings) && $hallBookings->count() > 0)
                        <div class="space-y-8">
                            @foreach($hallBookings as $booking)
                                <div class="group bg-white rounded-2xl shadow-lg hover:shadow-xl transition-all duration-500 overflow-hidden border border-gray-100">
                                    <div class="md:flex">
                                        <div class="md:w-72 h-64 md:h-auto relative overflow-hidden">
                                            @if($booking->hall->image)
                                                <img src="{{ asset('storage/' . $booking->hall->image) }}" class="w-full h-full object-cover group-hover:scale-110 transition-transform duration-700">
                                            @else
                                                <div class="w-full h-full bg-[#558B2F] flex items-center justify-center">
                                                    <span class="text-4xl">🏛️</span>
                                                </div>
                                            @endif
                                        </div>

                                        <div class="flex-1 p-8">
                                            <div class="flex items-start justify-between mb-6 gap-4">
                                                <div>
                                                    <span class="px-3 py-1 bg-[#8bc34a]/10 text-[#558B2F] text-[10px] font-black uppercase tracking-[0.2em] rounded-full">Grand Venue</span>
                                                    <h3 class="text-2xl font-bold text-gray-900 mt-2">{{ $booking->hall->name }}</h3>
                                                </div>
                                                <span class="inline-flex items-center gap-2 px-4 py-2 rounded-lg text-xs font-bold uppercase tracking-wider bg-[#558B2F]/10 text-[#558B2F]">
                                                    {{ $booking->status }}
                                                </span>
                                            </div>

                                            <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-8">
                                                <div>
                                                    <p class="text-[10px] text-gray-400 font-bold uppercase tracking-widest mb-1">Event Date</p>
                                                    <p class="font-bold text-gray-800 text-sm">{{ $booking->event_date->format('M d, Y') }}</p>
                                                </div>
                                                <div>
                                                    <p class="text-[10px] text-gray-400 font-bold uppercase tracking-widest mb-1">Occasion</p>
                                                    <p class="font-bold text-gray-800 text-sm">{{ $booking->event_type }}</p>
                                                </div>
                                                <div>
                                                    <p class="text-[10px] text-gray-400 font-bold uppercase tracking-widest mb-1">Investment</p>
                                                    <p class="font-bold text-[#558B2F] text-sm">LKR {{ number_format($booking->total_price, 0) }}</p>
                                                </div>
                                            </div>

                                            <div class="flex flex-col sm:flex-row items-center justify-between pt-6 border-t border-gray-100 gap-4">
                                                <p class="text-xs font-medium text-gray-400">ID: <span class="font-mono text-gray-600">#GV-{{ $booking->id }}</span></p>
                                                <a href="{{ route('halls.show', $booking->hall) }}" class="w-full sm:w-auto inline-flex items-center justify-center gap-2 px-6 py-2.5 bg-[#558B2F] hover:bg-[#457025] text-white rounded-md text-sm font-bold transition-colors uppercase tracking-wider">
                                                    Venue Details
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    @else
                        <div class="bg-white rounded-2xl p-16 text-center shadow-lg border border-gray-100">
                            <div class="w-24 h-24 bg-[#8bc34a]/10 text-[#558B2F] rounded-full flex items-center justify-center mx-auto mb-8 font-bold">
                                <span class="text-5xl">🎪</span>
                            </div>
                            <h3 class="text-3xl font-bold text-gray-900 mb-4 font-display">No Grand Events Yet</h3>
                            <p class="text-gray-500 mb-10 text-lg max-w-md mx-auto">Host your next milestone in our eco-conscious grand venues. Elegant, sustainable, and unforgettable.</p>
                            <a href="{{ route('halls.index') }}" class="inline-flex px-10 py-4 bg-[#558B2F] hover:bg-[#457025] text-white font-bold rounded-md shadow-lg transition-all hover:scale-105 uppercase tracking-widest text-sm">Explore Venues</a>
                        </div>
                    @endif
                </div>
            </div>

            <!-- Sidebar: Review & Actions -->
            <div class="lg:col-span-4 space-y-10">
                
                <!-- Share Experience Section -->
                @if(isset($canReview) && $canReview)
                <div class="bg-white rounded-2xl p-8 shadow-lg border border-gray-100 relative overflow-hidden">
                    <div class="absolute top-0 right-0 w-32 h-32 bg-[#558B2F]/5 rounded-full -mr-16 -mt-16"></div>
                    
                    <h2 class="text-2xl font-bold text-gray-900 mb-4 relative z-10 font-display">Share Your Story</h2>
                    <p class="text-gray-600 mb-8 leading-relaxed">Your voice helps our village grow. How was your recent experience with nature?</p>

                    <form action="{{ route('testimonials.store') }}" method="POST">
                        @csrf
                        <div class="mb-8" x-data="{ rating: 5, hoverRating: 0 }">
                            <label class="block text-gray-900 font-bold mb-4 uppercase tracking-widest text-[10px]">Rating from the Heart</label>
                            <div class="flex gap-2">
                                @for($i = 1; $i <= 5; $i++)
                                    <label class="cursor-pointer group">
                                        <input type="radio" name="rating" value="{{ $i }}" class="hidden" x-model="rating">
                                        <svg @mouseover="hoverRating = {{ $i }}" @mouseleave="hoverRating = 0"
                                             :class="(hoverRating || rating) >= {{ $i }} ? 'text-[#558B2F] scale-110' : 'text-gray-200'"
                                             class="w-8 h-8 md:w-10 md:h-10 transition-all duration-300 fill-current" viewBox="0 0 20 20">
                                            <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>
                                        </svg>
                                    </label>
                                @endfor
                            </div>
                        </div>

                        <div class="mb-8">
                            <label for="content" class="block text-gray-900 font-bold mb-4 uppercase tracking-widest text-[10px]">Your Reflections</label>
                            <textarea name="content" id="content" rows="4" 
                                class="w-full bg-gray-50 border border-gray-200 rounded-xl focus:ring-2 focus:ring-[#558B2F] focus:border-[#558B2F] transition-all p-5 text-gray-700 placeholder:text-gray-400" 
                                placeholder="Describe the harmony you found..." required></textarea>
                        </div>

                        <button type="submit" class="w-full py-4 bg-[#558B2F] hover:bg-[#457025] text-white font-bold rounded-md shadow-lg transition-all hover:scale-[1.02] active:scale-95 uppercase tracking-widest text-sm">
                            Submit to Village
                        </button>
                    </form>
                </div>
                @endif

                <!-- Quick Actions -->
                <div class="space-y-6">
                    <h3 class="text-xl font-bold text-gray-900 mb-6 flex items-center gap-3 font-display">
                        <span class="w-2 h-8 bg-[#558B2F] rounded-full"></span>
                        Quick Connect
                    </h3>
                    
                    <a href="{{ route('profile.edit') }}" class="group flex items-center gap-6 p-6 bg-white rounded-xl shadow-lg border border-gray-100 hover:border-[#558B2F]/30 transition-all hover:-translate-y-1">
                        <div class="w-14 h-14 bg-[#558B2F]/10 text-[#558B2F] rounded-xl flex items-center justify-center group-hover:bg-[#558B2F] group-hover:text-white transition-all duration-300 flex-shrink-0">
                            <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"/></svg>
                        </div>
                        <div>
                            <p class="font-bold text-gray-900 group-hover:text-[#558B2F] transition-colors">Profile Settings</p>
                            <p class="text-xs text-gray-400 uppercase tracking-widest font-black mt-0.5">Edit Details</p>
                        </div>
                        <svg class="w-5 h-5 ml-auto text-gray-300 group-hover:text-[#558B2F] transition-colors hidden sm:block" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"/></svg>
                    </a>

                    <a href="{{ route('contact') }}" class="group flex items-center gap-6 p-6 bg-white rounded-xl shadow-lg border border-gray-100 hover:border-[#8bc34a]/30 transition-all hover:-translate-y-1">
                        <div class="w-14 h-14 bg-[#8bc34a]/10 text-[#558B2F] rounded-xl flex items-center justify-center group-hover:bg-[#558B2F] group-hover:text-white transition-all duration-300 flex-shrink-0">
                            <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 10h.01M12 10h.01M16 10h.01M9 16H5a2 2 0 01-2-2V6a2 2 0 012-2h14a2 2 0 012 2v8a2 2 0 01-2 2h-5l-5 5v-5z"/></svg>
                        </div>
                        <div>
                            <p class="font-bold text-gray-900 group-hover:text-[#558B2F] transition-colors">Concierge Desk</p>
                            <p class="text-xs text-gray-400 uppercase tracking-widest font-black mt-0.5">Get Support</p>
                        </div>
                        <svg class="w-5 h-5 ml-auto text-gray-300 group-hover:text-[#558B2F] transition-colors hidden sm:block" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"/></svg>
                    </a>
                </div>
            </div>
        </div>
    </div>
</section>

<style>
@keyframes blob {
    0% { transform: translate(0px, 0px) scale(1); }
    33% { transform: translate(30px, -50px) scale(1.1); }
    66% { transform: translate(-20px, 20px) scale(0.9); }
    100% { transform: translate(0px, 0px) scale(1); }
}

.animate-blob {
    animation: blob 7s infinite;
}

.animation-delay-2000 {
    animation-delay: 2s;
}

.animation-delay-4000 {
    animation-delay: 4s;
}

@keyframes fade-in-up {
    from { opacity: 0; transform: translateY(30px); }
    to { opacity: 1; transform: translateY(0); }
}

@keyframes particle-float {
    0%, 100% { transform: translateY(0) translateX(0); opacity: 0.3; }
    50% { transform: translateY(-100px) translateX(50px); opacity: 0.6; }
}

.animate-fade-in-up {
    animation: fade-in-up 0.8s ease-out forwards;
}

.particle-float {
    animation: particle-float 10s ease-in-out infinite;
}

.animation-delay-200 {
    animation-delay: 0.2s;
    animation-fill-mode: both;
}

[x-cloak] { display: none !important; }

/* Custom Scrollbar matching home page */
::-webkit-scrollbar {
    width: 10px;
}
::-webkit-scrollbar-track {
    background: #f1f5f9;
}
::-webkit-scrollbar-thumb {
    background: #558B2F;
    border-radius: 5px;
}
::-webkit-scrollbar-thumb:hover {
    background: #457025;
}
</style>
@endsection
