@extends('layouts.app')

@section('content')
<!-- Contact Hero Section - Home Page Theme -->
<section class="relative min-h-[60vh] flex items-center justify-center overflow-hidden">
    <!-- Animated Background with Green Theme -->
    <div class="absolute inset-0 bg-gradient-to-br from-[#3d6320] via-[#558B2F] to-[#4a7a28]">
        <div class="absolute inset-0 opacity-20">
            <div class="absolute top-0 -left-4 w-72 h-72 bg-[#558B2F] rounded-full mix-blend-multiply filter blur-xl animate-blob"></div>
            <div class="absolute top-0 -right-4 w-72 h-72 bg-[#8bc34a] rounded-full mix-blend-multiply filter blur-xl animate-blob animation-delay-2000"></div>
            <div class="absolute -bottom-8 left-20 w-72 h-72 bg-[#558B2F] rounded-full mix-blend-multiply filter blur-xl animate-blob animation-delay-4000"></div>
        </div>
        <!-- Pattern Overlay -->
        <div class="absolute inset-0 opacity-10" style="background-image: radial-gradient(circle at 2px 2px, rgba(255,255,255,0.15) 1px, transparent 0); background-size: 40px 40px;"></div>
    </div>
    
    <!-- Hero Content -->
    <div class="relative z-10 container mx-auto px-6 text-center">
        <div class="inline-flex items-center gap-2 px-4 py-2 bg-white/10 backdrop-blur-md rounded-full border border-white/20 mb-6 animate-fade-in-down">
            
            <span class="text-white/90 text-sm font-medium uppercase tracking-widest">Get In Touch</span>
        </div>
        
        <h1 class="text-6xl md:text-7xl font-bold text-white mb-6 animate-fade-in-up font-display">
            Contact
            <span class="text-white">Us</span>
        </h1>
        
        <p class="text-xl text-white/80 max-w-2xl mx-auto animate-fade-in-up animation-delay-200">
            We'd love to hear from you. Send us a message and we'll respond as soon as possible.
        </p>
    </div>
</section>

<!-- Contact Content Section -->
<section class="relative -mt-20 z-20 pb-24">
    <div class="container mx-auto px-6">
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-12">
            <!-- Contact Form Card -->
            <div class="bg-white rounded-2xl shadow-2xl p-8 md:p-12 border border-gray-100">
                <div class="mb-8">
                    <span class="inline-block px-4 py-2 bg-[#558B2F]/10 text-[#558B2F] rounded-full text-sm font-semibold mb-4">📝 Send Message</span>
                    <h2 class="text-4xl font-bold text-gray-900 mb-3 font-display">Get in Touch</h2>
                    <p class="text-gray-600">Have a question or feedback? Fill out the form below and we'll get back to you shortly.</p>
                </div>

                @if(session('success'))
                    <div class="mb-6 p-4 bg-[#558B2F]/10 border-l-4 border-[#558B2F] rounded-r-xl animate-fade-in-up">
                        <div class="flex items-center gap-3">
                            <svg class="w-6 h-6 text-[#558B2F]" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                            </svg>
                            <p class="text-[#558B2F] font-medium">{{ session('success') }}</p>
                        </div>
                    </div>
                @endif

                <form action="{{ route('contact.store') }}" method="POST" class="space-y-6">
                    @csrf
                    
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <!-- Name Field -->
                        <div class="space-y-2">
                            <label for="name" class="text-sm font-semibold text-gray-700 flex items-center gap-2">
                                <span class="text-[#558B2F]">👤</span> Full Name
                            </label>
                            <input type="text" 
                                   name="name" 
                                   id="name" 
                                   value="{{ old('name') }}"
                                   class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:border-[#558B2F] focus:ring focus:ring-[#558B2F]/20 transition-all"
                                   placeholder="John Doe"
                                   required>
                            @error('name')
                                <p class="text-red-500 text-sm flex items-center gap-1">
                                    <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z" clip-rule="evenodd"/>
                                    </svg>
                                    {{ $message }}
                                </p>
                            @enderror
                        </div>

                        <!-- Phone Field -->
                        <div class="space-y-2">
                            <label for="phone" class="text-sm font-semibold text-gray-700 flex items-center gap-2">
                                <span class="text-[#558B2F]">📞</span> Phone
                            </label>
                            <input type="tel" 
                                   name="phone" 
                                   id="phone" 
                                   value="{{ old('phone') }}"
                                   class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:border-[#558B2F] focus:ring focus:ring-[#558B2F]/20 transition-all"
                                   placeholder="+94 77 123 4567">
                            @error('phone')
                                <p class="text-red-500 text-sm flex items-center gap-1">
                                    <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z" clip-rule="evenodd"/>
                                    </svg>
                                    {{ $message }}
                                </p>
                            @enderror
                        </div>
                    </div>

                    <!-- Email Field -->
                    <div class="space-y-2">
                        <label for="email" class="text-sm font-semibold text-gray-700 flex items-center gap-2">
                            <span class="text-[#558B2F]">✉️</span> Email Address
                        </label>
                        <input type="email" 
                               name="email" 
                               id="email" 
                               value="{{ old('email') }}"
                               class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:border-[#558B2F] focus:ring focus:ring-[#558B2F]/20 transition-all"
                               placeholder="john@example.com"
                               required>
                        @error('email')
                            <p class="text-red-500 text-sm flex items-center gap-1">
                                <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z" clip-rule="evenodd"/>
                                </svg>
                                {{ $message }}
                            </p>
                        @enderror
                    </div>

                    <!-- Subject Field -->
                    <div class="space-y-2">
                        <label for="subject" class="text-sm font-semibold text-gray-700 flex items-center gap-2">
                            <span class="text-[#558B2F]">📋</span> Subject
                        </label>
                        <input type="text" 
                               name="subject" 
                               id="subject" 
                               value="{{ old('subject') }}"
                               class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:border-[#558B2F] focus:ring focus:ring-[#558B2F]/20 transition-all"
                               placeholder="How can we help?"
                               required>
                        @error('subject')
                            <p class="text-red-500 text-sm flex items-center gap-1">
                                <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z" clip-rule="evenodd"/>
                                </svg>
                                {{ $message }}
                            </p>
                        @enderror
                    </div>

                    <!-- Message Field -->
                    <div class="space-y-2">
                        <label for="message" class="text-sm font-semibold text-gray-700 flex items-center gap-2">
                            <span class="text-[#558B2F]">💭</span> Message
                        </label>
                        <textarea name="message" 
                                  id="message" 
                                  rows="6" 
                                  class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:border-[#558B2F] focus:ring focus:ring-[#558B2F]/20 transition-all resize-none"
                                  placeholder="Write your message here..."
                                  required>{{ old('message') }}</textarea>
                        @error('message')
                            <p class="text-red-500 text-sm flex items-center gap-1">
                                <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z" clip-rule="evenodd"/>
                                </svg>
                                {{ $message }}
                            </p>
                        @enderror
                    </div>

                    <!-- Submit Button -->
                    <button type="submit" 
                            class="w-full px-8 py-4 bg-[#558B2F] hover:bg-[#457025] text-white rounded-md font-bold text-lg shadow-lg transition-all duration-300 transform hover:scale-105 flex items-center justify-center gap-2 uppercase tracking-widest">
                        <span>Send Message</span>
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M14 5l7 7m0 0l-7 7m7-7H3"/>
                        </svg>
                    </button>
                </form>
            </div>

            <!-- Contact Information -->
            <div class="space-y-8">
                <!-- Info Header -->
                <div class="bg-gradient-to-br from-[#558B2F]/10 to-white rounded-2xl p-8 border border-[#558B2F]/20">
                    <span class="inline-block px-4 py-2 bg-[#558B2F] text-white rounded-full text-sm font-semibold mb-4">ℹ️ Information</span>
                    <h2 class="text-4xl font-bold text-gray-900 mb-4 font-display">Contact Information</h2>
                    <p class="text-gray-600 text-lg leading-relaxed">
                        Experience tranquility and sustainable living in harmony with nature. We are always here to help you plan your perfect eco-friendly getaway.
                    </p>
                </div>

                <!-- Contact Cards -->
                <div class="space-y-4">
                    <!-- Address Card -->
                    <div class="group bg-white rounded-2xl p-6 shadow-lg hover:shadow-2xl transition-all duration-300 border border-gray-100 hover:border-[#558B2F]/30">
                        <div class="flex items-start gap-4">
                            <div class="w-14 h-14 bg-[#558B2F] rounded-xl flex items-center justify-center flex-shrink-0 group-hover:scale-110 group-hover:rotate-6 transition-transform duration-300">
                                <svg class="w-7 h-7 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"/>
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"/>
                                </svg>
                            </div>
                            <div class="flex-1">
                                <h3 class="text-xl font-bold text-gray-900 mb-2">Our Location</h3>
                                <p class="text-gray-600">123 Serenity Lane, Suite 101<br>Colombo, Sri Lanka</p>
                            </div>
                        </div>
                    </div>

                    <!-- Phone Card -->
                    <div class="group bg-white rounded-2xl p-6 shadow-lg hover:shadow-2xl transition-all duration-300 border border-gray-100 hover:border-[#558B2F]/30">
                        <div class="flex items-start gap-4">
                            <div class="w-14 h-14 bg-[#558B2F] rounded-xl flex items-center justify-center flex-shrink-0 group-hover:scale-110 group-hover:rotate-6 transition-transform duration-300">
                                <svg class="w-7 h-7 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"/>
                                </svg>
                            </div>
                            <div class="flex-1">
                                <h3 class="text-xl font-bold text-gray-900 mb-2">Phone Number</h3>
                                <a href="tel:+94112345678" class="text-gray-600 hover:text-[#558B2F] transition-colors block">
                                    +94 11 234 5678
                                </a>
                                <a href="tel:+94771234567" class="text-gray-600 hover:text-[#558B2F] transition-colors block">
                                    +94 77 123 4567
                                </a>
                            </div>
                        </div>
                    </div>

                    <!-- Email Card -->
                    <div class="group bg-white rounded-2xl p-6 shadow-lg hover:shadow-2xl transition-all duration-300 border border-gray-100 hover:border-[#8bc34a]/30">
                        <div class="flex items-start gap-4">
                            <div class="w-14 h-14 bg-[#8bc34a] rounded-xl flex items-center justify-center flex-shrink-0 group-hover:scale-110 group-hover:rotate-6 transition-transform duration-300">
                                <svg class="w-7 h-7 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/>
                                </svg>
                            </div>
                            <div class="flex-1">
                                <h3 class="text-xl font-bold text-gray-900 mb-2">Email Address</h3>
                                <a href="mailto:info@70secovillage.com" class="text-gray-600 hover:text-[#558B2F] transition-colors block">
                                    info@70secovillage.com
                                </a>
                                <a href="mailto:reservations@70secovillage.com" class="text-gray-600 hover:text-[#558B2F] transition-colors block">
                                    reservations@70secovillage.com
                                </a>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Map Section -->
                <div class="relative rounded-2xl overflow-hidden shadow-2xl h-80 group">
                    <img src="{{ asset('storage/gallery/VUBYDDISB1tlkG11eMasDIxqHw7v4Az3Pu6eFTSq.jpg') }}" 
                         alt="Location Map" 
                         class="w-full h-full object-cover group-hover:scale-110 transition-transform duration-700">
                    <div class="absolute inset-0 bg-gradient-to-t from-black/60 to-transparent flex items-end p-8">
                        <div class="w-full">
                            <h3 class="text-white text-2xl font-bold mb-4 font-display">Find Us Here</h3>
                            <a href="https://maps.google.com" target="_blank" class="inline-flex items-center px-6 py-3 bg-[#558B2F] hover:bg-[#467526] text-white rounded-md font-bold transition-all duration-300 transform hover:scale-105 gap-2 uppercase tracking-widest text-sm">
                                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"/>
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"/>
                                </svg>
                                View on Google Maps
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Quick Connect Section -->
<section class="py-20 bg-gray-50">
    <div class="container mx-auto px-6">
        <div class="text-center mb-12">
            <span class="inline-block px-4 py-2 bg-[#558B2F]/10 text-[#558B2F] rounded-full text-sm font-semibold mb-4">🚀 Quick Connect</span>
            <h2 class="text-4xl font-bold text-gray-900 mb-4 font-display">Other Ways to Reach Us</h2>
            <p class="text-gray-600 text-lg max-w-2xl mx-auto">Choose your preferred method of communication</p>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-3 gap-8 max-w-5xl mx-auto">
            <!-- WhatsApp -->
            <a href="https://wa.me/94112345678" target="_blank" class="group bg-white rounded-2xl p-8 shadow-lg hover:shadow-2xl transition-all duration-300 text-center border border-gray-100 hover:border-[#558B2F]/30">
                <div class="w-20 h-20 bg-gradient-to-br from-[#558B2F] to-[#3d6320] rounded-2xl flex items-center justify-center mx-auto mb-6 group-hover:scale-110 group-hover:rotate-6 transition-transform duration-300">
                    <svg class="w-10 h-10 text-white" fill="currentColor" viewBox="0 0 24 24">
                        <path d="M17.472 14.382c-.297-.149-1.758-.867-2.03-.967-.273-.099-.471-.148-.67.15-.197.297-.767.966-.94 1.164-.173.199-.347.223-.644.075-.297-.15-1.255-.463-2.39-1.475-.883-.788-1.48-1.761-1.653-2.059-.173-.297-.018-.458.13-.606.134-.133.298-.347.446-.52.149-.174.198-.298.298-.497.099-.198.05-.371-.025-.52-.075-.149-.669-1.612-.916-2.207-.242-.579-.487-.5-.669-.51-.173-.008-.371-.01-.57-.01-.198 0-.52.074-.792.372-.272.297-1.04 1.016-1.04 2.479 0 1.462 1.065 2.875 1.213 3.074.149.198 2.096 3.2 5.077 4.487.709.306 1.262.489 1.694.625.712.227 1.36.195 1.871.118.571-.085 1.758-.719 2.006-1.413.248-.694.248-1.289.173-1.413-.074-.124-.272-.198-.57-.347m-5.421 7.403h-.004a9.87 9.87 0 01-5.031-1.378l-.361-.214-3.741.982.998-3.648-.235-.374a9.86 9.86 0 01-1.51-5.26c.001-5.45 4.436-9.884 9.888-9.884 2.64 0 5.122 1.03 6.988 2.898a9.825 9.825 0 012.893 6.994c-.003 5.45-4.437 9.884-9.885 9.884m8.413-18.297A11.815 11.815 0 0012.05 0C5.495 0 .16 5.335.157 11.892c0 2.096.547 4.142 1.588 5.945L.057 24l6.305-1.654a11.882 11.882 0 005.683 1.448h.005c6.554 0 11.89-5.335 11.893-11.893a11.821 11.821 0 00-3.48-8.413Z"/>
                    </svg>
                </div>
                <h3 class="text-xl font-bold text-gray-900 mb-2">WhatsApp</h3>
                <p class="text-gray-600 mb-4">Chat with us instantly</p>
                <span class="text-[#558B2F] font-semibold group-hover:underline">Start Chat →</span>
            </a>

            <!-- Social Media -->
            <div class="group bg-white rounded-2xl p-8 shadow-lg hover:shadow-2xl transition-all duration-300 text-center border border-gray-100 hover:border-[#558B2F]/30">
                <div class="w-20 h-20 bg-[#558B2F] rounded-2xl flex items-center justify-center mx-auto mb-6 group-hover:scale-110 group-hover:rotate-6 transition-transform duration-300">
                    <svg class="w-10 h-10 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8h2a2 2 0 012 2v6a2 2 0 01-2 2h-2v4l-4-4H9a1.994 1.994 0 01-1.414-.586m0 0L11 14h4a2 2 0 002-2V6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2v4l.586-.586z"/>
                    </svg>
                </div>
                <h3 class="text-xl font-bold text-gray-900 mb-2">Social Media</h3>
                <p class="text-gray-600 mb-4">Follow & message us</p>
                <div class="flex justify-center gap-3">
                    <a href="#" class="w-10 h-10 bg-gray-100 hover:bg-[#558B2F] text-gray-500 hover:text-white rounded-lg flex items-center justify-center transition-all hover:scale-110">
                        <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24"><path d="M9 8h-3v4h3v12h5v-12h3.642l.358-4h-4v-1.667c0-.955.192-1.333 1.115-1.333h2.885v-5h-3.808c-3.596 0-5.192 1.583-5.192 4.615v3.385z"/></svg>
                    </a>
                    <a href="#" class="w-10 h-10 bg-gray-100 hover:bg-[#558B2F] text-gray-500 hover:text-white rounded-lg flex items-center justify-center transition-all hover:scale-110">
                        <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24"><path d="M12 2.163c3.204 0 3.584.012 4.85.07 3.252.148 4.771 1.691 4.919 4.919.058 1.265.069 1.645.069 4.849 0 3.205-.012 3.584-.069 4.849-.149 3.225-1.664 4.771-4.919 4.919-1.266.058-1.644.07-4.85.07-3.204 0-3.584-.012-4.849-.07-3.26-.149-4.771-1.699-4.919-4.92-.058-1.265-.07-1.644-.07-4.849 0-3.204.013-3.583.07-4.849.149-3.227 1.664-4.771 4.919-4.919 1.266-.057 1.645-.069 4.849-.069zm0-2.163c-3.259 0-3.667.014-4.947.072-4.358.2-6.78 2.618-6.98 6.98-.059 1.281-.073 1.689-.073 4.948 0 3.259.014 3.668.072 4.948.2 4.358 2.618 6.78 6.98 6.98 1.281.058 1.689.072 4.948.072 3.259 0 3.668-.014 4.948-.072 4.354-.2 6.782-2.618 6.979-6.98.059-1.28.073-1.689.073-4.949 0-3.259-.014-3.667-.072-4.947-.196-4.354-2.617-6.78-6.979-6.98-1.281-.059-1.69-.073-4.949-.073zm0 5.838c-3.403 0-6.162 2.759-6.162 6.162s2.759 6.163 6.162 6.163 6.162-2.759 6.162-6.163c0-3.403-2.759-6.162-6.162-6.162zm0 10.162c-2.209 0-4-1.79-4-4 0-2.209 1.791-4 4-4s4 1.791 4 4c0 2.21-1.791 4-4 4zm6.406-11.845c-.796 0-1.441.645-1.441 1.44s.645 1.44 1.441 1.44c.795 0 1.439-.645 1.439-1.44s-.644-1.44-1.439-1.44z"/></svg>
                    </a>
                    <a href="#" class="w-10 h-10 bg-gray-100 hover:bg-[#558B2F] text-gray-500 hover:text-white rounded-lg flex items-center justify-center transition-all hover:scale-110">
                        <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24"><path d="M24 4.557c-.883.392-1.832.656-2.828.775 1.017-.609 1.798-1.574 2.165-2.724-.951.564-2.005.974-3.127 1.195-.897-.957-2.178-1.555-3.594-1.555-3.179 0-5.515 2.966-4.797 6.045-4.091-.205-7.719-2.165-10.148-5.144-1.29 2.213-.669 5.108 1.523 6.574-.806-.026-1.566-.247-2.229-.616-.054 2.281 1.581 4.415 3.949 4.89-.693.188-1.452.232-2.224.084.626 1.956 2.444 3.379 4.6 3.419-2.07 1.623-4.678 2.348-7.29 2.04 2.179 1.397 4.768 2.212 7.548 2.212 9.142 0 14.307-7.721 13.995-14.646.962-.695 1.797-1.562 2.457-2.549z"/></svg>
                    </a>
                </div>
            </div>

            <!-- Live Chat -->
            <a href="#" class="group bg-white rounded-2xl p-8 shadow-lg hover:shadow-2xl transition-all duration-300 text-center border border-gray-100 hover:border-[#558B2F]/30">
                <div class="w-20 h-20 bg-[#8bc34a] rounded-2xl flex items-center justify-center mx-auto mb-6 group-hover:scale-110 group-hover:rotate-6 transition-transform duration-300">
                    <svg class="w-10 h-10 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 10h.01M12 10h.01M16 10h.01M9 16H5a2 2 0 01-2-2V6a2 2 0 012-2h14a2 2 0 012 2v8a2 2 0 01-2 2h-5l-5 5v-5z"/>
                    </svg>
                </div>
                <h3 class="text-xl font-bold text-gray-900 mb-2">Live Chat</h3>
                <p class="text-gray-600 mb-4">Get instant support</p>
                <span class="text-[#558B2F] font-semibold group-hover:underline">Start Chat →</span>
            </a>
        </div>
    </div>
</section>

<!-- FAQ Section -->
<section class="py-20 bg-white">
    <div class="container mx-auto px-6">
        <div class="text-center mb-12">
            <span class="inline-block px-4 py-2 bg-[#558B2F]/10 text-[#558B2F] rounded-full text-sm font-semibold mb-4">❓ FAQ</span>
            <h2 class="text-4xl font-bold text-gray-900 mb-4 font-display">Frequently Asked Questions</h2>
            <p class="text-gray-600 text-lg max-w-2xl mx-auto">Quick answers to common questions about 70's Eco Village</p>
        </div>

        <div class="max-w-3xl mx-auto space-y-4">
            <!-- FAQ Item 1 -->
            <div class="bg-gradient-to-br from-gray-50 to-white rounded-2xl border border-gray-200 overflow-hidden">
                <button class="w-full px-6 py-5 text-left flex items-center justify-between hover:bg-gray-50 transition-colors" onclick="this.nextElementSibling.classList.toggle('hidden')">
                    <span class="font-bold text-gray-900 text-lg">What are your check-in and check-out times?</span>
                    <svg class="w-6 h-6 text-[#558B2F] transform transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                    </svg>
                </button>
                <div class="hidden px-6 pb-5">
                    <p class="text-gray-600 leading-relaxed">Check-in time is from 2:00 PM onwards, and check-out time is until 12:00 PM. Early check-in and late check-out may be available upon request and subject to availability.</p>
                </div>
            </div>

            <!-- FAQ Item 2 -->
            <div class="bg-gradient-to-br from-gray-50 to-white rounded-2xl border border-gray-200 overflow-hidden">
                <button class="w-full px-6 py-5 text-left flex items-center justify-between hover:bg-gray-50 transition-colors" onclick="this.nextElementSibling.classList.toggle('hidden')">
                    <span class="font-bold text-gray-900 text-lg">Do you offer airport transportation?</span>
                    <svg class="w-6 h-6 text-[#558B2F] transform transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                    </svg>
                </button>
                <div class="hidden px-6 pb-5">
                    <p class="text-gray-600 leading-relaxed">Yes, we provide airport pickup and drop-off services for an additional fee. Please contact us at least 24 hours in advance to arrange transportation.</p>
                </div>
            </div>

            <!-- FAQ Item 3 -->
            <div class="bg-gradient-to-br from-gray-50 to-white rounded-2xl border border-gray-200 overflow-hidden">
                <button class="w-full px-6 py-5 text-left flex items-center justify-between hover:bg-gray-50 transition-colors" onclick="this.nextElementSibling.classList.toggle('hidden')">
                    <span class="font-bold text-gray-900 text-lg">Are pets allowed at the eco village?</span>
                    <svg class="w-6 h-6 text-[#558B2F] transform transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                    </svg>
                </button>
                <div class="hidden px-6 pb-5">
                    <p class="text-gray-600 leading-relaxed">We welcome well-behaved pets in select accommodations. A pet fee applies, and we ask that you inform us in advance so we can prepare the appropriate room for you and your furry friend.</p>
                </div>
            </div>

            <!-- FAQ Item 4 -->
            <div class="bg-gradient-to-br from-gray-50 to-white rounded-2xl border border-gray-200 overflow-hidden">
                <button class="w-full px-6 py-5 text-left flex items-center justify-between hover:bg-gray-50 transition-colors" onclick="this.nextElementSibling.classList.toggle('hidden')">
                    <span class="font-bold text-gray-900 text-lg">What sustainable practices do you follow?</span>
                    <svg class="w-6 h-6 text-[#558B2F] transform transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                    </svg>
                </button>
                <div class="hidden px-6 pb-5">
                    <p class="text-gray-600 leading-relaxed">We're committed to sustainability through solar power, rainwater harvesting, organic farming, zero-waste initiatives, and plastic-free operations. We also use eco-friendly cleaning products and support local communities.</p>
                </div>
            </div>

            <!-- FAQ Item 5 -->
            <div class="bg-gradient-to-br from-gray-50 to-white rounded-2xl border border-gray-200 overflow-hidden">
                <button class="w-full px-6 py-5 text-left flex items-center justify-between hover:bg-gray-50 transition-colors" onclick="this.nextElementSibling.classList.toggle('hidden')">
                    <span class="font-bold text-gray-900 text-lg">Is WiFi available throughout the property?</span>
                    <svg class="w-6 h-6 text-[#558B2F] transform transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                    </svg>
                </button>
                <div class="hidden px-6 pb-5">
                    <p class="text-gray-600 leading-relaxed">Yes, complimentary high-speed WiFi is available in all rooms and common areas. However, we encourage our guests to disconnect and immerse themselves in nature during their stay.</p>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Office Hours Section -->
<section class="py-20 bg-gradient-to-br from-[#3d6320] via-[#558B2F] to-[#4a7a28] relative overflow-hidden">
    <div class="absolute inset-0 opacity-10">
        <div class="absolute top-0 left-1/4 w-96 h-96 bg-white rounded-full filter blur-3xl animate-pulse"></div>
        <div class="absolute bottom-0 right-1/4 w-96 h-96 bg-white rounded-full filter blur-3xl animate-pulse animation-delay-2000"></div>
    </div>

    <div class="container mx-auto px-6 relative z-10">
        <div class="max-w-4xl mx-auto text-center">
            <div class="inline-flex items-center gap-2 px-4 py-2 bg-white/20 backdrop-blur-md rounded-full border border-white/20 mb-6">
               
                <span class="text-white/90 text-sm font-medium uppercase tracking-widest">Operating Hours</span>
            </div>
            
            <h2 class="text-5xl font-bold text-white mb-8 font-display">We're Here to Help</h2>
            <p class="text-xl text-white/90 mb-12">Our team is available during the following hours</p>

            <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                <!-- Reception -->
                <div class="bg-white/10 backdrop-blur-md rounded-2xl p-6 border border-white/20">
                    <div class="w-16 h-16 bg-white/20 rounded-xl flex items-center justify-center mx-auto mb-4">
                        <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"/>
                        </svg>
                    </div>
                    <h3 class="text-xl font-bold text-white mb-2">Reception</h3>
                    <p class="text-white/80">24/7 Available</p>
                </div>

                <!-- Restaurant -->
                <div class="bg-white/10 backdrop-blur-md rounded-2xl p-6 border border-white/20">
                    <div class="w-16 h-16 bg-white/20 rounded-xl flex items-center justify-center mx-auto mb-4">
                        <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"/>
                        </svg>
                    </div>
                    <h3 class="text-xl font-bold text-white mb-2">Restaurant</h3>
                    <p class="text-white/80">7:00 AM - 11:00 PM</p>
                </div>

                <!-- Spa -->
                <div class="bg-white/10 backdrop-blur-md rounded-2xl p-6 border border-white/20">
                    <div class="w-16 h-16 bg-white/20 rounded-xl flex items-center justify-center mx-auto mb-4">
                        <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z"/>
                        </svg>
                    </div>
                    <h3 class="text-xl font-bold text-white mb-2">Spa & Wellness</h3>
                    <p class="text-white/80">9:00 AM - 9:00 PM</p>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Custom Animation Styles -->
<style>
@keyframes blob {
    0% { transform: translate(0px, 0px) scale(1); }
    33% { transform: translate(30px, -50px) scale(1.1); }
    66% { transform: translate(-20px, 20px) scale(0.9); }
    100% { transform: translate(0px, 0px) scale(1); }
}

.animate-blob {
    animation: blob 7s infinite;
}

.animation-delay-2000 {
    animation-delay: 2s;
}

.animation-delay-4000 {
    animation-delay: 4s;
}

@keyframes fade-in-down {
    0% {
        opacity: 0;
        transform: translateY(-20px);
    }
    100% {
        opacity: 1;
        transform: translateY(0);
    }
}

@keyframes fade-in-up {
    0% {
        opacity: 0;
        transform: translateY(20px);
    }
    100% {
        opacity: 1;
        transform: translateY(0);
    }
}

.animate-fade-in-down {
    animation: fade-in-down 0.6s ease-out;
}

.animate-fade-in-up {
    animation: fade-in-up 0.6s ease-out;
}

.animation-delay-200 {
    animation-delay: 0.2s;
    animation-fill-mode: both;
}
</style>

@endsection