<canvas id="snow-canvas" class="fixed inset-0 pointer-events-none z-[9999]"></canvas>

<script>
    (function() {
        const canvas = document.getElementById('snow-canvas');
        if (!canvas) return;

        const ctx = canvas.getContext('2d');
        let width, height, snowflakes;

        function init() {
            width = window.innerWidth;
            height = window.innerHeight;
            canvas.width = width;
            canvas.height = height;
            
            snowflakes = [];
            const count = Math.floor(width / 10); // Adjust density based on screen width
            
            for (let i = 0; i < count; i++) {
                snowflakes.push({
                    x: Math.random() * width,
                    y: Math.random() * height,
                    radius: Math.random() * 3 + 1,
                    speed: Math.random() * 1 + 0.5,
                    wind: Math.random() * 0.5 - 0.25,
                    opacity: Math.random() * 0.6 + 0.4
                });
            }
        }

        function draw() {
            ctx.clearRect(0, 0, width, height);
            
            snowflakes.forEach(s => {
                ctx.beginPath();
                ctx.arc(s.x, s.y, s.radius, 0, Math.PI * 2);
                
                // Light blue color for the snowflake
                ctx.shadowBlur = 6;
                ctx.shadowColor = 'rgba(173, 216, 230, 0.8)'; // LightBlue shadow
                
                ctx.fillStyle = `rgba(173, 216, 230, ${s.opacity})`; // LightBlue fill
                ctx.fill();
                
                s.y += s.speed;
                s.x += s.wind;
                
                // Wrap around
                if (s.y > height) {
                    s.y = -s.radius;
                    s.x = Math.random() * width;
                }
                if (s.x > width) s.x = 0;
                if (s.x < 0) s.x = width;
            });
            
            requestAnimationFrame(draw);
        }

        window.addEventListener('resize', init);
        init();
        draw();
        
        console.log('Christmas snow initialized (Canvas Mode)');
    })();
</script>
