<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Booking Confirmation - MHEC Hotel</title>
    @vite(['resources/css/app.css', 'resources/js/app.js'])
</head>
<body class="antialiased bg-gray-50">
    <!-- Navigation -->
    <nav class="bg-white shadow-lg">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex justify-between h-20">
                <div class="flex items-center">
                    <a href="{{ route('home') }}">
                        <h1 class="text-3xl font-bold text-blue-600">MHEC Hotel</h1>
                    </a>
                </div>
                <div class="hidden md:flex items-center space-x-8">
                    <a href="{{ route('home') }}" class="text-gray-700 hover:text-blue-600 font-medium">Home</a>
                    <a href="{{ route('rooms.index') }}" class="text-gray-700 hover:text-blue-600 font-medium">Rooms</a>
                    <a href="{{ route('dashboard') }}" class="text-blue-600 font-medium">My Bookings</a>
                </div>
            </div>
        </div>
    </nav>

    <!-- Confirmation Content -->
    <div class="max-w-3xl mx-auto px-4 sm:px-6 lg:px-8 py-16">
        <!-- Success Icon -->
        <div class="text-center mb-8">
            <div class="inline-flex items-center justify-center w-24 h-24 bg-green-100 rounded-full mb-4">
                <svg class="w-12 h-12 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                </svg>
            </div>
            <h1 class="text-4xl font-bold text-gray-900 mb-2">Booking Confirmed!</h1>
            <p class="text-xl text-gray-600">Your reservation has been successfully created</p>
        </div>

        <!-- Booking Details Card -->
        <div class="bg-white rounded-lg shadow-lg overflow-hidden mb-8">
            <div class="bg-blue-600 text-white px-6 py-4">
                <h2 class="text-2xl font-bold">Booking Details</h2>
                <p class="text-blue-100">Booking ID: #{{ $booking->id }}</p>
            </div>
            
            <div class="p-6">
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
                    <div>
                        <p class="text-sm text-gray-600 mb-1">Guest Name</p>
                        <p class="text-lg font-semibold text-gray-900">{{ $booking->user->name }}</p>
                    </div>
                    <div>
                        <p class="text-sm text-gray-600 mb-1">Email</p>
                        <p class="text-lg font-semibold text-gray-900">{{ $booking->user->email }}</p>
                    </div>
                </div>

                <div class="border-t border-gray-200 pt-6 mb-6">
                    <h3 class="text-xl font-bold text-gray-900 mb-4">Room Information</h3>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <p class="text-sm text-gray-600 mb-1">Room</p>
                            <p class="text-lg font-semibold text-gray-900">{{ $booking->room->name }}</p>
                        </div>
                        <div>
                            <p class="text-sm text-gray-600 mb-1">Room Type</p>
                            <p class="text-lg font-semibold text-gray-900">{{ $booking->room->type }}</p>
                        </div>
                    </div>
                </div>

                <div class="border-t border-gray-200 pt-6 mb-6">
                    <h3 class="text-xl font-bold text-gray-900 mb-4">Stay Details</h3>
                    <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                        <div>
                            <p class="text-sm text-gray-600 mb-1">Check-in</p>
                            <p class="text-lg font-semibold text-gray-900">{{ \Carbon\Carbon::parse($booking->check_in)->format('M d, Y') }}</p>
                        </div>
                        <div>
                            <p class="text-sm text-gray-600 mb-1">Check-out</p>
                            <p class="text-lg font-semibold text-gray-900">{{ \Carbon\Carbon::parse($booking->check_out)->format('M d, Y') }}</p>
                        </div>
                        <div>
                            <p class="text-sm text-gray-600 mb-1">Duration</p>
                            <p class="text-lg font-semibold text-gray-900">{{ \Carbon\Carbon::parse($booking->check_in)->diffInDays($booking->check_out) }} nights</p>
                        </div>
                    </div>
                </div>

                <div class="border-t border-gray-200 pt-6">
                    <div class="flex justify-between items-center mb-2">
                        <span class="text-gray-600">Total Amount</span>
                        <span class="text-3xl font-bold text-blue-600">LKR {{ number_format($booking->total_price, 2) }}</span>
                    </div>
                    <div class="flex justify-between items-center">
                        <span class="text-gray-600">Payment Status</span>
                        <span class="px-4 py-2 bg-yellow-100 text-yellow-800 rounded-full font-semibold">{{ ucfirst($booking->payment_status) }}</span>
                    </div>
                </div>
            </div>
        </div>

        <!-- Important Information -->
        <div class="bg-blue-50 border-l-4 border-blue-600 p-6 mb-8">
            <h3 class="text-lg font-bold text-blue-900 mb-2">Important Information</h3>
            <ul class="text-blue-800 space-y-2">
                <li class="flex items-start">
                    <svg class="w-5 h-5 mr-2 mt-0.5" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
                    </svg>
                    <span>A confirmation email has been sent to your registered email address</span>
                </li>
                <li class="flex items-start">
                    <svg class="w-5 h-5 mr-2 mt-0.5" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
                    </svg>
                    <span>Check-in time is 2:00 PM and check-out time is 12:00 PM</span>
                </li>
                <li class="flex items-start">
                    <svg class="w-5 h-5 mr-2 mt-0.5" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
                    </svg>
                    <span>Please bring a valid ID for verification at check-in</span>
                </li>
            </ul>
        </div>

        <!-- Action Buttons -->
        <div class="flex flex-col sm:flex-row gap-4">
            <a href="{{ route('dashboard') }}" class="flex-1 bg-blue-600 text-white text-center py-3 rounded-lg font-semibold hover:bg-blue-700 transition">
                View My Bookings
            </a>
            <a href="{{ route('home') }}" class="flex-1 bg-white border-2 border-gray-300 text-gray-700 text-center py-3 rounded-lg font-semibold hover:bg-gray-50 transition">
                Back to Home
            </a>
        </div>
    </div>

    <!-- Footer -->
    <footer class="bg-gray-900 text-white py-12 mt-16">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
            <p>&copy; {{ date('Y') }} MHEC Hotel. All rights reserved.</p>
        </div>
    </footer>
</body>
</html>
