<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Booking Confirmation</title>
    <style>
        body {
            font-family: 'Helvetica Neue', Helvetica, Arial, sans-serif;
            margin: 0;
            padding: 0;
            background-color: #f4f6f8;
            color: #333333;
            line-height: 1.6;
        }
        .container {
            max-width: 600px;
            margin: 40px auto;
            background-color: #ffffff;
            border-radius: 12px;
            overflow: hidden;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.05);
        }
        .header {
            background-color: #558B2F;
            padding: 30px 20px;
            text-align: center;
        }
        .header h1 {
            color: #ffffff;
            margin: 0;
            font-size: 24px;
            font-weight: 700;
            letter-spacing: 1px;
            text-transform: uppercase;
        }
        .content {
            padding: 40px 30px;
        }
        .greeting {
            font-size: 20px;
            font-weight: 600;
            color: #2c3e50;
            margin-bottom: 20px;
        }
        .message {
            color: #555555;
            margin-bottom: 30px;
        }
        .booking-details {
            background-color: #f9fafb;
            border-radius: 8px;
            padding: 25px;
            border: 1px solid #eef2f6;
        }
        .detail-row {
            display: flex;
            justify-content: space-between;
            padding: 12px 0;
            border-bottom: 1px solid #e0e0e0;
        }
        .detail-row:last-child {
            border-bottom: none;
        }
        .detail-label {
            font-weight: 600;
            color: #7f8c8d;
        }
        .detail-value {
            font-weight: 600;
            color: #2c3e50;
        }
        .total-price {
            margin-top: 20px;
            text-align: center;
            background-color: #e8f5e9;
            color: #2e7d32;
            padding: 15px;
            border-radius: 6px;
            font-size: 18px;
            font-weight: bold;
        }
        .footer {
            background-color: #f4f6f8;
            padding: 20px;
            text-align: center;
            font-size: 12px;
            color: #95a5a6;
            border-top: 1px solid #eef2f6;
        }
        .btn {
            display: inline-block;
            background-color: #558B2F;
            color: white;
            text-decoration: none;
            padding: 12px 25px;
            border-radius: 6px;
            font-weight: bold;
            margin-top: 25px;
            text-align: center;
        }
        @media only screen and (max-width: 600px) {
            .container {
                width: 100% !important;
                margin: 0 !important;
                border-radius: 0 !important;
            }
            .content {
                padding: 20px !important;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>70's Eco Village</h1>
        </div>
        
        <div class="content">
            <div class="greeting">Hello {{ $booking->user->name }},</div>
            <p class="message">
                Great news! Your booking has been successfully confirmed. We are thrilled to have you stay with us.
            </p>

            <div class="booking-details">
                
                <div class="detail-row">
                    <span class="detail-label">Room Type</span>
                    <span class="detail-value">{{ $booking->room->name ?? 'N/A' }}</span>
                </div>
                <div class="detail-row">
                    <span class="detail-label">Check-in</span>
                    <span class="detail-value">{{ \Carbon\Carbon::parse($booking->check_in)->format('M d, Y') }}</span>
                </div>
                <div class="detail-row">
                    <span class="detail-label">Check-out</span>
                    <span class="detail-value">{{ \Carbon\Carbon::parse($booking->check_out)->format('M d, Y') }}</span>
                </div>
                <div class="detail-row">
                    <span class="detail-label">Nights</span>
                    <span class="detail-value">{{ \Carbon\Carbon::parse($booking->check_in)->diffInDays($booking->check_out) }}</span>
                </div>
            </div>

            <div class="total-price">
                Total Price: LKR {{ number_format($booking->total_price, 2) }}
            </div>

            <div style="text-align: center;">
                <a href="{{ route('dashboard') }}" class="btn">View My Booking</a>
            </div>
        </div>

        <div class="footer">
            <p>&copy; {{ date('Y') }} 70's Eco Village. All rights reserved.</p>
            <p>If you have any questions, please contact us at support@70secovillage.com</p>
        </div>
    </div>
</body>
</html>
