@extends('layouts.guest')

@section('content')
<section class="relative min-h-screen flex items-center justify-center overflow-hidden bg-gradient-to-br from-emerald-950 via-slate-900 to-emerald-900">
    <!-- Animated Background Elements -->
    <div class="absolute inset-0 z-0">
        <!-- Modern Pattern Overlay -->
        <div class="absolute inset-0 opacity-10" style="background-image: radial-gradient(circle at 2px 2px, rgba(255,255,255,0.15) 1px, transparent 0); background-size: 40px 40px;"></div>
        
        <!-- Animated Blobs -->
        <div class="absolute top-0 -left-4 w-96 h-96 bg-emerald-500 rounded-full mix-blend-multiply filter blur-3xl opacity-20 animate-blob"></div>
        <div class="absolute top-0 -right-4 w-96 h-96 bg-amber-500 rounded-full mix-blend-multiply filter blur-3xl opacity-20 animate-blob animation-delay-2000"></div>
        <div class="absolute -bottom-8 left-20 w-96 h-96 bg-emerald-500 rounded-full mix-blend-multiply filter blur-3xl opacity-20 animate-blob animation-delay-4000"></div>
    </div>

    <!-- Floating Particles -->
    <div class="absolute inset-0 overflow-hidden pointer-events-none z-0">
        <div class="particle-float absolute w-2 h-2 bg-emerald-400/30 rounded-full" style="top: 20%; left: 10%; animation-delay: 0s;"></div>
        <div class="particle-float absolute w-3 h-3 bg-amber-400/20 rounded-full" style="top: 60%; left: 80%; animation-delay: 2s;"></div>
        <div class="particle-float absolute w-2 h-2 bg-emerald-400/40 rounded-full" style="top: 40%; left: 70%; animation-delay: 4s;"></div>
        <div class="particle-float absolute w-2 h-2 bg-white/20 rounded-full" style="top: 10%; left: 30%; animation-delay: 1s;"></div>
        <div class="particle-float absolute w-3 h-3 bg-emerald-500/20 rounded-full" style="top: 80%; left: 20%; animation-delay: 3s;"></div>
    </div>

    <div class="relative z-10 w-full max-w-xl px-6 py-12">
        <!-- Logo & Title Section -->
        <div class="text-center mb-10 animate-fade-in-down">
            <a href="{{ route('home') }}" class="inline-block group mb-6">
                <div class="relative">
                    <div class="absolute inset-0 bg-emerald-500 rounded-3xl blur-xl opacity-20 group-hover:opacity-40 transition-opacity"></div>
                    <img src="{{ asset('images/logo.png') }}" alt="70's Eco Village Logo" class="relative h-24 w-auto object-contain transform group-hover:scale-110 transition-transform duration-500">
                </div>
            </a>
            <h1 class="text-3xl md:text-4xl font-display font-bold text-white mb-3">
                Verify Your <span class="text-transparent bg-clip-text bg-gradient-to-r from-emerald-400 to-amber-400">Email</span>
            </h1>
            <p class="text-emerald-100/60 font-medium tracking-wide">Please check your inbox to continue</p>
        </div>

        <!-- Card -->
        <div class="bg-white/10 backdrop-blur-2xl rounded-[2.5rem] shadow-2xl border border-white/20 p-8 md:p-12 animate-fade-in-up">
            
            <div class="mb-6 text-emerald-100/80 leading-relaxed">
                {{ __('Thanks for signing up! Before getting started, could you verify your email address by clicking on the link we just emailed to you? If you didn\'t receive the email, we will gladly send you another.') }}
            </div>

            @if (session('status') == 'verification-link-sent')
                <div class="mb-6 p-4 bg-emerald-500/20 border-l-4 border-emerald-400 rounded-r-xl">
                    <p class="text-sm text-emerald-100 font-medium">
                        {{ __('A new verification link has been sent to the email address you provided during registration.') }}
                    </p>
                </div>
            @endif

            <div class="flex flex-col gap-4">
                <form method="POST" action="{{ route('verification.send') }}">
                    @csrf

                    <button type="submit" 
                            class="group relative w-full py-4 bg-gradient-to-r from-emerald-500 to-emerald-600 hover:from-emerald-600 hover:to-emerald-700 text-white rounded-2xl font-bold text-lg shadow-xl shadow-emerald-500/30 transition-all duration-300 transform hover:scale-[1.02] active:scale-[0.98] flex items-center justify-center gap-3">
                        <span>{{ __('Resend Verification Email') }}</span>
                        <svg class="w-5 h-5 group-hover:translate-x-1 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/>
                        </svg>
                    </button>
                </form>

                <form method="POST" action="{{ route('logout') }}">
                    @csrf
                    <button type="submit" class="w-full py-3 text-emerald-400 hover:text-white font-semibold transition-colors flex items-center justify-center gap-2 group">
                        <svg class="w-5 h-5 group-hover:-translate-x-1 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1"/>
                        </svg>
                        {{ __('Log Out') }}
                    </button>
                </form>
            </div>
        </div>
    </div>
</section>

<style>
@keyframes blob {
    0% { transform: translate(0px, 0px) scale(1); }
    33% { transform: translate(30px, -50px) scale(1.1); }
    66% { transform: translate(-20px, 20px) scale(0.9); }
    100% { transform: translate(0px, 0px) scale(1); }
}
.animate-blob { animation: blob 10s infinite; }
.animation-delay-2000 { animation-delay: 2s; }
.animation-delay-4000 { animation-delay: 4s; }

@keyframes fade-in-down {
    0% { opacity: 0; transform: translateY(-30px); }
    100% { opacity: 1; transform: translateY(0); }
}
.animate-fade-in-down { animation: fade-in-down 1s ease-out forwards; }

@keyframes fade-in-up {
    0% { opacity: 0; transform: translateY(30px); }
    100% { opacity: 1; transform: translateY(0); }
}
.animate-fade-in-up { animation: fade-in-up 1s ease-out 0.2s forwards; opacity: 0; }

@keyframes particle-float {
    0%, 100% { transform: translateY(0) translateX(0); opacity: 0.3; }
    50% { transform: translateY(-100px) translateX(50px); opacity: 0.6; }
}
.particle-float { animation: particle-float 10s ease-in-out infinite; }
</style>
@endsection
