@extends('layouts.guest')

@section('content')
<section class="relative min-h-screen flex items-center justify-center overflow-hidden bg-gradient-to-br from-[#FBFBFB] via-white to-[#E8F5E9] py-8">
    {{-- Subtle Background Pattern --}}
    <div class="absolute inset-0 opacity-[0.03]" style="background-image: url('data:image/svg+xml,%3Csvg width=\'60\' height=\'60\' viewBox=\'0 0 60 60\' xmlns=\'http://www.w3.org/2000/svg\'%3E%3Cg fill=\'none\' fill-rule=\'evenodd\'%3E%3Cg fill=\'%23558B2F\' fill-opacity=\'1\'%3E%3Cpath d=\'M36 34v-4h-2v4h-4v2h4v4h2v-4h4v-2h-4zm0-30V0h-2v4h-4v2h4v4h2V6h4V4h-4zM6 34v-4H4v4H0v2h4v4h2v-4h4v-2H6zM6 4V0H4v4H0v2h4v4h2V6h4V4H6z\'/%3E%3C/g%3E%3C/g%3E%3C/svg%3E');"></div>
    
    {{-- Decorative Circles --}}
    <div class="absolute top-20 right-20 w-4 h-4 bg-[#558B2F]/30 rounded-full"></div>
    <div class="absolute top-40 right-40 w-2 h-2 bg-[#558B2F]/40 rounded-full"></div>
    <div class="absolute top-32 left-20 w-3 h-3 bg-[#7A9D54]/30 rounded-full"></div>
    <div class="absolute bottom-40 left-32 w-2 h-2 bg-[#558B2F]/25 rounded-full"></div>
    <div class="absolute bottom-20 right-28 w-3 h-3 bg-[#7A9D54]/35 rounded-full"></div>
    <div class="absolute top-1/4 left-1/4 w-2 h-2 bg-[#558B2F]/20 rounded-full"></div>
    <div class="absolute top-1/3 right-1/3 w-3 h-3 bg-[#7A9D54]/25 rounded-full"></div>

    <div class="relative z-10 w-full max-w-lg px-6 py-8">
        {{-- Logo & Header --}}
        <div class="text-center mb-8">
            <a href="{{ route('home') }}" class="inline-block mb-5">
                <img src="{{ asset('images/logo.png') }}" alt="70's Eco Village" class="h-16 w-auto mx-auto hover:scale-105 transition-transform duration-300">
            </a>
            <h1 class="text-3xl md:text-4xl font-display font-bold text-gray-900 mb-2">
                Create <span class="text-[#558B2F]">Account</span>
            </h1>
            <p class="text-gray-500">Join us for exclusive benefits & offers</p>
        </div>

        {{-- Register Card --}}
        <div class="bg-white rounded-[2rem] p-8 md:p-10 border border-gray-200"
             style="box-shadow: 0 25px 80px -12px rgba(85, 139, 47, 0.15), 0 10px 40px -10px rgba(0, 0, 0, 0.08);">
            <form method="POST" action="{{ route('register') }}" class="space-y-5">
                @csrf

                {{-- Name Field --}}
                <div class="space-y-2">
                    <label for="name" class="block text-sm font-bold text-gray-700 uppercase tracking-wide">Full Name</label>
                    <div class="relative group">
                        <span class="absolute left-5 top-1/2 -translate-y-1/2 text-gray-400 group-focus-within:text-[#558B2F] transition-colors">
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"/>
                            </svg>
                        </span>
                        <input id="name" 
                               type="text" 
                               name="name" 
                               value="{{ old('name') }}" 
                               required 
                               autofocus
                               autocomplete="name"
                               class="w-full pl-14 pr-5 py-4 bg-[#F8FAF8] border-2 border-[#E8F5E9] rounded-2xl text-gray-900 placeholder-gray-400 focus:outline-none focus:border-[#558B2F] focus:bg-white transition-all duration-300 text-base"
                               placeholder="John Doe">
                    </div>
                    @error('name')
                        <p class="text-red-500 text-sm flex items-center gap-2">
                            <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z" clip-rule="evenodd"/></svg>
                            {{ $message }}
                        </p>
                    @enderror
                </div>

                {{-- Email Field --}}
                <div class="space-y-2">
                    <label for="email" class="block text-sm font-bold text-gray-700 uppercase tracking-wide">Email Address</label>
                    <div class="relative group">
                        <span class="absolute left-5 top-1/2 -translate-y-1/2 text-gray-400 group-focus-within:text-[#558B2F] transition-colors">
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/>
                            </svg>
                        </span>
                        <input id="email" 
                               type="email" 
                               name="email" 
                               value="{{ old('email') }}" 
                               required
                               autocomplete="email"
                               class="w-full pl-14 pr-5 py-4 bg-[#F8FAF8] border-2 border-[#E8F5E9] rounded-2xl text-gray-900 placeholder-gray-400 focus:outline-none focus:border-[#558B2F] focus:bg-white transition-all duration-300 text-base"
                               placeholder="your@email.com">
                    </div>
                    @error('email')
                        <p class="text-red-500 text-sm flex items-center gap-2">
                            <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z" clip-rule="evenodd"/></svg>
                            {{ $message }}
                        </p>
                    @enderror
                </div>

                {{-- Password Field --}}
                <div class="space-y-2">
                    <label for="password" class="block text-sm font-bold text-gray-700 uppercase tracking-wide">Password</label>
                    <div class="relative group">
                        <span class="absolute left-5 top-1/2 -translate-y-1/2 text-gray-400 group-focus-within:text-[#558B2F] transition-colors">
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"/>
                            </svg>
                        </span>
                        <input id="password" 
                               type="password" 
                               name="password" 
                               required
                               autocomplete="new-password"
                               class="w-full pl-14 pr-14 py-4 bg-[#F8FAF8] border-2 border-[#E8F5E9] rounded-2xl text-gray-900 placeholder-gray-400 focus:outline-none focus:border-[#558B2F] focus:bg-white transition-all duration-300 text-base"
                               placeholder="••••••••">
                        {{-- Show/Hide Toggle --}}
                        <button type="button" onclick="togglePassword('password', this)" class="absolute right-5 top-1/2 -translate-y-1/2 text-gray-400 hover:text-[#558B2F] transition-colors p-1">
                            <svg class="w-5 h-5 eye-open" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"/>
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"/>
                            </svg>
                            <svg class="w-5 h-5 eye-closed hidden" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M13.875 18.825A10.05 10.05 0 0112 19c-4.478 0-8.268-2.943-9.543-7a9.97 9.97 0 011.563-3.029m5.858.908a3 3 0 114.243 4.243M9.878 9.878l4.242 4.242M9.88 9.88l-3.29-3.29m7.532 7.532l3.29 3.29M3 3l3.59 3.59m0 0A9.953 9.953 0 0112 5c4.478 0 8.268 2.943 9.543 7a10.025 10.025 0 01-4.132 5.411m0 0L21 21"/>
                            </svg>
                        </button>
                    </div>
                    @error('password')
                        <p class="text-red-500 text-sm flex items-center gap-2">
                            <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z" clip-rule="evenodd"/></svg>
                            {{ $message }}
                        </p>
                    @enderror
                </div>

                {{-- Confirm Password Field --}}
                <div class="space-y-2">
                    <label for="password_confirmation" class="block text-sm font-bold text-gray-700 uppercase tracking-wide">Confirm Password</label>
                    <div class="relative group">
                        <span class="absolute left-5 top-1/2 -translate-y-1/2 text-gray-400 group-focus-within:text-[#558B2F] transition-colors">
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z"/>
                            </svg>
                        </span>
                        <input id="password_confirmation" 
                               type="password" 
                               name="password_confirmation" 
                               required
                               autocomplete="new-password"
                               class="w-full pl-14 pr-14 py-4 bg-[#F8FAF8] border-2 border-[#E8F5E9] rounded-2xl text-gray-900 placeholder-gray-400 focus:outline-none focus:border-[#558B2F] focus:bg-white transition-all duration-300 text-base"
                               placeholder="••••••••">
                        {{-- Show/Hide Toggle --}}
                        <button type="button" onclick="togglePassword('password_confirmation', this)" class="absolute right-5 top-1/2 -translate-y-1/2 text-gray-400 hover:text-[#558B2F] transition-colors p-1">
                            <svg class="w-5 h-5 eye-open" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"/>
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"/>
                            </svg>
                            <svg class="w-5 h-5 eye-closed hidden" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M13.875 18.825A10.05 10.05 0 0112 19c-4.478 0-8.268-2.943-9.543-7a9.97 9.97 0 011.563-3.029m5.858.908a3 3 0 114.243 4.243M9.878 9.878l4.242 4.242M9.88 9.88l-3.29-3.29m7.532 7.532l3.29 3.29M3 3l3.59 3.59m0 0A9.953 9.953 0 0112 5c4.478 0 8.268 2.943 9.543 7a10.025 10.025 0 01-4.132 5.411m0 0L21 21"/>
                            </svg>
                        </button>
                    </div>
                </div>

                {{-- Submit Button --}}
                <button type="submit" 
                        class="w-full py-5 bg-[#558B2F] hover:bg-[#457025] text-white rounded-2xl font-bold text-lg transition-all duration-300 transform hover:scale-[1.02] active:scale-[0.98] flex items-center justify-center gap-3 mt-4"
                        style="box-shadow: 0 10px 40px -10px rgba(85, 139, 47, 0.5);">
                    <span>Create Account</span>
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2.5" d="M14 5l7 7m0 0l-7 7m7-7H3"/>
                    </svg>
                </button>
            </form>

            {{-- Login Link --}}
            <div class="mt-8 pt-6 border-t border-gray-100 text-center">
                <p class="text-gray-500 text-base">
                    Already have an account? 
                    <a href="{{ route('login') }}" class="font-bold text-[#558B2F] hover:text-[#457025] transition-colors ml-1">
                        Sign In
                    </a>
                </p>
            </div>
        </div>

        {{-- Back Link --}}
        <div class="mt-8 text-center">
            <a href="{{ route('home') }}" class="inline-flex items-center gap-2 text-gray-400 hover:text-[#558B2F] transition-colors group">
                <svg class="w-5 h-5 group-hover:-translate-x-1 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"/>
                </svg>
                Back to Homepage
            </a>
        </div>
    </div>
</section>

<script>
function togglePassword(inputId, button) {
    const input = document.getElementById(inputId);
    const eyeOpen = button.querySelector('.eye-open');
    const eyeClosed = button.querySelector('.eye-closed');
    
    if (input.type === 'password') {
        input.type = 'text';
        eyeOpen.classList.add('hidden');
        eyeClosed.classList.remove('hidden');
    } else {
        input.type = 'password';
        eyeOpen.classList.remove('hidden');
        eyeClosed.classList.add('hidden');
    }
}
</script>
@endsection
