@extends('layouts.guest')

@section('content')
<section class="relative min-h-screen flex items-center justify-center overflow-hidden bg-gradient-to-br from-[#FBFBFB] via-white to-[#E8F5E9]">
    {{-- Subtle Background Pattern --}}
    <div class="absolute inset-0 opacity-[0.03]" style="background-image: url('data:image/svg+xml,%3Csvg width=\'60\' height=\'60\' viewBox=\'0 0 60 60\' xmlns=\'http://www.w3.org/2000/svg\'%3E%3Cg fill=\'none\' fill-rule=\'evenodd\'%3E%3Cg fill=\'%23558B2F\' fill-opacity=\'1\'%3E%3Cpath d=\'M36 34v-4h-2v4h-4v2h4v4h2v-4h4v-2h-4zm0-30V0h-2v4h-4v2h4v4h2V6h4V4h-4zM6 34v-4H4v4H0v2h4v4h2v-4h4v-2H6zM6 4V0H4v4H0v2h4v4h2V6h4V4H6z\'/%3E%3C/g%3E%3C/g%3E%3C/svg%3E');"></div>
    
    {{-- Decorative Circles --}}
    <div class="absolute top-20 right-20 w-4 h-4 bg-[#558B2F]/30 rounded-full"></div>
    <div class="absolute top-40 right-40 w-2 h-2 bg-[#558B2F]/40 rounded-full"></div>
    <div class="absolute top-32 left-20 w-3 h-3 bg-[#7A9D54]/30 rounded-full"></div>
    <div class="absolute bottom-40 left-32 w-2 h-2 bg-[#558B2F]/25 rounded-full"></div>
    <div class="absolute bottom-20 right-28 w-3 h-3 bg-[#7A9D54]/35 rounded-full"></div>
    <div class="absolute top-1/4 left-1/4 w-2 h-2 bg-[#558B2F]/20 rounded-full"></div>
    <div class="absolute top-1/3 right-1/3 w-3 h-3 bg-[#7A9D54]/25 rounded-full"></div>

    <div class="relative z-10 w-full max-w-lg px-6 py-12">
        {{-- Logo & Header --}}
        <div class="text-center mb-10">
            <a href="{{ route('home') }}" class="inline-block mb-6">
                <img src="{{ asset('images/logo.png') }}" alt="70's Eco Village" class="h-20 w-auto mx-auto hover:scale-105 transition-transform duration-300 drop-shadow-lg">
            </a>
            <h1 class="text-4xl md:text-5xl font-display font-bold text-gray-900 mb-3">
                Reset <span class="text-[#558B2F]">Password</span>
            </h1>
            <p class="text-gray-500">Enter your email to receive a password reset link</p>
        </div>

        {{-- Forgot Password Card with Enhanced Shadow --}}
        <div class="bg-white rounded-3xl p-10 md:p-12 shadow-2xl border border-gray-100"
             style="box-shadow: 0 25px 60px -12px rgba(85, 139, 47, 0.2), 0 15px 30px -10px rgba(0, 0, 0, 0.1);">
            
            {{-- Session Status --}}
            @if (session('status'))
                <div class="mb-6 p-5 bg-[#E8F5E9] border-l-4 border-[#558B2F] rounded-xl shadow-sm">
                    <div class="flex items-center gap-3">
                        <svg class="w-6 h-6 text-[#558B2F] flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                        </svg>
                        <p class="text-[#558B2F] font-medium">{{ session('status') }}</p>
                    </div>
                </div>
            @endif

            {{-- Info Message with Icon --}}
            <div class="mb-8 p-5 bg-gradient-to-r from-amber-50 to-orange-50 border border-amber-200 rounded-2xl shadow-sm">
                <div class="flex items-start gap-4">
                    <div class="w-12 h-12 bg-amber-100 rounded-xl flex items-center justify-center flex-shrink-0 shadow-sm">
                        <svg class="w-6 h-6 text-amber-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                        </svg>
                    </div>
                    <div>
                        <h3 class="text-amber-800 font-semibold mb-1">Password Recovery</h3>
                        <p class="text-sm text-amber-700 leading-relaxed">
                            Enter the email address associated with your account and we'll send you a link to reset your password.
                        </p>
                    </div>
                </div>
            </div>

            <form method="POST" action="{{ route('password.email') }}" class="space-y-6">
                @csrf

                {{-- Email Field --}}
                <div class="space-y-3">
                    <label for="email" class="block text-sm font-bold text-gray-700 uppercase tracking-wide">Email Address</label>
                    <div class="relative group">
                        <span class="absolute left-5 top-1/2 -translate-y-1/2 text-gray-400 group-focus-within:text-[#558B2F] transition-colors">
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/>
                            </svg>
                        </span>
                        <input id="email" 
                               type="email" 
                               name="email" 
                               value="{{ old('email') }}" 
                               required 
                               autofocus
                               autocomplete="email"
                               class="w-full pl-14 pr-5 py-4 bg-[#F8FAF8] border-2 border-[#E8F5E9] rounded-2xl text-gray-900 placeholder-gray-400 focus:outline-none focus:border-[#558B2F] focus:bg-white focus:shadow-lg focus:shadow-[#558B2F]/10 transition-all duration-300 text-base"
                               placeholder="your@email.com">
                    </div>
                    @error('email')
                        <p class="text-red-500 text-sm flex items-center gap-2 mt-2">
                            <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z" clip-rule="evenodd"/></svg>
                            {{ $message }}
                        </p>
                    @enderror
                </div>

                {{-- Submit Button --}}
                <button type="submit" 
                        class="w-full py-5 bg-[#558B2F] hover:bg-[#457025] text-white rounded-2xl font-bold text-lg transition-all duration-300 transform hover:scale-[1.02] active:scale-[0.98] flex items-center justify-center gap-3 mt-4 shadow-xl shadow-[#558B2F]/30 hover:shadow-2xl hover:shadow-[#558B2F]/40">
                    <span>Send Reset Link</span>
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2.5" d="M14 5l7 7m0 0l-7 7m7-7H3"/>
                    </svg>
                </button>
            </form>

            {{-- Back to Login Link --}}
            <div class="mt-10 pt-8 border-t border-gray-100 text-center">
                <p class="text-gray-500 text-base flex items-center justify-center gap-2 flex-wrap">
                    <span>Remember your password?</span>
                    <a href="{{ route('login') }}" class="inline-flex items-center gap-1 font-bold text-[#558B2F] hover:text-[#457025] transition-colors group">
                        Back to Login
                        <svg class="w-4 h-4 group-hover:translate-x-1 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"/>
                        </svg>
                    </a>
                </p>
            </div>
        </div>

        {{-- Additional Help --}}
        <div class="mt-8 text-center">
            <p class="text-sm text-gray-400 mb-4">Need more help?</p>
            <a href="{{ route('contact') }}" class="inline-flex items-center gap-2 px-6 py-3 bg-white rounded-xl text-gray-600 hover:text-[#558B2F] font-medium transition-all shadow-md hover:shadow-lg border border-gray-100">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 12h.01M12 12h.01M16 12h.01M21 12c0 4.418-4.03 8-9 8a9.863 9.863 0 01-4.255-.949L3 20l1.395-3.72C3.512 15.042 3 13.574 3 12c0-4.418 4.03-8 9-8s9 3.582 9 8z"/>
                </svg>
                Contact Support
            </a>
        </div>

        {{-- Back Link --}}
        <div class="mt-8 text-center">
            <a href="{{ route('home') }}" class="inline-flex items-center gap-2 text-gray-400 hover:text-[#558B2F] transition-colors group">
                <svg class="w-5 h-5 group-hover:-translate-x-1 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"/>
                </svg>
                Back to Homepage
            </a>
        </div>
    </div>
</section>
@endsection
