@extends('layouts.admin')

@section('content')
    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900">
                    <h2 class="text-2xl font-bold mb-6 border-b pb-2">Edit Room: {{ $room->name }}</h2>
                    
                    <form action="{{ route('admin.rooms.update', $room) }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        @method('PUT')
                        
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
                            <div>
                                <label for="name" class="block text-gray-700 text-sm font-bold mb-2">Room Name</label>
                                <input type="text" name="name" id="name" value="{{ old('name', $room->name) }}" class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:ring-2 focus:ring-indigo-500" required>
                                @error('name') <p class="text-red-500 text-xs mt-1">{{ $message }}</p> @enderror
                            </div>

                            <div>
                                <label for="type" class="block text-gray-700 text-sm font-bold mb-2">Room Type</label>
                                <select name="type" id="type" class="shadow border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:ring-2 focus:ring-indigo-500" required>
                                    <option value="Single" {{ old('type', $room->type) == 'Single' ? 'selected' : '' }}>Single</option>
                                    <option value="Double" {{ old('type', $room->type) == 'Double' ? 'selected' : '' }}>Double</option>
                                    <option value="Suite" {{ old('type', $room->type) == 'Suite' ? 'selected' : '' }}>Suite</option>
                                    <option value="Family" {{ old('type', $room->type) == 'Family' ? 'selected' : '' }}>Family</option>
                                </select>
                                @error('type') <p class="text-red-500 text-xs mt-1">{{ $message }}</p> @enderror
                            </div>

                            <div>
                                <label for="price" class="block text-gray-700 text-sm font-bold mb-2">Price (LKR)</label>
                                <input type="number" step="0.01" name="price" id="price" value="{{ old('price', $room->price) }}" class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:ring-2 focus:ring-indigo-500" required>
                                @error('price') <p class="text-red-500 text-xs mt-1">{{ $message }}</p> @enderror
                            </div>

                            <div>
                                <label for="capacity" class="block text-gray-700 text-sm font-bold mb-2">Capacity (Persons)</label>
                                <input type="number" name="capacity" id="capacity" value="{{ old('capacity', $room->capacity) }}" class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:ring-2 focus:ring-indigo-500" required>
                                @error('capacity') <p class="text-red-500 text-xs mt-1">{{ $message }}</p> @enderror
                            </div>
                        </div>

                        <div class="mb-6">
                            <label for="description" class="block text-gray-700 text-sm font-bold mb-2">Description</label>
                            <textarea name="description" id="description" class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:ring-2 focus:ring-indigo-500" rows="4">{{ old('description', $room->description) }}</textarea>
                            @error('description') <p class="text-red-500 text-xs mt-1">{{ $message }}</p> @enderror
                        </div>

                        <div class="mb-6 bg-slate-50 p-4 rounded-xl border border-slate-200">
                            <h3 class="text-slate-800 font-bold mb-4 flex items-center">
                                <svg class="w-5 h-5 mr-2 text-indigo-500" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"/></svg>
                                Images Management
                            </h3>
                            
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
                                <div>
                                    <label class="block text-gray-700 text-xs font-bold uppercase mb-2">Featured Image</label>
                                    @if($room->image)
                                        <div class="mb-3">
                                            <img src="{{ asset('storage/' . $room->image) }}" class="h-32 w-48 object-cover rounded-lg shadow-sm border-2 border-white">
                                        </div>
                                    @endif
                                    <input type="file" name="image" id="image" class="block w-full text-sm text-slate-500 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-indigo-50 file:text-indigo-700 hover:file:bg-indigo-100">
                                </div>

                                <div>
                                    <label class="block text-gray-700 text-xs font-bold uppercase mb-2">Gallery Images (Max 5 Total)</label>
                                    @if($room->images->count() > 0)
                                        <div class="flex flex-wrap gap-2 mb-3">
                                            @foreach($room->images as $img)
                                                <div class="relative group">
                                                    <img src="{{ asset('storage/' . $img->image_path) }}" class="h-16 w-16 object-cover rounded border">
                                                    <div class="absolute inset-0 bg-red-500/80 opacity-0 group-hover:opacity-100 transition rounded flex items-center justify-center">
                                                        <input type="checkbox" name="remove_gallery_images[]" value="{{ $img->id }}" class="rounded text-red-600 focus:ring-red-500">
                                                        <span class="text-[8px] text-white font-bold ml-1">DEL</span>
                                                    </div>
                                                </div>
                                            @endforeach
                                        </div>
                                    @endif
                                    <input type="file" name="gallery_images[]" id="gallery_images" multiple class="block w-full text-sm text-slate-500 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-indigo-50 file:text-indigo-700 hover:file:bg-indigo-100">
                                </div>
                            </div>
                        </div>

                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
                            <div class="bg-indigo-50/30 p-4 rounded-xl border border-indigo-100">
                                <h3 class="text-indigo-900 font-bold text-sm mb-3 border-b border-indigo-100 pb-1">Amenities</h3>
                                <div class="grid grid-cols-2 gap-2">
                                    @foreach($amenities as $amenity)
                                        <label class="flex items-center space-x-2 py-1 px-2 rounded hover:bg-white transition cursor-pointer">
                                            <input type="checkbox" name="amenities[]" value="{{ $amenity->id }}" {{ $room->amenities->contains('id', $amenity->id) ? 'checked' : '' }} class="rounded text-indigo-600 focus:ring-indigo-500">
                                            @if($amenity->icon)
                                                <img src="{{ asset('storage/' . $amenity->icon) }}" class="w-4 h-4 opacity-60">
                                            @endif
                                            <span class="text-xs text-gray-700">{{ $amenity->name }}</span>
                                        </label>
                                    @endforeach
                                </div>
                            </div>

                            <div class="bg-emerald-50/30 p-4 rounded-xl border border-emerald-100">
                                <h3 class="text-emerald-900 font-bold text-sm mb-3 border-b border-emerald-100 pb-1">Facilities</h3>
                                <div class="grid grid-cols-2 gap-2">
                                    @foreach($facilities as $facility)
                                        <label class="flex items-center space-x-2 py-1 px-2 rounded hover:bg-white transition cursor-pointer">
                                            <input type="checkbox" name="facilities[]" value="{{ $facility->id }}" {{ $room->facilities->contains('id', $facility->id) ? 'checked' : '' }} class="rounded text-emerald-600 focus:ring-emerald-500">
                                            @if($facility->icon)
                                                <img src="{{ asset('storage/' . $facility->icon) }}" class="w-4 h-4 opacity-60">
                                            @endif
                                            <span class="text-xs text-gray-700">{{ $facility->name }}</span>
                                        </label>
                                    @endforeach
                                </div>
                            </div>
                        </div>

                        <div class="mb-8 p-4 bg-slate-50 rounded-lg border border-slate-200">
                            <label class="flex items-center cursor-pointer group">
                                <div class="relative w-12 h-6 transition duration-200 ease-linear rounded-full bg-slate-300">
                                    <input type="checkbox" name="is_available" id="is_available" value="1" {{ $room->is_available ? 'checked' : '' }} class="absolute z-10 w-6 h-6 transition duration-200 ease-linear transform translate-x-0 bg-white border-2 rounded-full appearance-none cursor-pointer border-slate-300 checked:translate-x-6 checked:border-indigo-500 focus:outline-none">
                                    <div class="absolute inset-x-0 h-6 transition-colors duration-200 rounded-full bg-slate-300 group-hover:bg-slate-400"></div>
                                </div>
                                <span class="ml-4 font-bold text-slate-700">Room is Available for Reservation</span>
                            </label>
                        </div>

                        <div class="flex items-center gap-4">
                            <button type="submit" class="bg-indigo-600 hover:bg-indigo-700 text-white font-bold py-3 px-10 rounded-xl shadow-lg shadow-indigo-200 transition active:scale-95">
                                Update Room Details
                            </button>
                            <a href="{{ route('admin.rooms.index') }}" class="text-slate-500 hover:text-slate-800 font-medium transition">
                                Back to List
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
