@extends('layouts.admin')

@section('content')
    

    

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900">
                    <form action="{{ route('admin.rooms.store') }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        <div class="mb-4">
                            <label for="name" class="block text-gray-700 text-sm font-bold mb-2">Room Name</label>
                            <input type="text" name="name" id="name" class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline" required>
                        </div>

                        <div class="mb-4">
                            <label for="type" class="block text-gray-700 text-sm font-bold mb-2">Room Type</label>
                            <select name="type" id="type" class="shadow border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline" required>
                                <option value="Single">Single</option>
                                <option value="Double">Double</option>
                                <option value="Suite">Suite</option>
                                <option value="Family">Family</option>
                            </select>
                        </div>

                        <div class="mb-4">
                            <label for="price" class="block text-gray-700 text-sm font-bold mb-2">Price (LKR)</label>
                            <input type="number" step="0.01" name="price" id="price" class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline" required>
                        </div>

                        <div class="mb-4">
                            <label for="capacity" class="block text-gray-700 text-sm font-bold mb-2">Capacity</label>
                            <input type="number" name="capacity" id="capacity" class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline" required>
                        </div>

                        <div class="mb-4">
                            <label for="description" class="block text-gray-700 text-sm font-bold mb-2">Description</label>
                            <textarea name="description" id="description" class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline" rows="4"></textarea>
                        </div>

                        <div class="mb-4">
                            <label for="image" class="block text-gray-700 text-sm font-bold mb-2">Featured Image (Thumbnail)</label>
                            <input type="file" name="image" id="image" class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline">
                        </div>

                        <div class="mb-4">
                            <label for="gallery_images" class="block text-gray-700 text-sm font-bold mb-2">Gallery Images (Max 5)</label>
                            <input type="file" name="gallery_images[]" id="gallery_images" multiple class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline">
                            <p class="text-xs text-gray-500 mt-1">You can select up to 5 images.</p>
                        </div>

                        <div class="mb-6">
                            <h3 class="text-gray-700 text-sm font-bold mb-3 border-b pb-1">Amenities</h3>
                            <div class="grid grid-cols-2 md:grid-cols-4 gap-4">
                                @foreach($amenities as $amenity)
                                    <label class="inline-flex items-center space-x-2 bg-gray-50 p-2 rounded-md hover:bg-gray-100 transition cursor-pointer border border-transparent hover:border-indigo-200">
                                        <input type="checkbox" name="amenities[]" value="{{ $amenity->id }}" class="rounded text-indigo-600 focus:ring-indigo-500">
                                        @if($amenity->icon)
                                            <img src="{{ asset('storage/' . $amenity->icon) }}" class="w-5 h-5 opacity-70">
                                        @endif
                                        <span class="text-sm text-gray-700">{{ $amenity->name }}</span>
                                    </label>
                                @endforeach
                            </div>
                            @if($amenities->isEmpty())
                                <p class="text-sm text-gray-400 italic">No amenities defined. <a href="{{ route('admin.amenities.create') }}" class="text-indigo-600 underline">Add one</a></p>
                            @endif
                        </div>

                        <div class="mb-6">
                            <h3 class="text-gray-700 text-sm font-bold mb-3 border-b pb-1">Facilities</h3>
                            <div class="grid grid-cols-2 md:grid-cols-4 gap-4">
                                @foreach($facilities as $facility)
                                    <label class="inline-flex items-center space-x-2 bg-gray-50 p-2 rounded-md hover:bg-gray-100 transition cursor-pointer border border-transparent hover:border-emerald-200">
                                        <input type="checkbox" name="facilities[]" value="{{ $facility->id }}" class="rounded text-emerald-600 focus:ring-emerald-500">
                                        @if($facility->icon)
                                            <img src="{{ asset('storage/' . $facility->icon) }}" class="w-5 h-5 opacity-70">
                                        @endif
                                        <span class="text-sm text-gray-700">{{ $facility->name }}</span>
                                    </label>
                                @endforeach
                            </div>
                            @if($facilities->isEmpty())
                                <p class="text-sm text-gray-400 italic">No facilities defined. <a href="{{ route('admin.facilities.create') }}" class="text-emerald-600 underline">Add one</a></p>
                            @endif
                        </div>

                        <div class="mb-6 bg-gray-50 p-4 rounded-lg border border-gray-100">
                             <label class="inline-flex items-center cursor-pointer">
                                <input type="checkbox" name="is_available" class="rounded text-indigo-600 focus:ring-indigo-500" value="1" checked>
                                <span class="ml-2 font-medium text-gray-700">Available for Booking immediately</span>
                            </label>
                        </div>

                        <div class="flex items-center pt-4 border-t border-gray-100">
                            <button type="submit" class="bg-indigo-600 hover:bg-indigo-700 text-white font-bold py-3 px-8 rounded-lg shadow-lg hover:shadow-xl transition transform hover:-translate-y-0.5 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
                                Create Room Listing
                            </button>
                            <a href="{{ route('admin.rooms.index') }}" class="ml-4 text-gray-600 hover:text-gray-900 font-medium">Cancel</a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
