@extends('layouts.admin')

@section('content')
<div class="py-12">
    <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
        <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
            <div class="p-6 text-gray-900">
                <div class="mb-6 border-b pb-4">
                    <h2 class="text-2xl font-semibold text-gray-800">Edit Event Hall</h2>
                </div>

                <form action="{{ route('admin.halls.update', $hall->id) }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    @method('PUT')
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div class="mb-4">
                            <label for="name" class="block text-gray-700 text-sm font-bold mb-2">Hall Name</label>
                            <input type="text" name="name" id="name" value="{{ old('name', $hall->name) }}" class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline" required>
                        </div>

                        <div class="mb-4">
                            <label for="capacity" class="block text-gray-700 text-sm font-bold mb-2">Capacity (Number of guests)</label>
                            <input type="number" name="capacity" id="capacity" value="{{ old('capacity', $hall->capacity) }}" class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline" required>
                        </div>

                        <div class="mb-4">
                            <label for="price_per_day" class="block text-gray-700 text-sm font-bold mb-2">Price Per Day (LKR)</label>
                            <input type="number" step="0.01" name="price_per_day" id="price_per_day" value="{{ old('price_per_day', $hall->price_per_day) }}" class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline" required>
                        </div>

                        <div class="mb-4">
                            <label for="image" class="block text-gray-700 text-sm font-bold mb-2">Hall Image</label>
                            <input type="file" name="image" id="image" class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline">
                            @if($hall->image)
                                <div class="mt-2">
                                    <img src="{{ asset('storage/' . $hall->image) }}" class="h-20 w-32 object-cover rounded">
                                    <p class="text-xs text-gray-500 mt-1">Current image</p>
                                </div>
                            @endif
                        </div>
                    </div>

                    <div class="mb-4">
                        <label for="description" class="block text-gray-700 text-sm font-bold mb-2">Description</label>
                        <textarea name="description" id="description" class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline" rows="4">{{ old('description', $hall->description) }}</textarea>
                    </div>

                    @php $hallFeatures = $hall->features ?? []; @endphp
                    <div class="mb-6">
                        <label class="block text-gray-700 text-sm font-bold mb-2">Features</label>
                        <div class="grid grid-cols-2 md:grid-cols-4 gap-4">
                            @php
                                $availableFeatures = ['Air Conditioning', 'Sound System', 'Projector', 'Stage', 'Wifi', 'Parking'];
                            @endphp
                            @foreach($availableFeatures as $feature)
                                <label class="inline-flex items-center">
                                    <input type="checkbox" name="features[]" value="{{ $feature }}" 
                                        {{ in_array($feature, $hallFeatures) ? 'checked' : '' }}
                                        class="rounded text-indigo-600 focus:ring-indigo-500">
                                    <span class="ml-2">{{ $feature }}</span>
                                </label>
                            @endforeach
                        </div>
                    </div>

                    <div class="flex items-center space-x-4">
                        <button type="submit" class="bg-indigo-600 hover:bg-indigo-700 text-white font-bold py-2 px-6 rounded transition">
                            Update Hall
                        </button>
                        <a href="{{ route('admin.halls.index') }}" class="text-gray-600 hover:text-gray-900">Cancel</a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection
