@extends('layouts.admin')

@section('content')
    

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg mb-6">
                <div class="p-6 text-gray-900">
                    <h3 class="text-lg font-bold mb-4">Upload New Image</h3>
                    
                    @if(session('success'))
                        <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded relative mb-4">
                            {{ session('success') }}
                        </div>
                    @endif

                    <form action="{{ route('admin.gallery.store') }}" method="POST" enctype="multipart/form-data" class="flex gap-4 items-end">
                        @csrf
                        <div class="flex-1">
                            <label for="title" class="block text-sm font-medium text-gray-700 mb-1">Title (Optional)</label>
                            <input type="text" name="title" id="title" class="shadow-sm border rounded w-full py-2 px-3 text-gray-700">
                        </div>
                        <div class="flex-1">
                            <label for="category" class="block text-sm font-medium text-gray-700 mb-1">Category</label>
                            <select name="category" id="category" class="shadow-sm border rounded w-full py-2 px-3 text-gray-700" required>
                                <option value="general">General</option>
                                <option value="room">Room</option>
                                <option value="hall">Hall</option>
                                <option value="pool">Pool</option>
                                <option value="exterior">Exterior</option>
                            </select>
                        </div>
                        <div class="flex-1">
                            <label for="image" class="block text-sm font-medium text-gray-700 mb-1">Image</label>
                            <input type="file" name="image" id="image" class="shadow-sm border rounded w-full py-2 px-3 text-gray-700" required>
                        </div>
                        <button type="submit" class="bg-blue-500 hover:bg-blue-700 text-white font-bold py-2 px-6 rounded">
                            Upload
                        </button>
                    </form>
                </div>
            </div>

            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900">
                    <h3 class="text-lg font-bold mb-4">Gallery Images</h3>
                    <div class="grid grid-cols-2 md:grid-cols-4 gap-4">
                        @forelse($images as $image)
                            <div class="relative group">
                                <img src="{{ asset('storage/' . $image->image_path) }}" alt="{{ $image->title }}" class="w-full h-48 object-cover rounded">
                                <div class="absolute inset-0 bg-black bg-opacity-50 opacity-0 group-hover:opacity-100 transition-opacity flex items-center justify-center">
                                    <div class="text-white text-center">
                                        <p class="text-sm font-bold">{{ $image->title ?? 'Untitled' }}</p>
                                        <p class="text-xs">{{ ucfirst($image->category) }}</p>
                                        <form action="{{ route('admin.gallery.destroy', $image) }}" method="POST" class="mt-2" onsubmit="return confirm('Delete this image?');">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="bg-red-500 hover:bg-red-700 text-white text-xs font-bold py-1 px-3 rounded">
                                                Delete
                                            </button>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        @empty
                            <p class="col-span-4 text-center text-gray-500">No images uploaded yet.</p>
                        @endforelse
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
