@extends('layouts.admin')

@section('content')
    

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <!-- Booking Information -->
                <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                    <div class="p-6 text-gray-900">
                        <h3 class="text-lg font-bold mb-4">Reservation Info</h3>
                        <div class="grid grid-cols-2 gap-4">
                            <div>
                                <p class="text-sm text-gray-600">Check-in</p>
                                <p class="font-semibold">{{ $booking->check_in }}</p>
                            </div>
                            <div>
                                <p class="text-sm text-gray-600">Check-out</p>
                                <p class="font-semibold">{{ $booking->check_out }}</p>
                            </div>
                            <div>
                                <p class="text-sm text-gray-600">Total Price</p>
                                <p class="font-semibold text-lg text-blue-600">LKR {{ number_format($booking->total_price, 2) }}</p>
                            </div>
                            <div>
                                <p class="text-sm text-gray-600">Created At</p>
                                <p class="font-semibold">{{ $booking->created_at->format('Y-m-d H:i') }}</p>
                            </div>
                        </div>

                        <div class="mt-6 border-t pt-4">
                            <h4 class="font-bold mb-2">Guest Details</h4>
                            <p><span class="text-gray-600">Name:</span> {{ $booking->user->name }}</p>
                            <p><span class="text-gray-600">Email:</span> {{ $booking->user->email }}</p>
                        </div>
                        
                        <div class="mt-6 border-t pt-4">
                            <h4 class="font-bold mb-2">Room Details</h4>
                            <p><span class="text-gray-600">Room:</span> {{ $booking->room->name }}</p>
                            <p><span class="text-gray-600">Type:</span> {{ $booking->room->type }}</p>
                        </div>
                    </div>
                </div>

                <!-- Status Management -->
                <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                    <div class="p-6 text-gray-900">
                        <h3 class="text-lg font-bold mb-4">Manage Booking</h3>
                        
                        @if(session('success'))
                            <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded relative mb-4">
                                {{ session('success') }}
                            </div>
                        @endif

                        <form action="{{ route('admin.bookings.update', $booking) }}" method="POST">
                            @csrf
                            @method('PUT')
                            
                            <div class="mb-4">
                                <label for="status" class="block text-gray-700 text-sm font-bold mb-2">Booking Status</label>
                                <select name="status" id="status" class="shadow border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline">
                                    <option value="pending" {{ $booking->status == 'pending' ? 'selected' : '' }}>Pending</option>
                                    <option value="confirmed" {{ $booking->status == 'confirmed' ? 'selected' : '' }}>Confirmed</option>
                                    <option value="completed" {{ $booking->status == 'completed' ? 'selected' : '' }}>Completed</option>
                                    <option value="cancelled" {{ $booking->status == 'cancelled' ? 'selected' : '' }}>Cancelled</option>
                                </select>
                            </div>

                            <div class="mb-4">
                                <label for="payment_status" class="block text-gray-700 text-sm font-bold mb-2">Payment Status</label>
                                <select name="payment_status" id="payment_status" class="shadow border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline">
                                    <option value="pending" {{ $booking->payment_status == 'pending' ? 'selected' : '' }}>Pending</option>
                                    <option value="paid" {{ $booking->payment_status == 'paid' ? 'selected' : '' }}>Paid</option>
                                    <option value="failed" {{ $booking->payment_status == 'failed' ? 'selected' : '' }}>Failed</option>
                                </select>
                            </div>

                            <div class="flex items-center justify-between mt-6">
                                <button type="submit" class="bg-blue-500 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded focus:outline-none focus:shadow-outline w-full">
                                    Update Status
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
            
            <div class="mt-6">
                <a href="{{ route('admin.bookings.index') }}" class="text-gray-600 hover:text-gray-900 underline">&larr; Back to Bookings</a>
            </div>
        </div>
    </div>
@endsection
