<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('external_room_mappings', function (Blueprint $table) {
            $table->id();
            $table->foreignId('room_id')->constrained()->onDelete('cascade');
            $table->string('platform')->default('channel_manager'); // 'channel_manager', 'booking.com', 'airbnb'
            $table->string('external_id'); // Platform's room/listing ID
            $table->json('sync_settings')->nullable(); // Additional sync configuration
            $table->boolean('auto_sync')->default(true);
            $table->timestamps();
            
            $table->unique(['room_id', 'platform']);
            $table->index('external_id');
        });

        // Update bookings table to support external bookings
        Schema::table('bookings', function (Blueprint $table) {
            if (!Schema::hasColumn('bookings', 'source')) {
                $table->string('source')->default('direct')->after('id'); // 'direct', 'booking.com', 'airbnb', 'channel_manager'
            }
            if (!Schema::hasColumn('bookings', 'external_id')) {
                $table->string('external_id')->nullable()->after('source');
            }
            if (!Schema::hasColumn('bookings', 'external_data')) {
                $table->json('external_data')->nullable()->after('external_id');
            }
            if (!Schema::hasColumn('bookings', 'guest_name')) {
                $table->string('guest_name')->nullable()->after('user_id');
            }
            if (!Schema::hasColumn('bookings', 'guest_email')) {
                $table->string('guest_email')->nullable()->after('guest_name');
            }
            if (!Schema::hasColumn('bookings', 'guest_phone')) {
                $table->string('guest_phone')->nullable()->after('guest_email');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('bookings', function (Blueprint $table) {
            $table->dropColumn(['source', 'external_id', 'external_data', 'guest_name', 'guest_email', 'guest_phone']);
        });
        
        Schema::dropIfExists('external_room_mappings');
    }
};
