<?php

return [
    /*
    |--------------------------------------------------------------------------
    | Channel Manager Configuration
    |--------------------------------------------------------------------------
    |
    | Configure your channel manager API credentials here.
    | Supported: Cloudbeds, SiteMinder, Beds24, RoomRaccoon
    |
    */

    'channel_manager' => [
        'provider' => env('CHANNEL_MANAGER_PROVIDER', 'cloudbeds'), // cloudbeds, siteminder, beds24
        'property_id' => env('CHANNEL_MANAGER_PROPERTY_ID'),
        'api_key' => env('CHANNEL_MANAGER_API_KEY'),
        'api_secret' => env('CHANNEL_MANAGER_API_SECRET'),
        'base_url' => env('CHANNEL_MANAGER_BASE_URL', 'https://api.cloudbeds.com/api/v1.1/'),
        
        // Sync settings
        'auto_sync' => env('CHANNEL_MANAGER_AUTO_SYNC', true),
        'sync_interval' => env('CHANNEL_MANAGER_SYNC_INTERVAL', 15), // minutes
    ],

    // Individual platform configurations (if using direct integration)
    'booking' => [
        'hotel_id' => env('BOOKING_HOTEL_ID'),
        'username' => env('BOOKING_USERNAME'),
        'password' => env('BOOKING_PASSWORD'),
        'enabled' => env('BOOKING_ENABLED', false),
    ],

    'airbnb' => [
        'client_id' => env('AIRBNB_CLIENT_ID'),
        'client_secret' => env('AIRBNB_CLIENT_SECRET'),
        'redirect' => env('AIRBNB_REDIRECT_URI'),
        'access_token' => env('AIRBNB_ACCESS_TOKEN'),
        'enabled' => env('AIRBNB_ENABLED', false),
    ],
];
