<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        // Share snow mode setting globally with a safe check for migrations
        if (\Illuminate\Support\Facades\Schema::hasTable('settings')) {
            view()->share('snow_mode', \App\Models\Setting::getValue('snow_mode', 'off'));
        } else {
            view()->share('snow_mode', 'off');
        }
    }
}
