<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Payment extends Model
{
    protected $fillable = [
        'booking_id',
        'order_id',
        'payment_id',
        'amount',
        'currency',
        'status',
        'payment_method',
        'payhere_response',
    ];

    protected $casts = [
        'amount' => 'decimal:2',
    ];

    /**
     * Get the booking associated with the payment
     */
    public function booking(): BelongsTo
    {
        return $this->belongsTo(Booking::class);
    }
}
