<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class HallBooking extends Model
{
    protected $fillable = [
        'user_id',
        'hall_id',
        'event_date',
        'event_type',
        'total_price',
        'status',
    ];

    protected $casts = [
        'event_date' => 'date',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function hall()
    {
        return $this->belongsTo(Hall::class);
    }
}
