<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Hall extends Model
{
    protected $fillable = [
        'name',
        'capacity',
        'price_per_day',
        'description',
        'features',
        'image',
    ];

    protected $casts = [
        'features' => 'array',
    ];

    public function bookings()
    {
        return $this->hasMany(HallBooking::class);
    }
}
