<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class RoomController extends Controller
{
    public function index()
    {
        $rooms = \App\Models\Room::where('is_available', true)
            ->with(['amenities', 'facilities', 'images'])
            ->get();
        return view('rooms.index', compact('rooms'));
    }

    public function show(\App\Models\Room $room)
    {
        $room->load(['amenities', 'facilities', 'images']);
        return view('rooms.show', compact('room'));
    }
}
