<?php

namespace App\Http\Controllers;

use App\Models\Room;
use App\Services\RoomAnalysisService;
use Illuminate\Http\Request;

class RoomAnalysisController extends Controller
{
    protected $analysisService;

    public function __construct(RoomAnalysisService $analysisService)
    {
        $this->analysisService = $analysisService;
    }

    /**
     * Get AI analysis for a specific room.
     */
    public function analyze(Room $room)
    {
        try {
            $analysis = $this->analysisService->analyze($room);
            return response()->json($analysis);
        } catch (\Exception $e) {
            return response()->json([
                'error' => 'Failed to analyze room slots.',
                'message' => $e->getMessage()
            ], 500);
        }
    }
}
