<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class HomeController extends Controller
{
    public function index()
    {
        $rooms = \App\Models\Room::latest()->take(3)->get();
        $testimonials = \App\Models\Testimonial::where('is_approved', true)
            ->latest()
            ->take(3)
            ->get();
        $facilities = \App\Models\Facility::all();
        $galleryImages = \App\Models\GalleryImage::latest()->get();
        
        return view('home', compact('rooms', 'testimonials', 'facilities', 'galleryImages'));
    }
}
