<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Testimonial;
use Illuminate\Http\Request;

class TestimonialController extends Controller
{
    public function index()
    {
        $testimonials = \App\Models\Testimonial::latest()->get();
        return view('admin.testimonials.index', compact('testimonials'));
    }

    public function update(Request $request, \App\Models\Testimonial $testimonial)
    {
        $testimonial->update([
            'is_approved' => !$testimonial->is_approved
        ]);

        return redirect()->back()->with('success', 'Testimonial status updated.');
    }

    public function destroy(\App\Models\Testimonial $testimonial)
    {
        $testimonial->delete();
        return redirect()->back()->with('success', 'Testimonial deleted.');
    }
}
