<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Setting;
use Illuminate\Http\Request;

class SettingController extends Controller
{
    public function toggleSnowMode(Request $request)
    {
        $current = Setting::getValue('snow_mode', 'off');
        $newStatus = ($current === 'on') ? 'off' : 'on';
        
        Setting::updateValue('snow_mode', $newStatus);

        return response()->json([
            'status' => 'success',
            'snow_mode' => $newStatus,
            'message' => 'Christmas Snow Mode ' . ($newStatus === 'on' ? 'enabled' : 'disabled')
        ]);
    }
}
