<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Inquiry;
use Illuminate\Http\Request;

class InquiryController extends Controller
{
    /**
     * Display a listing of all inquiries.
     */
    public function index()
    {
        $inquiries = Inquiry::latest()->paginate(15);
        
        return view('admin.inquiries.index', compact('inquiries'));
    }

    /**
     * Toggle the replied status of an inquiry.
     */
    public function update(Request $request, Inquiry $inquiry)
    {
        $inquiry->update([
            'is_replied' => !$inquiry->is_replied,
            'replied_at' => !$inquiry->is_replied ? now() : null,
        ]);

        $status = $inquiry->is_replied ? 'marked as replied' : 'marked as unreplied';
        
        return redirect()->back()->with('success', "Inquiry {$status} successfully.");
    }

    /**
     * Remove the specified inquiry.
     */
    public function destroy(Inquiry $inquiry)
    {
        $inquiry->delete();
        
        return redirect()->back()->with('success', 'Inquiry deleted successfully.');
    }
}
