<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\HallBooking;

class HallBookingController extends Controller
{
    public function index()
    {
        $bookings = HallBooking::with(['user', 'hall'])->latest()->get();
        return view('admin.hall_bookings.index', compact('bookings'));
    }

    public function show(HallBooking $hallBooking)
    {
        return view('admin.hall_bookings.show', compact('hallBooking'));
    }

    public function update(Request $request, HallBooking $hallBooking)
    {
        $request->validate([
            'status' => 'required|in:pending,confirmed,cancelled,completed',
        ]);

        $hallBooking->update([
            'status' => $request->status,
        ]);

        return redirect()->back()->with('success', 'Hall booking updated successfully.');
    }
}
