<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class GalleryController extends Controller
{
    public function index()
    {
        $images = \App\Models\GalleryImage::latest()->get();
        return view('admin.gallery.index', compact('images'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'image' => 'required|image|max:2048',
            'title' => 'nullable|string|max:255',
            'category' => 'required|string',
        ]);

        $path = $request->file('image')->store('gallery', 'public');

        \App\Models\GalleryImage::create([
            'image_path' => $path,
            'title' => $request->title,
            'category' => $request->category,
        ]);

        return redirect()->back()->with('success', 'Image uploaded successfully.');
    }

    public function destroy(\App\Models\GalleryImage $gallery)
    {
        $gallery->delete();
        return redirect()->back()->with('success', 'Image deleted successfully.');
    }
}
