<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class FacilityController extends Controller
{
    public function index()
    {
        $facilities = \App\Models\Facility::latest()->get();
        return view('admin.facilities.index', compact('facilities'));
    }

    public function create()
    {
        return view('admin.facilities.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'icon' => 'nullable|file|mimes:svg,png,jpg,jpeg|max:2048',
        ]);

        $data = $request->only('name');

        if ($request->hasFile('icon')) {
            $data['icon'] = $request->file('icon')->store('facilities', 'public');
        }

        \App\Models\Facility::create($data);

        return redirect()->route('admin.facilities.index')->with('success', 'Facility created successfully.');
    }

    public function destroy(\App\Models\Facility $facility)
    {
        $facility->delete();
        return back()->with('success', 'Facility deleted.');
    }
}
